/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.exec;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exec
implements Jooby.Module {
    private static final BiConsumer<String, Executor> NOOP = (n, e) -> {};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean daemon = true;
    private int priority = 5;
    private final Map<String, Throwing.Function4<String, Integer, Supplier<ThreadFactory>, Map<String, Object>, ExecutorService>> f = ImmutableMap.of((Object)"cached", (name, n, tf, opts) -> Executors.newCachedThreadPool((ThreadFactory)tf.get()), (Object)"fixed", (name, n, tf, opts) -> Executors.newFixedThreadPool(n, (ThreadFactory)tf.get()), (Object)"scheduled", (name, n, tf, opts) -> Executors.newScheduledThreadPool(n, (ThreadFactory)tf.get()), (Object)"forkjoin", (name, n, tf, opts) -> {
        boolean asyncMode = Boolean.parseBoolean(opts.getOrDefault("asyncMode", "false").toString());
        return new ForkJoinPool((int)n, Exec.fjwtf(name), null, asyncMode);
    });
    private final String namespace;

    protected Exec(String namespace) {
        this.namespace = namespace;
    }

    public Exec() {
        this("executors");
    }

    public Exec daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public Exec priority(int priority) {
        this.priority = priority;
        return this;
    }

    public Config config() {
        return ConfigFactory.empty((String)"exec.conf").withValue(this.namespace, ConfigValueFactory.fromAnyRef((Object)"fixed"));
    }

    public void configure(Env env, Config conf, Binder binder) {
        this.configure(env, conf, binder, NOOP);
    }

    protected void configure(Env env, Config conf, Binder binder, BiConsumer<String, Executor> callback) {
        List<Map> executors = conf.hasPath(this.namespace) ? Exec.executors(conf.getValue(this.namespace), this.daemon, this.priority, Runtime.getRuntime().availableProcessors()) : Collections.emptyList();
        ArrayList<Map.Entry> services = new ArrayList<Map.Entry>(executors.size());
        for (Map options : executors) {
            String name = (String)options.remove("name");
            this.log.debug("found executor: {}{}", (Object)name, (Object)options);
            Boolean daemon = (Boolean)options.remove("daemon");
            Integer priority = (Integer)options.remove("priority");
            String type = String.valueOf(options.remove("type"));
            Integer n = (Integer)options.remove(type);
            Throwing.Function4<String, Integer, Supplier<ThreadFactory>, Map<String, Object>, ExecutorService> factory = this.f.get(type);
            if (factory == null) {
                throw new IllegalArgumentException("Unknown executor: " + type + " must be one of " + this.f.keySet());
            }
            ExecutorService executor = (ExecutorService)factory.apply((Object)type, (Object)n, () -> Exec.factory(name, daemon, priority), (Object)options);
            Exec.bind(binder, name, executor);
            callback.accept(name, executor);
            services.add(Maps.immutableEntry((Object)name, (Object)executor));
        }
        services.stream().filter(it -> ((String)it.getKey()).equals("default")).findFirst().ifPresent(e -> Exec.bind(binder, null, (ExecutorService)e.getValue()));
        env.onStop(() -> {
            services.forEach(exec -> Try.run(() -> ((ExecutorService)exec.getValue()).shutdown()).onFailure(cause -> this.log.error("shutdown of {} resulted in error", exec.getKey(), cause)));
            services.clear();
        });
    }

    private static void bind(Binder binder, String name, ExecutorService executor) {
        Class<?> klass = executor.getClass();
        Set<Class> types = Exec.collector(klass);
        for (Class type : types) {
            Key key = name == null ? Key.get((Class)type) : Key.get((Class)type, (Annotation)Names.named((String)name));
            binder.bind(key).toInstance((Object)executor);
        }
    }

    private static Set<Class> collector(Class type) {
        if (type != null && Executor.class.isAssignableFrom(type)) {
            HashSet<Class> types = new HashSet<Class>();
            if (type.isInterface() || !Modifier.isAbstract(type.getModifiers())) {
                types.add(type);
            }
            types.addAll(Exec.collector(type.getSuperclass()));
            Arrays.asList(type.getInterfaces()).forEach(it -> types.addAll(Exec.collector(it)));
            return types;
        }
        return Collections.emptySet();
    }

    private static ThreadFactory factory(String name, boolean daemon, int priority) {
        AtomicLong id = new AtomicLong(0L);
        return r -> {
            Thread thread = new Thread(r, name + "-" + id.incrementAndGet());
            thread.setDaemon(daemon);
            thread.setPriority(priority);
            return thread;
        };
    }

    private static ForkJoinPool.ForkJoinWorkerThreadFactory fjwtf(String name) {
        AtomicLong id = new AtomicLong();
        return pool -> {
            ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread.setName(name + "-" + id.incrementAndGet());
            return thread;
        };
    }

    private static List<Map<String, Object>> executors(ConfigValue candidate, boolean daemon, int priority, int n) {
        if (candidate.valueType() == ConfigValueType.STRING) {
            Map<String, Object> options = Exec.executor("default", daemon, priority, n, candidate.unwrapped());
            return ImmutableList.of(options);
        }
        ConfigObject conf = (ConfigObject)candidate;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map.Entry executor : conf.entrySet()) {
            String name = (String)executor.getKey();
            Object value = ((ConfigValue)executor.getValue()).unwrapped();
            HashMap<String, Object> options = new HashMap<String, Object>(Exec.executor(name, daemon, priority, n, value));
            result.add(options);
        }
        return result;
    }

    private static Map<String, Object> executor(String name, boolean daemon, int priority, int n, Object value) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("name", name);
        options.put("daemon", daemon);
        options.put("priority", priority);
        if (value instanceof Map) {
            Map config = (Map)value;
            Object rawType = config.get("type");
            if (rawType == null) {
                throw new IllegalArgumentException("Missing executor type");
            }
            String type = rawType.toString();
            options.put("type", type);
            options.put(type, config.containsKey("size") ? Integer.parseInt(config.get("size").toString()) : n);
            options.put("daemon", config.containsKey("daemon") ? Boolean.parseBoolean(config.get("daemon").toString()) : daemon);
            options.put("asyncMode", config.containsKey("asyncMode") && Boolean.parseBoolean(config.get("asyncMode").toString()));
            options.put("priority", config.containsKey("priority") ? Integer.parseInt(config.get("priority").toString()) : priority);
        } else {
            Iterable spec = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)value.toString());
            for (String option : spec) {
                Comparable<Boolean> optvalue;
                String optname;
                String[] opt = option.split("=");
                switch (optname = opt[0].trim()) {
                    case "daemon": {
                        optvalue = opt.length > 1 ? Boolean.parseBoolean(opt[1].trim()) : daemon;
                        break;
                    }
                    case "asyncMode": {
                        optvalue = opt.length > 1 && Boolean.parseBoolean(opt[1].trim());
                        break;
                    }
                    case "priority": {
                        optvalue = opt.length > 1 ? Integer.parseInt(opt[1].trim()) : priority;
                        break;
                    }
                    default: {
                        optvalue = opt.length > 1 ? Integer.parseInt(opt[1].trim()) : n;
                        options.put("type", optname);
                    }
                }
                options.put(optname, optvalue);
            }
        }
        return options;
    }
}

