/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.rx;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.jooby.Deferred;
import org.jooby.Env;
import org.jooby.Route;
import org.jooby.exec.Exec;
import org.jooby.rx.ExecSchedulerHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;
import rx.Observable;
import rx.Single;
import rx.Subscriber;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;
import rx.schedulers.Schedulers;

public class Rx
extends Exec {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Function<Observable, Observable> observable = Function.identity();
    private Function<Single, Single> single = Function.identity();
    private Function<Completable, Completable> completable = Function.identity();

    public Rx() {
        this.daemon(true);
    }

    public static Route.Mapper<Object> rx() {
        return Rx.rx(Function.identity(), Function.identity());
    }

    public static Route.Mapper<Object> rx(Function<Observable, Observable> observable, Function<Single, Single> single) {
        return Rx.rx(observable, single, Function.identity());
    }

    public static Route.Mapper<Object> rx(Function<Observable, Observable> observable, Function<Single, Single> single, Function<Completable, Completable> completable) {
        Objects.requireNonNull(observable, "Observable's adapter is required.");
        Objects.requireNonNull(single, "Single's adapter is required.");
        Objects.requireNonNull(completable, "Completable's adapter is required.");
        return Route.Mapper.create((String)"rx", v -> {
            if (v instanceof Observable) {
                return new Deferred(deferred -> ((Observable)observable.apply((Observable)v)).subscribe((Subscriber)new DeferredSubscriber(deferred)));
            }
            if (v instanceof Single) {
                return new Deferred(deferred -> ((Single)single.apply((Single)v)).subscribe((Subscriber)new DeferredSubscriber(deferred)));
            }
            if (v instanceof Completable) {
                return new Deferred(deferred -> ((Completable)completable.apply((Completable)v)).subscribe((Subscriber)new DeferredSubscriber(deferred)));
            }
            return v;
        });
    }

    public Rx withObservable(Function<Observable, Observable> adapter) {
        this.observable = Objects.requireNonNull(adapter, "Observable's adapter is required.");
        return this;
    }

    public Rx withSingle(Function<Single, Single> adapter) {
        this.single = Objects.requireNonNull(adapter, "Single's adapter is required.");
        return this;
    }

    public Rx withCompletable(Function<Completable, Completable> adapter) {
        this.completable = Objects.requireNonNull(adapter, "Completable's adapter is required.");
        return this;
    }

    public void configure(Env env, Config conf, Binder binder) {
        conf.getConfig("rx").withoutPath("schedulers").entrySet().forEach(e -> System.setProperty("rx." + (String)e.getKey(), ((ConfigValue)e.getValue()).unwrapped().toString()));
        HashMap<String, Executor> executors = new HashMap<String, Executor>();
        super.configure(env, conf, binder, executors::put);
        env.router().map(Rx.rx(this.observable, this.single, this.completable));
        this.trySchedulerHook(executors);
        env.onStop(() -> {
            try {
                Schedulers.shutdown();
            }
            catch (Throwable ex) {
                this.log.debug("Schedulers.shutdown() resulted in error", ex);
            }
        });
    }

    public Config config() {
        return ConfigFactory.parseResources(((Object)((Object)this)).getClass(), (String)"rx.conf");
    }

    private void trySchedulerHook(Map<String, Executor> executors) {
        block2: {
            RxJavaPlugins plugins = RxJavaPlugins.getInstance();
            try {
                plugins.registerSchedulersHook((RxJavaSchedulersHook)new ExecSchedulerHook(executors));
            }
            catch (IllegalStateException ex) {
                RxJavaSchedulersHook hook = plugins.getSchedulersHook();
                if (hook instanceof ExecSchedulerHook) break block2;
                throw ex;
            }
        }
    }

    static class DeferredSubscriber
    extends Subscriber<Object> {
        private Deferred deferred;
        private final AtomicBoolean done = new AtomicBoolean(false);

        public DeferredSubscriber(Deferred deferred) {
            this.deferred = deferred;
        }

        public void onCompleted() {
            if (this.done.compareAndSet(false, true)) {
                this.deferred.resolve(null);
            }
            this.deferred = null;
        }

        public void onError(Throwable cause) {
            this.done.set(true);
            this.deferred.reject(cause);
        }

        public void onNext(Object value) {
            if (this.done.compareAndSet(false, true)) {
                this.deferred.resolve(value);
            }
        }
    }
}

