/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

import java.util.List;
import javax.validation.constraints.Pattern;
import org.joyqueue.model.domain.BaseModel;
import org.joyqueue.model.domain.Identifier;
import org.joyqueue.model.domain.Identity;
import org.joyqueue.model.domain.User;

public class Application
extends BaseModel
implements Identifier,
Cloneable {
    public static final int JONE_SOURCE = 1;
    public static final int JDOS_SOURCE = 2;
    public static final int SURE_SOURCE = 3;
    public static final int JMQ2_SOURCE = 4;
    public static final int OTHER_SOURCE = 0;
    @Pattern(regexp="^[a-zA-Z]+[a-zA-Z0-9_-]*[a-zA-Z0-9]+$", message="Please enter correct code")
    private @Pattern(regexp="^[a-zA-Z]+[a-zA-Z0-9_-]*[a-zA-Z0-9]+$", message="Please enter correct code") String code;
    private String aliasCode;
    private String name;
    private String system;
    private String department;
    private int source;
    private int sign;
    private Identity owner;
    private String erp;
    private String description;
    private List<String> members;

    public String getErp() {
        return this.erp;
    }

    public void setErp(String erp) {
        this.erp = erp;
    }

    public Application() {
    }

    public Application(long id) {
        this.id = id;
    }

    public Application(Identity app) {
        this.id = app.getId();
        this.code = app.getCode();
        this.name = app.getName();
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    public String getAliasCode() {
        return this.aliasCode;
    }

    public void setAliasCode(String aliasCode) {
        this.aliasCode = aliasCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public int getSign() {
        return this.sign;
    }

    public void setSign(int sign) {
        this.sign = sign;
    }

    public Identity getOwner() {
        return this.owner;
    }

    public void setOwner(Identity owner) {
        this.owner = owner;
    }

    public String getDescription() {
        if (this.description == null) {
            return "-";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public boolean isOwner(User user) {
        return user != null && this.owner != null && this.owner.getId().longValue() == user.getId();
    }

    public Application clone() {
        try {
            return (Application)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return "Application{id=" + this.id + ", createBy=" + this.createBy + ", createTime=" + this.createTime + ", updateBy=" + this.updateBy + ", updateTime=" + this.updateTime + ", code='" + this.code + '\'' + ", name='" + this.name + '\'' + ", system='" + this.system + '\'' + ", department='" + this.department + '\'' + ", source=" + this.source + ", sign=" + this.sign + ", owner=" + this.owner + '}';
    }

    public static enum SourceType {
        JONE(1, "JONE"),
        JDOS(2, "JDOS"),
        SURE(3, "JDOS"),
        JMQ2(4, "JMQ2"),
        OTHER(0, "\u5176\u4ed6\u5f55\u5165");

        private int value;
        private String description;

        private SourceType(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public int value() {
            return this.value;
        }

        public String description() {
            return this.description;
        }

        public static SourceType valueOf(int value) {
            switch (value) {
                case 0: {
                    return OTHER;
                }
                case 1: {
                    return JONE;
                }
                case 2: {
                    return JDOS;
                }
                case 3: {
                    return SURE;
                }
                case 4: {
                    return JMQ2;
                }
            }
            return OTHER;
        }
    }
}

