/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

import java.util.Date;
import java.util.List;
import org.joyqueue.model.domain.BaseModel;
import org.joyqueue.model.domain.DurationTime;
import org.joyqueue.model.domain.Identity;

public abstract class Authority
extends BaseModel
implements DurationTime {
    protected Identity application;
    protected int authority;
    protected Date effectiveTime;
    protected Date expirationTime;

    public Identity getApplication() {
        return this.application;
    }

    public void setApplication(Identity application) {
        this.application = application;
    }

    public int getAuthority() {
        return this.authority;
    }

    public void setAuthority(int authority) {
        this.authority = authority;
    }

    @Override
    public Date getEffectiveTime() {
        return this.effectiveTime;
    }

    @Override
    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    @Override
    public Date getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean hasWrite() {
        return this.authority == AuthorityType.RW.value;
    }

    public static <T extends Authority> boolean validate(List<T> authorities, boolean writable) {
        if (authorities == null || authorities.isEmpty()) {
            return false;
        }
        Date now = new Date();
        for (Authority privilege : authorities) {
            if (!privilege.isEffective(now)) continue;
            AuthorityType type = AuthorityType.valueOf(privilege.getAuthority());
            if ((writable || !type.isReadable()) && (!writable || !type.isWritable())) continue;
            return true;
        }
        return false;
    }

    public static enum AuthorityType {
        R(0, "read"),
        RW(1, "read and write"){

            @Override
            public boolean isWritable() {
                return true;
            }
        };

        private int value;
        private String description;

        private AuthorityType(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public int value() {
            return this.value;
        }

        public String description() {
            return this.description;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isWritable() {
            return false;
        }

        public static AuthorityType valueOf(int type) {
            switch (type) {
                case 1: {
                    return RW;
                }
            }
            return R;
        }
    }
}

