/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.joyqueue.model.domain.BaseModel;
import org.joyqueue.model.domain.Identity;

public class Broker
extends BaseModel {
    public static final String DEFAULT_RETRY_TYPE = "RemoteRetry";
    public static final String PERMISSION_FULL = "FULL";
    public static final String PERMISSION_READ = "READ";
    public static final String PERMISSION_WRITE = "WRITE";
    public static final String PERMISSION_NONE = "NONE";
    public static final String DEFAULT_PERMISSION = "FULL";
    private Identity dataCenter;
    private String region;
    private Identity host;
    @NotNull(message="The ip can not be null")
    private @NotNull(message="The ip can not be null") String ip;
    @NotNull(message="The port can not be null")
    @Min(value=100L, message="Please enter 100 to 65535")
    @Max(value=65535L, message="Please enter 100 to 65535")
    private @NotNull(message="The port can not be null") @Min(value=100L, message="Please enter 100 to 65535") @Max(value=65535L, message="Please enter 100 to 65535") int port = 50088;
    private Identity group;
    private String retryType;
    private String description;
    private String permission = "FULL";

    public Broker() {
    }

    public Broker(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int getManagementPort() {
        return this.port % 10000 + 10000;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip.trim();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public int getBackEndPort() {
        return this.port + 1;
    }

    public int getMonitorPort() {
        return this.port + 2;
    }

    public int getNameserverPort() {
        return this.port + 3;
    }

    public String getRetryType() {
        return this.retryType;
    }

    public void setRetryType(String retryType) {
        this.retryType = retryType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Identity getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(Identity dataCenter) {
        this.dataCenter = dataCenter;
    }

    public Identity getHost() {
        return this.host;
    }

    public void setHost(Identity host) {
        this.host = host;
    }

    public Identity getGroup() {
        return this.group;
    }

    public void setGroup(Identity group) {
        this.group = group;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Broker broker = (Broker)o;
        return new EqualsBuilder().append(this.id, broker.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).toHashCode();
    }
}

