/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

import java.util.Calendar;
import java.util.Date;

public interface DurationTime {
    public Date getEffectiveTime();

    public void setEffectiveTime(Date var1);

    public Date getExpirationTime();

    public void setExpirationTime(Date var1);

    default public boolean isEffective(Date time) {
        if (time == null) {
            return false;
        }
        Date effectiveTime = this.getEffectiveTime();
        Date expirationTime = this.getExpirationTime();
        if (effectiveTime != null && effectiveTime.after(time)) {
            return false;
        }
        return expirationTime == null || !expirationTime.before(time);
    }

    default public void initializeTime() {
        this.initializeTime(10);
    }

    default public void initializeTime(int expireYears) {
        Date now = new Date();
        if (this.getEffectiveTime() == null) {
            this.setEffectiveTime(now);
        }
        if (this.getExpirationTime() == null) {
            Calendar cd = Calendar.getInstance();
            cd.setTime(now);
            cd.add(1, expireYears);
            this.setExpirationTime(cd.getTime());
        }
    }
}

