/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.model.domain;

import org.joyqueue.model.domain.BaseModel;
import org.joyqueue.model.domain.EnumItem;
import org.joyqueue.model.domain.EnumType;
import org.joyqueue.model.domain.Identifier;

public class Metric
extends BaseModel
implements Identifier,
Cloneable {
    private String code;
    private String aliasCode;
    private String name;
    private Integer type;
    private String source;
    private String description;
    private String provider;
    private boolean userPermission;
    private String category;
    private int collectInterval;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getAliasCode() {
        return this.aliasCode;
    }

    public void setAliasCode(String aliasCode) {
        this.aliasCode = aliasCode;
    }

    @EnumType(value=MetricType.class)
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public boolean isUserPermission() {
        return this.userPermission;
    }

    public void setUserPermission(boolean userPermission) {
        this.userPermission = userPermission;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getCollectInterval() {
        return this.collectInterval;
    }

    public void setCollectInterval(int collectInterval) {
        this.collectInterval = collectInterval;
    }

    public static enum MetricType implements EnumItem
    {
        OTHERS(0, "others"),
        ATOMIC(1, "atomic"),
        AGGREGATOR(2, "aggregator");

        private int value;
        private String description;

        private MetricType(int value, String description) {
            this.value = value;
            this.description = description;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public String description() {
            return this.description;
        }

        public static MetricType resolve(int value) {
            for (MetricType type : MetricType.values()) {
                if (type.value() != value) continue;
                return type;
            }
            return OTHERS;
        }

        public static MetricType resolve(String descOrName) {
            for (MetricType type : MetricType.values()) {
                if (!type.description().equals(descOrName) && !type.name().equals(descOrName)) continue;
                return type;
            }
            return OTHERS;
        }
    }
}

