/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.cache;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.mapstruct.ap.shaded.freemarker.cache.CacheStorage;
import org.mapstruct.ap.shaded.freemarker.cache.ConcurrentCacheStorage;
import org.mapstruct.ap.shaded.freemarker.cache.FileTemplateLoader;
import org.mapstruct.ap.shaded.freemarker.cache.MultiTemplateLoader;
import org.mapstruct.ap.shaded.freemarker.cache.SoftCacheStorage;
import org.mapstruct.ap.shaded.freemarker.cache.StatefulTemplateLoader;
import org.mapstruct.ap.shaded.freemarker.cache.TemplateLoader;
import org.mapstruct.ap.shaded.freemarker.cache.URLTemplateSource;
import org.mapstruct.ap.shaded.freemarker.core.BugException;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.log.Logger;
import org.mapstruct.ap.shaded.freemarker.template.Configuration;
import org.mapstruct.ap.shaded.freemarker.template.Template;
import org.mapstruct.ap.shaded.freemarker.template._TemplateAPI;
import org.mapstruct.ap.shaded.freemarker.template.utility.NullArgumentException;
import org.mapstruct.ap.shaded.freemarker.template.utility.StringUtil;
import org.mapstruct.ap.shaded.freemarker.template.utility.UndeclaredThrowableException;

public class TemplateCache {
    private static final String ASTERISKSTR = "*";
    private static final String LOCALE_SEPARATOR = "_";
    private static final char ASTERISK = '*';
    private static final String CURRENT_DIR_PATH_PREFIX = "./";
    private static final String CURRENT_DIR_PATH = "/./";
    private static final String PARENT_DIR_PATH_PREFIX = "../";
    private static final String PARENT_DIR_PATH = "/../";
    private static final char SLASH = '/';
    private static final Logger logger = Logger.getLogger("org.mapstruct.ap.shaded.freemarker.cache");
    private final TemplateLoader templateLoader;
    private final CacheStorage storage;
    private final boolean isStorageConcurrent;
    private long delay = 5000L;
    private boolean localizedLookup = true;
    private Configuration config;
    private static final Method INIT_CAUSE = TemplateCache.getInitCauseMethod();

    public TemplateCache() {
        this(TemplateCache.createLegacyDefaultTemplateLoader());
    }

    protected static TemplateLoader createLegacyDefaultTemplateLoader() {
        try {
            return new FileTemplateLoader();
        }
        catch (Exception e) {
            logger.warn("Could not create a file template loader for current directory", e);
            return null;
        }
    }

    public TemplateCache(TemplateLoader templateLoader) {
        this(templateLoader, (Configuration)null);
    }

    public TemplateCache(TemplateLoader templateLoader, CacheStorage cacheStorage) {
        this(templateLoader, cacheStorage, null);
    }

    public TemplateCache(TemplateLoader defaultTemplateLoader, Configuration config) {
        this(defaultTemplateLoader, new SoftCacheStorage(), config);
    }

    public TemplateCache(TemplateLoader templateLoader, CacheStorage cacheStorage, Configuration config) {
        this.templateLoader = templateLoader;
        if (cacheStorage == null) {
            throw new IllegalArgumentException("storage == null");
        }
        this.storage = cacheStorage;
        this.isStorageConcurrent = cacheStorage instanceof ConcurrentCacheStorage && ((ConcurrentCacheStorage)cacheStorage).isConcurrent();
        this.config = config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.clear();
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public CacheStorage getCacheStorage() {
        return this.storage;
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parseAsFTL) throws IOException {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (locale == null) {
            throw new NullArgumentException("locale");
        }
        if (encoding == null) {
            throw new NullArgumentException("encoding");
        }
        if ((name = TemplateCache.normalizeName(name)) == null) {
            return null;
        }
        return this.templateLoader != null ? this.getTemplate(this.templateLoader, name, locale, encoding, parseAsFTL) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Template getTemplate(TemplateLoader loader, String name, Locale locale, String encoding, boolean parse) throws IOException {
        debug = TemplateCache.logger.isDebugEnabled();
        debugName = debug != false ? this.buildDebugName(name, locale, encoding, parse) : null;
        tk = new TemplateKey(name, locale, encoding, parse);
        if (this.isStorageConcurrent) {
            cachedTemplate = (CachedTemplate)this.storage.get(tk);
        } else {
            var10_10 = this.storage;
            synchronized (var10_10) {
                cachedTemplate = (CachedTemplate)this.storage.get(tk);
            }
        }
        now = System.currentTimeMillis();
        lastModified = -1L;
        newlyFoundSource = null;
        rethrown = false;
        try {
            if (cachedTemplate == null) ** GOTO lbl74
            if (now - cachedTemplate.lastChecked >= this.delay) ** GOTO lbl46
            if (debug) {
                TemplateCache.logger.debug(debugName + " cached copy not yet stale; using cached.");
            }
            if ((t = cachedTemplate.templateOrException) instanceof Template || t == null) {
                var19_22 = (Template)t;
                if (newlyFoundSource == null) return var19_22;
            }
            ** GOTO lbl-1000
        }
        catch (RuntimeException e) {
            try {
                if (cachedTemplate == null) throw e;
                this.storeNegativeLookup(tk, cachedTemplate, e);
                throw e;
                catch (IOException e) {
                    if (rethrown != false) throw e;
                    this.storeNegativeLookup(tk, cachedTemplate, e);
                    throw e;
                }
            }
            catch (Throwable var21_27) {
                if (newlyFoundSource == null) throw var21_27;
                loader.closeTemplateSource(newlyFoundSource);
                throw var21_27;
            }
        }
        loader.closeTemplateSource(newlyFoundSource);
        return var19_22;
lbl-1000:
        // 1 sources

        {
            if (t instanceof RuntimeException) {
                this.throwLoadFailedException((RuntimeException)t);
                throw new BugException("t is " + t.getClass().getName());
            }
            if (t instanceof IOException == false) throw new BugException("t is " + t.getClass().getName());
            rethrown = true;
            this.throwLoadFailedException((IOException)t);
            throw new BugException("t is " + t.getClass().getName());
lbl46:
            // 1 sources

            cachedTemplate = cachedTemplate.cloneCachedTemplate();
            cachedTemplate.lastChecked = now;
            newlyFoundSource = this.findTemplateSource(name, locale);
            if (newlyFoundSource != null) ** GOTO lbl-1000
            if (debug) {
                TemplateCache.logger.debug(debugName + " no source found.");
            }
            this.storeNegativeLookup(tk, cachedTemplate, null);
            t = null;
            if (newlyFoundSource == null) return t;
        }
        loader.closeTemplateSource(newlyFoundSource);
        return t;
lbl-1000:
        // 1 sources

        {
            lastModified = loader.getLastModified(newlyFoundSource);
            lastModifiedNotChanged = lastModified == cachedTemplate.lastModified;
            sourceEquals = newlyFoundSource.equals(cachedTemplate.source);
            if (!lastModifiedNotChanged || !sourceEquals) ** GOTO lbl-1000
            if (debug) {
                TemplateCache.logger.debug(debugName + " using cached since " + newlyFoundSource + " didn't change.");
            }
            this.storeCached(tk, cachedTemplate);
            var20_25 = (Template)cachedTemplate.templateOrException;
            if (newlyFoundSource == null) return var20_25;
        }
        loader.closeTemplateSource(newlyFoundSource);
        return var20_25;
lbl-1000:
        // 1 sources

        {
            if (debug && !sourceEquals) {
                TemplateCache.logger.debug("Updating source, info for cause: sourceEquals=" + sourceEquals + ", newlyFoundSource=" + StringUtil.jQuoteNoXSS(newlyFoundSource) + ", cachedTemplate.source=" + StringUtil.jQuoteNoXSS(cachedTemplate.source));
            }
            if (debug && !lastModifiedNotChanged) {
                TemplateCache.logger.debug("Updating source, info for cause: lastModifiedNotChanged=" + lastModifiedNotChanged + ", cache lastModified=" + cachedTemplate.lastModified + " != file lastModified=" + lastModified);
            }
            cachedTemplate.source = newlyFoundSource;
            ** GOTO lbl88
lbl74:
            // 1 sources

            if (debug) {
                TemplateCache.logger.debug("Could not find template in cache, creating new one; id=[" + StringUtil.jQuoteNoXSS(TemplateKey.access$000(tk)) + "[" + StringUtil.jQuoteNoXSS(TemplateKey.access$100(tk)) + "," + TemplateKey.access$200(tk) + (TemplateKey.access$300(tk) != false ? ",parsed] " : ",unparsed] ") + "]");
            }
            cachedTemplate = new CachedTemplate();
            cachedTemplate.lastChecked = now;
            newlyFoundSource = this.findTemplateSource(name, locale);
            if (newlyFoundSource != null) ** GOTO lbl-1000
            this.storeNegativeLookup(tk, cachedTemplate, null);
            lastModifiedNotChanged = null;
            if (newlyFoundSource == null) return lastModifiedNotChanged;
        }
        loader.closeTemplateSource(newlyFoundSource);
        return lastModifiedNotChanged;
lbl-1000:
        // 1 sources

        {
            cachedTemplate.source = newlyFoundSource;
            lastModified = -9223372036854775808L;
            cachedTemplate.lastModified = -9223372036854775808L;
lbl88:
            // 2 sources

            if (debug) {
                TemplateCache.logger.debug("Compiling FreeMarker template " + debugName + " from " + StringUtil.jQuoteNoXSS(newlyFoundSource));
            }
            source = cachedTemplate.source;
            t = this.loadTemplate(loader, name, locale, encoding, parse, source);
            cachedTemplate.templateOrException = t;
            cachedTemplate.lastModified = lastModified == -9223372036854775808L ? loader.getLastModified(source) : lastModified;
            this.storeCached(tk, cachedTemplate);
            var20_26 = t;
            if (newlyFoundSource == null) return var20_26;
        }
        loader.closeTemplateSource(newlyFoundSource);
        return var20_26;
    }

    private static final Method getInitCauseMethod() {
        try {
            return Throwable.class.getMethod("initCause", Throwable.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void throwLoadFailedException(Exception e) throws IOException {
        IOException ioe;
        if (INIT_CAUSE != null) {
            ioe = new IOException("There was an error loading the template on an earlier attempt; it's attached as a cause");
            try {
                INIT_CAUSE.invoke((Object)ioe, e);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        } else {
            ioe = new IOException("There was an error loading the template on an earlier attempt: " + e.getClass().getName() + ": " + e.getMessage());
        }
        throw ioe;
    }

    private void storeNegativeLookup(TemplateKey tk, CachedTemplate cachedTemplate, Exception e) {
        cachedTemplate.templateOrException = e;
        cachedTemplate.source = null;
        cachedTemplate.lastModified = 0L;
        this.storeCached(tk, cachedTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCached(TemplateKey tk, CachedTemplate cachedTemplate) {
        if (this.isStorageConcurrent) {
            this.storage.put(tk, cachedTemplate);
        } else {
            CacheStorage cacheStorage = this.storage;
            synchronized (cacheStorage) {
                this.storage.put(tk, cachedTemplate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template loadTemplate(TemplateLoader loader, String name, Locale locale, String encoding, boolean parse, Object source) throws IOException {
        Template template;
        Reader reader = loader.getReader(source, encoding);
        try {
            if (parse) {
                try {
                    template = new Template(name, reader, this.config, encoding);
                }
                catch (Template.WrongEncodingException wee) {
                    encoding = wee.specifiedEncoding;
                    reader.close();
                    reader = loader.getReader(source, encoding);
                    template = new Template(name, reader, this.config, encoding);
                }
                template.setLocale(locale);
            } else {
                StringWriter sw = new StringWriter();
                char[] buf = new char[4096];
                while (true) {
                    int charsRead;
                    if ((charsRead = reader.read(buf)) > 0) {
                        sw.write(buf, 0, charsRead);
                        continue;
                    }
                    if (charsRead == -1) break;
                }
                template = Template.getPlainTextTemplate(name, sw.toString(), this.config);
                template.setLocale(locale);
            }
            template.setEncoding(encoding);
        }
        finally {
            reader.close();
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDelay() {
        TemplateCache templateCache = this;
        synchronized (templateCache) {
            return this.delay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelay(long delay) {
        TemplateCache templateCache = this;
        synchronized (templateCache) {
            this.delay = delay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLocalizedLookup() {
        TemplateCache templateCache = this;
        synchronized (templateCache) {
            return this.localizedLookup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalizedLookup(boolean localizedLookup) {
        TemplateCache templateCache = this;
        synchronized (templateCache) {
            this.localizedLookup = localizedLookup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CacheStorage cacheStorage = this.storage;
        synchronized (cacheStorage) {
            this.storage.clear();
            if (this.templateLoader instanceof StatefulTemplateLoader) {
                ((StatefulTemplateLoader)this.templateLoader).resetState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplate(String name, Locale locale, String encoding, boolean parse) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Argument \"name\" can't be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Argument \"locale\" can't be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("Argument \"encoding\" can't be null");
        }
        if ((name = TemplateCache.normalizeName(name)) != null && this.templateLoader != null) {
            boolean debug = logger.isDebugEnabled();
            String debugName = debug ? this.buildDebugName(name, locale, encoding, parse) : null;
            TemplateKey tk = new TemplateKey(name, locale, encoding, parse);
            if (this.isStorageConcurrent) {
                this.storage.remove(tk);
            } else {
                CacheStorage cacheStorage = this.storage;
                synchronized (cacheStorage) {
                    this.storage.remove(tk);
                }
            }
            logger.debug(debugName + " was removed from the cache, if it was there");
        }
    }

    private String buildDebugName(String name, Locale locale, String encoding, boolean parse) {
        return StringUtil.jQuoteNoXSS(name) + "[" + StringUtil.jQuoteNoXSS(locale) + "," + encoding + (parse ? ",parsed] " : ",unparsed]");
    }

    public static String getFullTemplatePath(Environment env, String currentTemplateDir, String targetTemplatePath) {
        if (!env.isClassicCompatible()) {
            if (targetTemplatePath.indexOf("://") > 0) {
                return targetTemplatePath;
            }
            if (targetTemplatePath.startsWith("/")) {
                int schemeSepIdx = currentTemplateDir.indexOf("://");
                if (schemeSepIdx > 0) {
                    return currentTemplateDir.substring(0, schemeSepIdx + 2) + targetTemplatePath;
                }
                return targetTemplatePath.substring(1);
            }
            return currentTemplateDir + targetTemplatePath;
        }
        return targetTemplatePath;
    }

    private Object findTemplateSource(String name, Locale locale) throws IOException {
        if (this.localizedLookup) {
            int lastDot = name.lastIndexOf(46);
            String prefix = lastDot == -1 ? name : name.substring(0, lastDot);
            String suffix = lastDot == -1 ? "" : name.substring(lastDot);
            String localeName = LOCALE_SEPARATOR + locale.toString();
            StringBuffer buf = new StringBuffer(name.length() + localeName.length());
            buf.append(prefix);
            while (true) {
                buf.setLength(prefix.length());
                String path = buf.append(localeName).append(suffix).toString();
                Object templateSource = this.acquireTemplateSource(path);
                if (templateSource != null) {
                    return templateSource;
                }
                int lastUnderscore = localeName.lastIndexOf(95);
                if (lastUnderscore == -1) break;
                localeName = localeName.substring(0, lastUnderscore);
            }
            return null;
        }
        return this.acquireTemplateSource(name);
    }

    private Object acquireTemplateSource(String path) throws IOException {
        int asterisk = path.indexOf(42);
        if (asterisk == -1) {
            return this.modifyForConfIcI(this.templateLoader.findTemplateSource(path));
        }
        StringTokenizer tok = new StringTokenizer(path, "/");
        int lastAsterisk = -1;
        ArrayList<String> tokpath = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String pathToken = tok.nextToken();
            if (pathToken.equals(ASTERISKSTR)) {
                if (lastAsterisk != -1) {
                    tokpath.remove(lastAsterisk);
                }
                lastAsterisk = tokpath.size();
            }
            tokpath.add(pathToken);
        }
        if (lastAsterisk == -1) {
            return this.modifyForConfIcI(this.templateLoader.findTemplateSource(path));
        }
        String basePath = this.concatPath(tokpath, 0, lastAsterisk);
        String resourcePath = this.concatPath(tokpath, lastAsterisk + 1, tokpath.size());
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        StringBuffer buf = new StringBuffer(path.length()).append(basePath);
        int l = basePath.length();
        boolean debug = logger.isDebugEnabled();
        while (true) {
            Object templateSource;
            String fullPath = buf.append(resourcePath).toString();
            if (debug) {
                logger.debug("Trying to find template source " + StringUtil.jQuoteNoXSS(fullPath));
            }
            if ((templateSource = this.modifyForConfIcI(this.templateLoader.findTemplateSource(fullPath))) != null) {
                return templateSource;
            }
            if (l == 0) {
                return null;
            }
            l = basePath.lastIndexOf(47, l - 2) + 1;
            buf.setLength(l);
        }
    }

    private Object modifyForConfIcI(Object templateSource) {
        if (templateSource == null) {
            return null;
        }
        if (this.config.getIncompatibleImprovements().intValue() < _TemplateAPI.VERSION_INT_2_3_21) {
            return templateSource;
        }
        if (templateSource instanceof URLTemplateSource) {
            URLTemplateSource urlTemplateSource = (URLTemplateSource)templateSource;
            if (urlTemplateSource.getUseCaches() == null) {
                urlTemplateSource.setUseCaches(false);
            }
        } else if (templateSource instanceof MultiTemplateLoader.MultiSource) {
            this.modifyForConfIcI(((MultiTemplateLoader.MultiSource)templateSource).getWrappedSource());
        }
        return templateSource;
    }

    private String concatPath(List path, int from, int to) {
        StringBuffer buf = new StringBuffer((to - from) * 16);
        for (int i = from; i < to; ++i) {
            buf.append(path.get(i)).append('/');
        }
        return buf.toString();
    }

    private static String normalizeName(String name) {
        if (name.indexOf(0) != -1) {
            return null;
        }
        while (true) {
            int parentDirPathLoc;
            if ((parentDirPathLoc = name.indexOf(PARENT_DIR_PATH)) == 0) {
                return null;
            }
            if (parentDirPathLoc == -1) {
                if (!name.startsWith(PARENT_DIR_PATH_PREFIX)) break;
                return null;
            }
            int previousSlashLoc = name.lastIndexOf(47, parentDirPathLoc - 1);
            name = name.substring(0, previousSlashLoc + 1) + name.substring(parentDirPathLoc + PARENT_DIR_PATH.length());
        }
        while (true) {
            int currentDirPathLoc;
            if ((currentDirPathLoc = name.indexOf(CURRENT_DIR_PATH)) == -1) {
                if (!name.startsWith(CURRENT_DIR_PATH_PREFIX)) break;
                name = name.substring(CURRENT_DIR_PATH_PREFIX.length());
                break;
            }
            name = name.substring(0, currentDirPathLoc) + name.substring(currentDirPathLoc + CURRENT_DIR_PATH.length() - 1);
        }
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return name;
    }

    private static final class CachedTemplate
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        Object templateOrException;
        Object source;
        long lastChecked;
        long lastModified;

        private CachedTemplate() {
        }

        public CachedTemplate cloneCachedTemplate() {
            try {
                return (CachedTemplate)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
    }

    private static final class TemplateKey {
        private final String name;
        private final Locale locale;
        private final String encoding;
        private final boolean parse;

        TemplateKey(String name, Locale locale, String encoding, boolean parse) {
            this.name = name;
            this.locale = locale;
            this.encoding = encoding;
            this.parse = parse;
        }

        public boolean equals(Object o) {
            if (o instanceof TemplateKey) {
                TemplateKey tk = (TemplateKey)o;
                return this.parse == tk.parse && this.name.equals(tk.name) && this.locale.equals(tk.locale) && this.encoding.equals(tk.encoding);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.locale.hashCode() ^ this.encoding.hashCode() ^ Boolean.valueOf(!this.parse).hashCode();
        }

        static /* synthetic */ String access$000(TemplateKey x0) {
            return x0.name;
        }

        static /* synthetic */ Locale access$100(TemplateKey x0) {
            return x0.locale;
        }

        static /* synthetic */ String access$200(TemplateKey x0) {
            return x0.encoding;
        }

        static /* synthetic */ boolean access$300(TemplateKey x0) {
            return x0.parse;
        }
    }
}

