package org.quickjava.common.enums;

public enum DatetimeRangeType {
    // 今天日期时间范围（如：2023-03-15 00:00:00 到 2023-03-15 23:59:59
    TODAY,
    // 昨天（如：2023-03-14 00:00:00 到 2023-03-14 23:59:59
    YESTERDAY,
    // 这周（如：2023-03-13 00:00:00 到 2023-03-19 23:59:59
    WEEK,
    // 上周（如：2023-03-06 00:00:00 到 2023-03-12 23:59:59
    LAST_WEEK,
    // 这个月（如：2023-03-01 00:00:00 到 2023-03-31 23:59:59
    MONTH,
    // 上个月（如：2023-02-01 00:00:00 到 2023-02-28 23:59:59
    LAST_MONTH,
    // 今年（如：2023-01-01 00:00:00 到 2023-12-31 23:59:59
    YEAR,
    // 去年（如：2022-01-01 00:00:00 到 2022-12-31 23:59:59
    LAST_YEAR,
    ;
}
