/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Delimiter;
import org.refcodes.struct.CanonicalMapImpl;
import org.refcodes.struct.InterOperableMap;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;

public interface CanonicalMap
extends InterOperableMap<String> {
    default public String[] asArray(Object object) {
        return this.asArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public String[] asArray(Object object, char c) {
        return this.asArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public String[] asArray(String string) {
        return this.asArray(string, Delimiter.LIST.getChar());
    }

    default public String[] asArray(String string, char c) {
        String[] stringArray = null;
        String string2 = (String)this.get((Object)string);
        if (string2 != null && string2.length() != 0) {
            stringArray = string2.split(Pattern.quote("" + c));
        }
        return stringArray;
    }

    default public boolean[] asBooleanArray(Object object) throws NumberFormatException {
        return this.asBooleanArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public boolean[] asBooleanArray(Object object, char c) throws NumberFormatException {
        return this.asBooleanArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public boolean[] asBooleanArray(String string) throws NumberFormatException {
        return this.asBooleanArray(string, Delimiter.LIST.getChar());
    }

    default public boolean[] asBooleanArray(String string, char c) throws NumberFormatException {
        boolean[] blArray = null;
        Object[] objectArray = this.asArray(string, c);
        if (objectArray != null) {
            blArray = new boolean[objectArray.length];
            block0: for (int i = 0; i < objectArray.length; ++i) {
                for (String string2 : BooleanLiterals.TRUE.getNames()) {
                    if (!string2.equalsIgnoreCase(objectArray[i].trim())) continue;
                    blArray[i] = true;
                    continue block0;
                }
                for (String string2 : BooleanLiterals.FALSE.getNames()) {
                    if (!string2.equalsIgnoreCase(((String)objectArray[i]).trim())) continue;
                    blArray[i] = false;
                    continue block0;
                }
                throw new NumberFormatException("Unable to parse boolean from key <" + string + "> using delimiter '" + c + "' at position <" + i + "> of the array <" + Arrays.toString(objectArray) + ">!");
            }
        }
        return blArray;
    }

    default public byte[] asByteArray(Object object) throws NumberFormatException {
        return this.asByteArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public byte[] asByteArray(Object object, char c) throws NumberFormatException {
        return this.asByteArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public byte[] asByteArray(String string) throws NumberFormatException {
        return this.asByteArray(string, Delimiter.LIST.getChar());
    }

    default public byte[] asByteArray(String string, char c) throws NumberFormatException {
        byte[] byArray = null;
        String[] stringArray = this.asArray(string, c);
        if (stringArray != null) {
            byArray = new byte[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.endsWith(".0")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                byArray[i] = Byte.valueOf(string2);
            }
        }
        return byArray;
    }

    default public char[] asCharArray(Object object) throws NumberFormatException {
        return this.asCharArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public char[] asCharArray(Object object, char c) throws NumberFormatException {
        return this.asCharArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public char[] asCharArray(String string) throws NumberFormatException {
        return this.asCharArray(string, Delimiter.LIST.getChar());
    }

    default public char[] asCharArray(String string, char c) throws NumberFormatException {
        char[] cArray = null;
        Object[] objectArray = this.asArray(string, c);
        if (objectArray != null) {
            cArray = new char[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = objectArray[i].trim();
                if (string2.length() == 0) {
                    string2 = objectArray[i];
                }
                if (string2.length() != 1) {
                    throw new NumberFormatException("Unable to convert from key <" + string + "> using delimiter '" + c + "' at position <" + i + "> of the array <" + Arrays.toString(objectArray) + ">!");
                }
                cArray[i] = string2.charAt(0);
            }
        }
        return cArray;
    }

    default public double[] asDoubleArray(Object object) throws NumberFormatException {
        return this.asDoubleArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public double[] asDoubleArray(Object object, char c) throws NumberFormatException {
        return this.asDoubleArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public double[] asDoubleArray(String string) throws NumberFormatException {
        return this.asDoubleArray(string, Delimiter.LIST.getChar());
    }

    default public double[] asDoubleArray(String string, char c) throws NumberFormatException {
        double[] dArray = null;
        String[] stringArray = this.asArray(string, c);
        if (stringArray != null) {
            dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i] = Double.valueOf(stringArray[i].trim());
            }
        }
        return dArray;
    }

    default public float[] asFloatArray(Object object) throws NumberFormatException {
        return this.asFloatArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public float[] asFloatArray(Object object, char c) throws NumberFormatException {
        return this.asFloatArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public float[] asFloatArray(String string) throws NumberFormatException {
        return this.asFloatArray(string, Delimiter.LIST.getChar());
    }

    default public float[] asFloatArray(String string, char c) throws NumberFormatException {
        float[] fArray = null;
        String[] stringArray = this.asArray(string, c);
        if (stringArray != null) {
            fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.valueOf(stringArray[i].trim()).floatValue();
            }
        }
        return fArray;
    }

    default public int[] asIntArray(Object object) throws NumberFormatException {
        return this.asIntArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public int[] asIntArray(Object object, char c) throws NumberFormatException {
        return this.asIntArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public int[] asIntArray(String string) throws NumberFormatException {
        return this.asIntArray(string, Delimiter.LIST.getChar());
    }

    default public int[] asIntArray(String string, char c) throws NumberFormatException {
        int[] nArray = null;
        String[] stringArray = this.asArray(string, c);
        if (stringArray != null) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.endsWith(".0")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                nArray[i] = Integer.valueOf(string2);
            }
        }
        return nArray;
    }

    default public long[] asLongArray(Object object) throws NumberFormatException {
        return this.asLongArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public long[] asLongArray(Object object, char c) throws NumberFormatException {
        return this.asLongArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public long[] asLongArray(String string) throws NumberFormatException {
        return this.asLongArray(string, Delimiter.LIST.getChar());
    }

    default public long[] asLongArray(String string, char c) throws NumberFormatException {
        long[] lArray = null;
        String[] stringArray = this.asArray(string, c);
        if (stringArray != null) {
            lArray = new long[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.endsWith(".0")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                lArray[i] = Long.valueOf(string2);
            }
        }
        return lArray;
    }

    default public short[] asShortArray(Object object) throws NumberFormatException {
        return this.asShortArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public short[] asShortArray(Object object, char c) throws NumberFormatException {
        return this.asShortArray(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public short[] asShortArray(String string) throws NumberFormatException {
        return this.asShortArray(string, Delimiter.LIST.getChar());
    }

    default public short[] asShortArray(String string, char c) throws NumberFormatException {
        short[] sArray = null;
        String[] stringArray = this.asArray(string, c);
        if (stringArray != null) {
            sArray = new short[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.endsWith(".0")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                sArray[i] = Short.valueOf(string2);
            }
        }
        return sArray;
    }

    @Override
    default public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    default public CanonicalMap getDirAt(String[] stringArray, int n) {
        return this.getDirAt(this.toPath(stringArray), n);
    }

    default public CanonicalMap getDirAt(int n) {
        return this.getDirAt(this.getRootPath(), n);
    }

    default public CanonicalMap getDirAt(String string, int n) {
        return this.retrieveFrom(this.toPath(string, "" + n));
    }

    default public CanonicalMap getDirAt(Collection<?> collection, int n) {
        return this.getDirAt(this.toPath(collection), n);
    }

    default public CanonicalMap getDirAt(Object object, int n) {
        return this.getDirAt(this.toPath(object), n);
    }

    default public CanonicalMap getDirAt(Object[] objectArray, int n) {
        return this.getDirAt(this.toPath(objectArray), n);
    }

    default public CanonicalMap query(Collection<?> collection) {
        return this.query(this.toPath(collection));
    }

    default public CanonicalMap query(Object ... objectArray) {
        return this.query(this.toPath(objectArray));
    }

    default public CanonicalMap query(Pattern pattern) {
        return new CanonicalMapImpl(InterOperableMap.super.query(pattern));
    }

    default public CanonicalMap query(String string) {
        return new CanonicalMapImpl(InterOperableMap.super.query(string));
    }

    default public CanonicalMap query(String ... stringArray) {
        return this.query(this.toPath(stringArray));
    }

    default public CanonicalMap queryBetween(Collection<?> collection, Collection<?> collection2, Collection<?> collection3) {
        return this.queryBetween(this.toPath(collection), this.toPath(collection2), this.toPath(collection3));
    }

    default public CanonicalMap queryBetween(Object object, Object object2, Object object3) {
        return this.queryBetween(this.toPath(object), this.toPath(object2), this.toPath(object3));
    }

    default public CanonicalMap queryBetween(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        return this.queryBetween(this.toPath(objectArray), this.toPath(objectArray2), this.toPath(objectArray3));
    }

    default public CanonicalMap queryBetween(String string, Pattern pattern, String string2) {
        return new CanonicalMapImpl(InterOperableMap.super.queryBetween(string, pattern, string2));
    }

    default public CanonicalMap queryBetween(String string, String string2, String string3) {
        return new CanonicalMapImpl(InterOperableMap.super.queryBetween(string, string2, string3));
    }

    default public CanonicalMap queryBetween(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return this.queryBetween(this.toPath(stringArray), this.toPath(stringArray2), this.toPath(stringArray3));
    }

    default public CanonicalMap queryFrom(Collection<?> collection, Collection<?> collection2) {
        return this.queryFrom(this.toPath(collection), this.toPath(collection2));
    }

    default public CanonicalMap queryFrom(Object object, Object object2) {
        return this.queryFrom(this.toPath(object), this.toPath(object2));
    }

    default public CanonicalMap queryFrom(Object[] objectArray, Object[] objectArray2) {
        return this.queryFrom(this.toPath(objectArray), this.toPath(objectArray2));
    }

    default public CanonicalMap queryFrom(Pattern pattern, String string) {
        return new CanonicalMapImpl(InterOperableMap.super.queryFrom(pattern, string));
    }

    default public CanonicalMap queryFrom(String string, String string2) {
        return new CanonicalMapImpl(InterOperableMap.super.queryFrom(string, string2));
    }

    default public CanonicalMap queryFrom(String[] stringArray, String[] stringArray2) {
        return this.queryFrom(this.toPath(stringArray), this.toPath(stringArray2));
    }

    default public CanonicalMap queryTo(Collection<?> collection, String string) {
        return this.queryTo(this.toPath(collection), this.toPath((Object)string));
    }

    default public CanonicalMap queryTo(Object object, String string) {
        return this.queryTo(this.toPath(object), this.toPath((Object)string));
    }

    default public CanonicalMap queryTo(Object[] objectArray, String string) {
        return this.queryTo(this.toPath(objectArray), this.toPath((Object)string));
    }

    default public CanonicalMap queryTo(Pattern pattern, String string) {
        return new CanonicalMapImpl(InterOperableMap.super.queryTo(pattern, string));
    }

    default public CanonicalMap queryTo(String string, String string2) {
        return new CanonicalMapImpl(InterOperableMap.super.queryTo(string, string2));
    }

    default public CanonicalMap queryTo(String[] stringArray, String string) {
        return this.queryTo(this.toPath(stringArray), this.toPath((Object)string));
    }

    default public CanonicalMap retrieveBetween(Collection<?> collection, Collection<?> collection2) {
        return this.retrieveBetween(this.toPath(collection), this.toPath(collection2));
    }

    default public CanonicalMap retrieveBetween(Object object, Object object2) {
        return this.retrieveBetween(this.toPath(object), this.toPath(object2));
    }

    default public CanonicalMap retrieveBetween(Object[] objectArray, Object[] objectArray2) {
        return this.retrieveBetween(this.toPath(objectArray), this.toPath(objectArray2));
    }

    default public CanonicalMap retrieveBetween(String string, String string2) {
        CanonicalMap canonicalMap = this.retrieveFrom(string);
        return canonicalMap.retrieveTo(string2);
    }

    default public CanonicalMap retrieveBetween(String[] stringArray, String[] stringArray2) {
        return this.retrieveBetween(this.toPath(stringArray), this.toPath(stringArray2));
    }

    default public CanonicalMap retrieveFrom(Collection<?> collection) {
        return this.retrieveFrom(this.toPath(collection));
    }

    default public CanonicalMap retrieveFrom(Object object) {
        return this.retrieveFrom(this.toPath(object));
    }

    default public CanonicalMap retrieveFrom(Object ... objectArray) {
        return this.retrieveFrom(this.toPath(objectArray));
    }

    public CanonicalMap retrieveFrom(String var1);

    default public CanonicalMap retrieveFrom(String ... stringArray) {
        return this.retrieveFrom(this.toPath(stringArray));
    }

    default public CanonicalMap retrieveTo(Collection<?> collection) {
        return this.retrieveTo(this.toPath(collection));
    }

    default public CanonicalMap retrieveTo(Object object) {
        return this.retrieveTo(this.toPath(object));
    }

    default public CanonicalMap retrieveTo(Object ... objectArray) {
        return this.retrieveTo(this.toPath(objectArray));
    }

    public CanonicalMap retrieveTo(String var1);

    default public CanonicalMap retrieveTo(String ... stringArray) {
        return this.retrieveTo(this.toPath(stringArray));
    }

    default public CanonicalMap getDir(Collection<?> collection) {
        return this.getDir(this.toPath(collection));
    }

    default public CanonicalMap getDir(Object object) {
        return this.getDir(this.toPath(object));
    }

    default public CanonicalMap getDir(Object ... objectArray) {
        return this.getDir(this.toPath(objectArray));
    }

    default public CanonicalMap getDir(String string) {
        return this.retrieveFrom(string);
    }

    default public CanonicalMap getDir(String ... stringArray) {
        return this.getDir(this.toPath(stringArray));
    }

    @Override
    default public Map<String, String> toMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.keySet()) {
            hashMap.put(string, (String)this.get((Object)string));
        }
        return hashMap;
    }

    default public Properties toProperties() {
        Properties properties = new Properties();
        for (String string : this.keySet()) {
            properties.put(this.toPropertyPath(string), this.get((Object)string));
        }
        return properties;
    }

    public static interface MutableCanonicalMap
    extends CanonicalMap,
    InterOperableMap.MutableInterOperableMap<String>,
    Map<String, String> {
        @Override
        default public boolean containsValue(Object object) {
            return this.values().contains(object);
        }

        default public void insert(CanonicalMap canonicalMap) {
            this.insert(canonicalMap);
        }

        default public void insertBetween(String string, CanonicalMap canonicalMap, String string2) {
            this.insertBetween(string, canonicalMap, string2);
        }

        default public void insertFrom(CanonicalMap canonicalMap, String string) {
            this.insertFrom(canonicalMap, string);
        }

        default public void insertTo(String string, CanonicalMap canonicalMap) {
            this.insertTo(string, canonicalMap);
        }

        @Override
        default public String put(Object object, String string) {
            return (String)this.put(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null), string);
        }

        @Override
        default public String put(Object[] objectArray, String string) {
            return (String)this.put(this.toPath(objectArray), string);
        }

        default public String put(Property property) {
            return (String)this.put((String)property.getKey(), (String)property.getValue());
        }

        @Override
        default public String put(Relation<String, String> relation) {
            return (String)this.put((String)relation.getKey(), (String)relation.getValue());
        }

        @Override
        default public String put(String[] stringArray, String string) {
            return (String)this.put(this.toPath(stringArray), string);
        }

        default public void putAll(CanonicalMap canonicalMap) {
            for (Object k : canonicalMap.keySet()) {
                this.put((String)k, (String)this.get((Object)((String)k)));
            }
        }

        default public void putAll(Properties properties) {
            for (Object object : properties.keySet()) {
                this.put((String)object, (String)this.get((Object)((String)object)));
            }
        }

        @Override
        default public void putAll(Map<? extends String, ? extends String> map) {
            for (String string : map.keySet()) {
                this.put(string, (String)this.get((Object)string));
            }
        }

        default public CanonicalMap putDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(collection), n, object);
        }

        default public CanonicalMap putDirAt(Collection<?> collection, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(collection), n, (PathMap)pathMap);
        }

        default public CanonicalMap putDirAt(int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.getRootPath(), n, object);
        }

        default public CanonicalMap putDirAt(int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.getRootPath(), n, (PathMap)pathMap);
        }

        default public CanonicalMap putDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(object), n, object2);
        }

        default public CanonicalMap putDirAt(Object object, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(object), n, (PathMap)pathMap);
        }

        default public CanonicalMap putDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(objectArray), n, object);
        }

        default public CanonicalMap putDirAt(Object[] objectArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(objectArray), n, (PathMap)pathMap);
        }

        default public CanonicalMap putDirAt(String string, int n, Object object) throws IllegalArgumentException {
            CanonicalMap canonicalMap = this.removeDirAt(string, n);
            this.insertTo(this.toPath(string, n), object);
            return canonicalMap;
        }

        default public CanonicalMap putDirAt(String string, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            CanonicalMap canonicalMap = this.removeDirAt(string, n);
            this.insertTo(this.toPath(string, n), pathMap);
            return canonicalMap;
        }

        default public CanonicalMap putDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(stringArray), n, object);
        }

        default public CanonicalMap putDirAt(String[] stringArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(stringArray), n, (PathMap)pathMap);
        }

        default public CanonicalMap removeAll(Collection<?> collection) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(collection));
        }

        default public CanonicalMap removeAll(Object ... objectArray) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(objectArray));
        }

        default public CanonicalMap removeAll(Object object) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(object));
        }

        default public CanonicalMap removeAll(Pattern pattern) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(pattern));
        }

        default public CanonicalMap removeAll(String ... stringArray) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(stringArray));
        }

        default public CanonicalMap removeAll(String string) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeAll(string));
        }

        default public CanonicalMap removeDirAt(int n) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(n));
        }

        default public CanonicalMap removeDirAt(Object object, int n) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(object, n));
        }

        default public CanonicalMap removeDirAt(Object[] objectArray, int n) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(objectArray, n));
        }

        default public CanonicalMap removeDirAt(String string, int n) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(string, n));
        }

        default public CanonicalMap removeDirAt(String[] stringArray, int n) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeDirAt(stringArray, n));
        }

        default public CanonicalMap removeFrom(Collection<?> collection) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(collection));
        }

        default public CanonicalMap removeFrom(Object ... objectArray) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(objectArray));
        }

        default public CanonicalMap removeFrom(Object object) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(object));
        }

        default public CanonicalMap removeFrom(String string) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(string));
        }

        default public CanonicalMap removeFrom(String ... stringArray) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removeFrom(stringArray));
        }

        default public CanonicalMap removePaths(Collection<?> collection) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removePaths(collection));
        }

        default public CanonicalMap removePaths(String ... stringArray) {
            return new CanonicalMapImpl(InterOperableMap.MutableInterOperableMap.super.removePaths(stringArray));
        }

        default public Map<String, String> toDump(Map<String, String> map) {
            map.putAll(this);
            return map;
        }
    }

    public static interface CanonicalMapBuilder
    extends MutableCanonicalMap,
    InterOperableMap.InterOperableMapBuilder<String> {
        @Override
        default public CanonicalMapBuilder withPut(Collection<?> collection, String string) {
            this.put(collection, string);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPut(Object[] objectArray, String string) throws NumberFormatException {
            this.put(objectArray, string);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPut(Relation<String, String> relation) {
            this.put((Relation)relation);
            return this;
        }

        default public CanonicalMapBuilder withPut(Property property) {
            this.put(property);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPut(String[] stringArray, String string) {
            this.put(stringArray, string);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(Collection<?> collection, Boolean bl) {
            this.putBoolean(collection, bl);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(Object object, Boolean bl) {
            this.putBoolean(object, bl);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(Object[] objectArray, Boolean bl) {
            this.putBoolean(objectArray, bl);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(String string, Boolean bl) {
            this.putBoolean(string, bl);
            return this;
        }

        default public CanonicalMapBuilder withPutBoolean(String[] stringArray, Boolean bl) {
            this.putBoolean(stringArray, bl);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(Collection<?> collection, Byte by) {
            this.putByte(collection, by);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(Object object, Byte by) {
            this.putByte(object, by);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(Object[] objectArray, Byte by) {
            this.putByte(objectArray, by);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(String string, Byte by) {
            this.putByte(string, by);
            return this;
        }

        default public CanonicalMapBuilder withPutByte(String[] stringArray, Byte by) {
            this.putByte(stringArray, by);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(Collection<?> collection, Character c) {
            this.putChar(collection, c);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(Object object, Character c) {
            this.putChar(object, c);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(Object[] objectArray, Character c) {
            this.putChar(objectArray, c);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(String string, Character c) {
            this.putChar(string, c);
            return this;
        }

        default public CanonicalMapBuilder withPutChar(String[] stringArray, Character c) {
            this.putChar(stringArray, c);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(Collection<?> collection, Class<C> clazz) {
            this.putClass(collection, clazz);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(Object object, Class<C> clazz) {
            this.putClass(object, clazz);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(Object[] objectArray, Class<C> clazz) {
            this.putClass(objectArray, clazz);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(String string, Class<C> clazz) {
            this.putClass(string, clazz);
            return this;
        }

        default public <C> CanonicalMapBuilder withPutClass(String[] stringArray, Class<C> clazz) {
            this.putClass(stringArray, clazz);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(Collection<?> collection, Double d) {
            this.putDouble(collection, d);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(Object object, Double d) {
            this.putDouble(object, d);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(Object[] objectArray, Double d) {
            this.putDouble(objectArray, d);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(String string, Double d) {
            this.putDouble(string, d);
            return this;
        }

        default public CanonicalMapBuilder withPutDouble(String[] stringArray, Double d) {
            this.putDouble(stringArray, d);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(Collection<?> collection, E e) {
            this.putEnum(collection, e);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(Object object, E e) {
            this.putEnum(object, e);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(Object[] objectArray, E e) {
            this.putEnum(objectArray, e);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(String string, E e) {
            this.putEnum(string, e);
            return this;
        }

        default public <E extends Enum<E>> CanonicalMapBuilder withPutEnum(String[] stringArray, E e) {
            this.putEnum(stringArray, e);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(Collection<?> collection, Float f) {
            this.putFloat(collection, f);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(Object object, Float f) {
            this.putFloat(object, f);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(Object[] objectArray, Float f) {
            this.putFloat(objectArray, f);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(String string, Float f) {
            this.putFloat(string, f);
            return this;
        }

        default public CanonicalMapBuilder withPutFloat(String[] stringArray, Float f) {
            this.putFloat(stringArray, f);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(Collection<?> collection, Integer n) {
            this.putInt(collection, n);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(Object object, Integer n) {
            this.putInt(object, n);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(Object[] objectArray, Integer n) {
            this.putInt(objectArray, n);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(String string, Integer n) {
            this.putInt(string, n);
            return this;
        }

        default public CanonicalMapBuilder withPutInt(String[] stringArray, Integer n) {
            this.putInt(stringArray, n);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(Collection<?> collection, Long l) {
            this.putLong(collection, l);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(Object object, Long l) {
            this.putLong(object, l);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(Object[] objectArray, Long l) {
            this.putLong(objectArray, l);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(String string, Long l) {
            this.putLong(string, l);
            return this;
        }

        default public CanonicalMapBuilder withPutLong(String[] stringArray, Long l) {
            this.putLong(stringArray, l);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(Collection<?> collection, Short s) {
            this.putShort(collection, s);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(Object object, Short s) {
            this.putShort(object, s);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(Object[] objectArray, Short s) {
            this.putShort(objectArray, s);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(String string, Short s) {
            this.putShort(string, s);
            return this;
        }

        default public CanonicalMapBuilder withPutShort(String[] stringArray, Short s) {
            this.putShort(stringArray, s);
            return this;
        }

        default public CanonicalMapBuilder withPutString(Collection<?> collection, String string) {
            this.putString(collection, string);
            return this;
        }

        default public CanonicalMapBuilder withPutString(Object object, String string) {
            this.putString(object, string);
            return this;
        }

        default public CanonicalMapBuilder withPutString(Object[] objectArray, String string) {
            this.putString(objectArray, string);
            return this;
        }

        default public CanonicalMapBuilder withPutString(String string, String string2) {
            this.putString(string, string2);
            return this;
        }

        default public CanonicalMapBuilder withPutString(String[] stringArray, String string) {
            this.putString(stringArray, string);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsert(Object object) {
            this.insert(object);
            return this;
        }

        default public CanonicalMapBuilder withInsert(PathMap<String> pathMap) {
            this.insert(pathMap);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.insertBetween(collection, object, collection2);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(Collection<?> collection, PathMap<String> pathMap, Collection<?> collection2) {
            this.insertBetween(collection, pathMap, collection2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertBetween(Object object, Object object2, Object object3) {
            this.insertBetween(object, object2, object3);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(Object object, PathMap<String> pathMap, Object object2) {
            this.insertBetween(object, pathMap, object2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.insertBetween(objectArray, object, objectArray2);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(Object[] objectArray, PathMap<String> pathMap, Object[] objectArray2) {
            this.insertBetween(objectArray, pathMap, objectArray2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertBetween(String string, Object object, String string2) {
            this.insertBetween(string, object, string2);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(String string, PathMap<String> pathMap, String string2) {
            this.insertBetween(string, pathMap, string2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.insertBetween(stringArray, object, stringArray2);
            return this;
        }

        default public CanonicalMapBuilder withInsertBetween(String[] stringArray, PathMap<String> pathMap, String[] stringArray2) {
            this.insertBetween(stringArray, pathMap, stringArray2);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(Object object, Collection<?> collection) {
            this.insertFrom(object, collection);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertFrom(Object object, Object object2) {
            this.insertFrom(object, object2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertFrom(Object object, Object ... objectArray) {
            this.withInsertFrom(object, objectArray);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertFrom(Object object, String string) {
            this.insertFrom(object, string);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertFrom(Object object, String ... stringArray) {
            this.insertFrom(object, stringArray);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> pathMap, Collection<?> collection) {
            this.insertFrom(pathMap, collection);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> pathMap, Object object) {
            this.insertFrom(pathMap, object);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> pathMap, Object ... objectArray) {
            this.withInsertFrom((PathMap)pathMap, objectArray);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> pathMap, String string) {
            this.insertFrom(pathMap, string);
            return this;
        }

        default public CanonicalMapBuilder withInsertFrom(PathMap<String> pathMap, String ... stringArray) {
            this.insertFrom(pathMap, stringArray);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(Collection<?> collection, Object object) {
            this.insertTo(collection, object);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(Collection<?> collection, PathMap<String> pathMap) {
            this.insertTo(collection, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertTo(Object object, Object object2) {
            this.insertTo(object, object2);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(Object object, PathMap<String> pathMap) {
            this.insertTo(object, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertTo(Object[] objectArray, Object object) {
            this.insertTo(objectArray, object);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(Object[] objectArray, PathMap<String> pathMap) {
            this.insertTo(objectArray, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertTo(String string, Object object) {
            this.insertTo(string, object);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(String string, PathMap<String> pathMap) {
            this.insertTo(string, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withInsertTo(String[] stringArray, Object object) {
            this.insertTo(stringArray, object);
            return this;
        }

        default public CanonicalMapBuilder withInsertTo(String[] stringArray, PathMap<String> pathMap) {
            this.insertTo(stringArray, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMerge(Object object) {
            this.merge(object);
            return this;
        }

        default public CanonicalMapBuilder withMerge(PathMap<String> pathMap) {
            this.merge(pathMap);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.mergeBetween(collection, object, collection2);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(Collection<?> collection, PathMap<String> pathMap, Collection<?> collection2) {
            this.mergeBetween(collection, pathMap, collection2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeBetween(Object object, Object object2, Object object3) {
            this.mergeBetween(object, object2, object3);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(Object object, PathMap<String> pathMap, Object object2) {
            this.mergeBetween(object, pathMap, object2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.mergeBetween(objectArray, object, objectArray2);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(Object[] objectArray, PathMap<String> pathMap, Object[] objectArray2) {
            this.mergeBetween(objectArray, objectArray2, objectArray2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeBetween(String string, Object object, String string2) {
            this.mergeBetween(string, object, string2);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(String string, PathMap<String> pathMap, String string2) {
            this.mergeBetween(string, pathMap, string2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.mergeBetween(stringArray, object, stringArray2);
            return this;
        }

        default public CanonicalMapBuilder withMergeBetween(String[] stringArray, PathMap<String> pathMap, String[] stringArray2) {
            this.mergeBetween(stringArray, pathMap, stringArray2);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(Object object, Collection<?> collection) {
            this.mergeFrom(object, collection);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeFrom(Object object, Object object2) {
            this.mergeFrom(object, object2);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeFrom(Object object, Object ... objectArray) {
            this.mergeFrom(object, objectArray);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeFrom(Object object, String string) {
            this.mergeFrom(object, string);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeFrom(Object object, String ... stringArray) {
            this.mergeFrom(object, stringArray);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> pathMap, Collection<?> collection) {
            this.mergeFrom(pathMap, collection);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> pathMap, Object object) {
            this.mergeFrom(pathMap, object);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> pathMap, Object ... objectArray) {
            this.mergeFrom(pathMap, objectArray);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> pathMap, String string) {
            this.mergeFrom(pathMap, string);
            return this;
        }

        default public CanonicalMapBuilder withMergeFrom(PathMap<String> pathMap, String ... stringArray) {
            this.mergeFrom(pathMap, stringArray);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(Collection<?> collection, Object object) {
            this.mergeTo(collection, object);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(Collection<?> collection, PathMap<String> pathMap) {
            this.mergeTo(collection, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeTo(Object object, Object object2) {
            this.mergeTo(object, object2);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(Object object, PathMap<String> pathMap) {
            this.mergeTo(object, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeTo(Object[] objectArray, Object object) {
            this.mergeTo(objectArray, object);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(Object[] objectArray, PathMap<String> pathMap) {
            this.mergeTo(objectArray, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeTo(String string, Object object) {
            this.mergeTo(string, object);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(String string, PathMap<String> pathMap) {
            this.mergeTo(string, pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withMergeTo(String[] stringArray, Object object) {
            this.mergeTo(stringArray, object);
            return this;
        }

        default public CanonicalMapBuilder withMergeTo(String[] stringArray, PathMap<String> pathMap) {
            this.mergeTo(stringArray, pathMap);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
            this.putDirAt((Collection)collection, n, object);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(Collection<?> collection, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt((Collection)collection, n, (PathMap)pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(int n, Object object) throws IllegalArgumentException {
            this.putDirAt(n, object);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(n, (PathMap)pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            this.putDirAt(object, n, object2);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(Object object, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(object, n, (PathMap)pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, object);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(Object[] objectArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, (PathMap)pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(String string, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(string, n, object);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(String string, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(string, n, (PathMap)pathMap);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withPutDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, object);
            return this;
        }

        default public CanonicalMapBuilder withPutDirAt(String[] stringArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, (PathMap)pathMap);
            return this;
        }

        default public CanonicalMapBuilder withRemoveFrom(Collection<?> collection) {
            this.removeFrom((Collection)collection);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withRemoveFrom(Object object) {
            this.removeFrom(object);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withRemoveFrom(Object ... objectArray) {
            this.removeFrom(objectArray);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withRemoveFrom(String string) {
            this.removeFrom(string);
            return this;
        }

        @Override
        default public CanonicalMapBuilder withRemoveFrom(String ... stringArray) {
            this.removeFrom(stringArray);
            return this;
        }

        default public CanonicalMapBuilder withRemovePaths(String ... stringArray) {
            this.removeFrom(stringArray);
            return this;
        }
    }
}

