/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.refcodes.data.Wildcard;
import org.refcodes.struct.ClassStructMapImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.TypeModeAccessor;

public interface ClassStructMap
extends PathMap<Class<?>>,
TypeModeAccessor {
    public static final String ARRAY_SELECTOR = Wildcard.FILE.getValue();

    @Override
    default public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    default public ClassStructMap getDirAt(int n) {
        return this.getDirAt(this.getRootPath(), n);
    }

    default public ClassStructMap getDirAt(Collection<?> collection, int n) {
        return this.getDirAt(this.toPath(collection), n);
    }

    default public ClassStructMap getDirAt(Object object, int n) {
        return this.getDirAt(this.toPath(object), n);
    }

    default public ClassStructMap getDirAt(Object[] objectArray, int n) {
        return this.getDirAt(this.toPath(objectArray), n);
    }

    default public ClassStructMap getDirAt(String[] stringArray, int n) {
        return this.getDirAt(this.toPath(stringArray), n);
    }

    default public ClassStructMap getDirAt(String string, int n) {
        return this.retrieveFrom(this.toPath(string, "" + n));
    }

    default public ClassStructMap query(Collection<?> collection) {
        return this.query(this.toPath(collection));
    }

    default public ClassStructMap query(Object ... objectArray) {
        return this.query(this.toPath(objectArray));
    }

    default public ClassStructMap query(Pattern pattern) {
        return new ClassStructMapImpl(PathMap.super.query(pattern));
    }

    default public ClassStructMap query(String string) {
        return new ClassStructMapImpl(PathMap.super.query(string));
    }

    default public ClassStructMap query(String ... stringArray) {
        return this.query(this.toPath(stringArray));
    }

    default public ClassStructMap queryBetween(Collection<?> collection, Collection<?> collection2, Collection<?> collection3) {
        return this.queryBetween(this.toPath(collection), this.toPath(collection2), this.toPath(collection3));
    }

    default public ClassStructMap queryBetween(Object object, Object object2, Object object3) {
        return this.queryBetween(this.toPath(object), this.toPath(object2), this.toPath(object3));
    }

    default public ClassStructMap queryBetween(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        return this.queryBetween(this.toPath(objectArray), this.toPath(objectArray2), this.toPath(objectArray3));
    }

    default public ClassStructMap queryBetween(String string, Pattern pattern, String string2) {
        return new ClassStructMapImpl(PathMap.super.queryBetween(string, pattern, string2));
    }

    default public ClassStructMap queryBetween(String string, String string2, String string3) {
        return new ClassStructMapImpl(PathMap.super.queryBetween(string, string2, string3));
    }

    default public ClassStructMap queryBetween(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return this.queryBetween(this.toPath(stringArray), this.toPath(stringArray2), this.toPath(stringArray3));
    }

    default public ClassStructMap queryFrom(Collection<?> collection, Collection<?> collection2) {
        return this.queryFrom(this.toPath(collection), this.toPath(collection2));
    }

    default public ClassStructMap queryFrom(Object object, Object object2) {
        return this.queryFrom(this.toPath(object), this.toPath(object2));
    }

    default public ClassStructMap queryFrom(Object[] objectArray, Object[] objectArray2) {
        return this.queryFrom(this.toPath(objectArray), this.toPath(objectArray2));
    }

    default public ClassStructMap queryFrom(Pattern pattern, String string) {
        return new ClassStructMapImpl(PathMap.super.queryFrom(pattern, string));
    }

    default public ClassStructMap queryFrom(String string, String string2) {
        return new ClassStructMapImpl(PathMap.super.queryFrom(string, string2));
    }

    default public ClassStructMap queryFrom(String[] stringArray, String[] stringArray2) {
        return this.queryFrom(this.toPath(stringArray), this.toPath(stringArray2));
    }

    default public ClassStructMap queryTo(Collection<?> collection, String string) {
        return this.queryTo(this.toPath(collection), this.toPath((Object)string));
    }

    default public ClassStructMap queryTo(Object object, String string) {
        return this.queryTo(this.toPath(object), this.toPath((Object)string));
    }

    default public ClassStructMap queryTo(Object[] objectArray, String string) {
        return this.queryTo(this.toPath(objectArray), this.toPath((Object)string));
    }

    default public ClassStructMap queryTo(Pattern pattern, String string) {
        return new ClassStructMapImpl(PathMap.super.queryTo(pattern, string));
    }

    default public ClassStructMap queryTo(String string, String string2) {
        return new ClassStructMapImpl(PathMap.super.queryTo(string, string2));
    }

    default public ClassStructMap queryTo(String[] stringArray, String string) {
        return this.queryTo(this.toPath(stringArray), this.toPath((Object)string));
    }

    default public ClassStructMap retrieveBetween(Collection<?> collection, Collection<?> collection2) {
        return this.retrieveBetween(this.toPath(collection), this.toPath(collection2));
    }

    default public ClassStructMap retrieveBetween(Object object, Object object2) {
        return this.retrieveBetween(this.toPath(object), this.toPath(object2));
    }

    default public ClassStructMap retrieveBetween(Object[] objectArray, Object[] objectArray2) {
        return this.retrieveBetween(this.toPath(objectArray), this.toPath(objectArray2));
    }

    default public ClassStructMap retrieveBetween(String string, String string2) {
        ClassStructMap classStructMap = this.retrieveFrom(string);
        return classStructMap.retrieveTo(string2);
    }

    default public ClassStructMap retrieveBetween(String[] stringArray, String[] stringArray2) {
        return this.retrieveBetween(this.toPath(stringArray), this.toPath(stringArray2));
    }

    default public ClassStructMap retrieveFrom(Collection<?> collection) {
        return this.retrieveFrom(this.toPath(collection));
    }

    default public ClassStructMap retrieveFrom(Object object) {
        return this.retrieveFrom(this.toPath(object));
    }

    default public ClassStructMap retrieveFrom(Object ... objectArray) {
        return this.retrieveFrom(this.toPath(objectArray));
    }

    public ClassStructMap retrieveFrom(String var1);

    default public ClassStructMap retrieveFrom(String ... stringArray) {
        return this.retrieveFrom(this.toPath(stringArray));
    }

    default public ClassStructMap getDir(Collection<?> collection) {
        return this.getDir(this.toPath(collection));
    }

    default public ClassStructMap getDir(Object object) {
        return this.getDir(this.toPath(object));
    }

    default public ClassStructMap getDir(Object ... objectArray) {
        return this.getDir(this.toPath(objectArray));
    }

    default public ClassStructMap getDir(String string) {
        return this.retrieveFrom(string);
    }

    default public ClassStructMap getDir(String ... stringArray) {
        return this.getDir(this.toPath(stringArray));
    }

    default public ClassStructMap retrieveTo(Collection<?> collection) {
        return this.retrieveTo(this.toPath(collection));
    }

    default public ClassStructMap retrieveTo(Object object) {
        return this.retrieveTo(this.toPath(object));
    }

    default public ClassStructMap retrieveTo(Object ... objectArray) {
        return this.retrieveTo(this.toPath(objectArray));
    }

    public ClassStructMap retrieveTo(String var1);

    default public ClassStructMap retrieveTo(String ... stringArray) {
        return this.retrieveTo(this.toPath(stringArray));
    }

    @Override
    default public Map<String, Class<?>> toMap() {
        HashMap hashMap = new HashMap();
        for (String string : this.keySet()) {
            hashMap.put(string, (Class)this.get((Object)string));
        }
        return hashMap;
    }

    default public Properties toProperties() {
        Properties properties = new Properties();
        for (String string : this.keySet()) {
            properties.put(this.toPropertyPath(string), this.get((Object)string));
        }
        return properties;
    }

    default public String getArraySelector() {
        return ARRAY_SELECTOR;
    }

    default public boolean isArrayType() {
        return this.isArrayType(this.getRootPath());
    }

    default public boolean isArrayType(String ... stringArray) {
        return this.isArrayType(this.toPath(stringArray));
    }

    default public boolean isArrayType(Collection<?> collection) {
        return this.isArrayType(this.toPath(collection));
    }

    default public boolean isArrayType(Object object) {
        return this.isArrayType(this.toPath(object));
    }

    default public boolean isArrayType(Object ... objectArray) {
        return this.isArrayType(this.toPath(objectArray));
    }

    default public boolean isArrayType(String string) {
        return this.isSimpleArrayType(string) || this.isCompositeArrayDir(string);
    }

    default public boolean isSimpleArrayType() {
        return this.isSimpleArrayType(this.getRootPath());
    }

    default public boolean isSimpleArrayType(Object object) {
        return this.isSimpleArrayType(this.toPath(object));
    }

    default public boolean isSimpleArrayType(Object ... objectArray) {
        return this.isSimpleArrayType(this.toPath(objectArray));
    }

    default public boolean isSimpleArrayType(String ... stringArray) {
        return this.isSimpleArrayType(this.toPath(stringArray));
    }

    default public boolean isSimpleArrayType(Collection<?> collection) {
        return this.isSimpleArrayType(this.toPath(collection));
    }

    default public boolean isSimpleArrayType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        if (clazz != null && clazz.isArray() && SimpleType.isSimpleArrayType(clazz = clazz.getComponentType())) {
            return true;
        }
        clazz = (Class)this.get((Object)(string.endsWith(this.getDelimiter() + this.getArraySelector()) ? string : this.toPath(string, this.getArraySelector())));
        return clazz != null && SimpleType.isSimpleType(clazz);
    }

    default public Class<?> getSimpleArrayType() {
        return this.getSimpleArrayType(this.getRootPath());
    }

    default public Class<?> getSimpleArrayType(Object object) {
        return this.getSimpleArrayType(this.toPath(object));
    }

    default public Class<?> getSimpleArrayType(Object ... objectArray) {
        return this.getSimpleArrayType(this.toPath(objectArray));
    }

    default public Class<?> getSimpleArrayType(String ... stringArray) {
        return this.getSimpleArrayType(this.toPath(stringArray));
    }

    default public Class<?> getSimpleArrayType(Collection<?> collection) {
        return this.getSimpleArrayType(this.toPath(collection));
    }

    default public Class<?> getSimpleArrayType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        if (clazz != null && clazz.isArray() && SimpleType.isSimpleArrayType(clazz = clazz.getComponentType())) {
            return clazz;
        }
        clazz = (Class)this.get((Object)(string.endsWith(this.getDelimiter() + this.getArraySelector()) ? string : this.toPath(string, this.getArraySelector())));
        if (clazz != null && SimpleType.isSimpleType(clazz)) {
            return clazz;
        }
        throw new IllegalArgumentException("The provided path <" + string + "> does not direct to a simple array type!");
    }

    default public boolean isSimpleType() {
        return this.isSimpleType(this.getRootPath());
    }

    default public boolean isSimpleType(Object object) {
        return this.isSimpleType(this.toPath(object));
    }

    default public boolean isSimpleType(Object ... objectArray) {
        return this.isSimpleType(this.toPath(objectArray));
    }

    default public boolean isSimpleType(String ... stringArray) {
        return this.isSimpleType(this.toPath(stringArray));
    }

    default public boolean isSimpleType(Collection<?> collection) {
        return this.isSimpleType(this.toPath(collection));
    }

    default public boolean isSimpleType(String string) {
        Class clazz;
        if (!this.isSimpleArrayType() && (clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)))) != null) {
            return SimpleType.isSimpleType(clazz);
        }
        return false;
    }

    default public Class<?> getSimpleType() {
        return this.getSimpleArrayType(this.getRootPath());
    }

    default public Class<?> getSimpleType(Object object) {
        return this.getSimpleArrayType(this.toPath(object));
    }

    default public Class<?> getSimpleType(Object ... objectArray) {
        return this.getSimpleArrayType(this.toPath(objectArray));
    }

    default public Class<?> getSimpleType(String ... stringArray) {
        return this.getSimpleArrayType(this.toPath(stringArray));
    }

    default public Class<?> getSimpleType(Collection<?> collection) {
        return this.getSimpleArrayType(this.toPath(collection));
    }

    default public Class<?> getSimpleType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        return SimpleType.isSimpleType(clazz) ? clazz : null;
    }

    default public boolean isPrimitiveArrayType() {
        return this.isPrimitiveArrayType(this.getRootPath());
    }

    default public boolean isPrimitiveArrayType(Object object) {
        return this.isPrimitiveArrayType(this.toPath(object));
    }

    default public boolean isPrimitiveArrayType(Object ... objectArray) {
        return this.isPrimitiveArrayType(this.toPath(objectArray));
    }

    default public boolean isPrimitiveArrayType(String ... stringArray) {
        return this.isPrimitiveArrayType(this.toPath(stringArray));
    }

    default public boolean isPrimitiveArrayType(Collection<?> collection) {
        return this.isPrimitiveArrayType(this.toPath(collection));
    }

    default public boolean isPrimitiveArrayType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        if (clazz != null && clazz.isArray() && SimpleType.isPrimitiveArrayType(clazz = clazz.getComponentType())) {
            return true;
        }
        clazz = (Class)this.get((Object)(string.endsWith(this.getDelimiter() + this.getArraySelector()) ? string : this.toPath(string, this.getArraySelector())));
        return clazz != null && SimpleType.isPrimitiveType(clazz);
    }

    default public Class<?> getPrimitiveArrayType() {
        return this.getPrimitiveArrayType(this.getRootPath());
    }

    default public Class<?> getPrimitiveArrayType(Object object) {
        return this.getPrimitiveArrayType(this.toPath(object));
    }

    default public Class<?> getPrimitiveArrayType(Object ... objectArray) {
        return this.getPrimitiveArrayType(this.toPath(objectArray));
    }

    default public Class<?> getPrimitiveArrayType(String ... stringArray) {
        return this.getPrimitiveArrayType(this.toPath(stringArray));
    }

    default public Class<?> getPrimitiveArrayType(Collection<?> collection) {
        return this.getPrimitiveArrayType(this.toPath(collection));
    }

    default public Class<?> getPrimitiveArrayType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        if (clazz != null && clazz.isArray() && SimpleType.isPrimitiveArrayType(clazz = clazz.getComponentType())) {
            return clazz;
        }
        clazz = (Class)this.get((Object)(string.endsWith(this.getDelimiter() + this.getArraySelector()) ? string : this.toPath(string, this.getArraySelector())));
        if (clazz != null && SimpleType.isPrimitiveType(clazz)) {
            return clazz;
        }
        throw new IllegalArgumentException("The provided path <" + string + "> does not direct to a primitive array type!");
    }

    default public boolean isPrimitiveType() {
        return this.isPrimitiveType(this.getRootPath());
    }

    default public boolean isPrimitiveType(Object object) {
        return this.isPrimitiveType(this.toPath(object));
    }

    default public boolean isPrimitiveType(Object ... objectArray) {
        return this.isPrimitiveType(this.toPath(objectArray));
    }

    default public boolean isPrimitiveType(String ... stringArray) {
        return this.isPrimitiveType(this.toPath(stringArray));
    }

    default public boolean isPrimitiveType(Collection<?> collection) {
        return this.isPrimitiveType(this.toPath(collection));
    }

    default public boolean isPrimitiveType(String string) {
        Class clazz;
        if (!this.isPrimitiveArrayType() && (clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)))) != null) {
            return SimpleType.isPrimitiveType(clazz);
        }
        return false;
    }

    default public Class<?> getPrimitiveType() {
        return this.getPrimitiveArrayType(this.getRootPath());
    }

    default public Class<?> getPrimitiveType(Object object) {
        return this.getPrimitiveArrayType(this.toPath(object));
    }

    default public Class<?> getPrimitiveType(Object ... objectArray) {
        return this.getPrimitiveArrayType(this.toPath(objectArray));
    }

    default public Class<?> getPrimitiveType(String ... stringArray) {
        return this.getPrimitiveArrayType(this.toPath(stringArray));
    }

    default public Class<?> getPrimitiveType(Collection<?> collection) {
        return this.getPrimitiveArrayType(this.toPath(collection));
    }

    default public Class<?> getPrimitiveType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        return SimpleType.isPrimitiveType(clazz) ? clazz : null;
    }

    default public boolean isWrapperArrayType() {
        return this.isWrapperArrayType(this.getRootPath());
    }

    default public boolean isWrapperArrayType(Object object) {
        return this.isWrapperArrayType(this.toPath(object));
    }

    default public boolean isWrapperArrayType(Object ... objectArray) {
        return this.isWrapperArrayType(this.toPath(objectArray));
    }

    default public boolean isWrapperArrayType(String ... stringArray) {
        return this.isWrapperArrayType(this.toPath(stringArray));
    }

    default public boolean isWrapperArrayType(Collection<?> collection) {
        return this.isWrapperArrayType(this.toPath(collection));
    }

    default public boolean isWrapperArrayType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        if (clazz != null && clazz.isArray() && SimpleType.isWrapperArrayType(clazz = clazz.getComponentType())) {
            return true;
        }
        clazz = (Class)this.get((Object)(string.endsWith(this.getDelimiter() + this.getArraySelector()) ? string : this.toPath(string, this.getArraySelector())));
        return clazz != null && SimpleType.isWrapperType(clazz);
    }

    default public Class<?> getWrapperArrayType() {
        return this.getWrapperArrayType(this.getRootPath());
    }

    default public Class<?> getWrapperArrayType(Object object) {
        return this.getWrapperArrayType(this.toPath(object));
    }

    default public Class<?> getWrapperArrayType(Object ... objectArray) {
        return this.getWrapperArrayType(this.toPath(objectArray));
    }

    default public Class<?> getWrapperArrayType(String ... stringArray) {
        return this.getWrapperArrayType(this.toPath(stringArray));
    }

    default public Class<?> getWrapperArrayType(Collection<?> collection) {
        return this.getWrapperArrayType(this.toPath(collection));
    }

    default public Class<?> getWrapperArrayType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        if (clazz != null && clazz.isArray() && SimpleType.isWrapperArrayType(clazz = clazz.getComponentType())) {
            return clazz;
        }
        clazz = (Class)this.get((Object)(string.endsWith(this.getDelimiter() + this.getArraySelector()) ? string : this.toPath(string, this.getArraySelector())));
        if (clazz != null && SimpleType.isWrapperType(clazz)) {
            return clazz;
        }
        throw new IllegalArgumentException("The provided path <" + string + "> does not direct to a wrapper array type!");
    }

    default public boolean isWrapperType() {
        return this.isWrapperType(this.getRootPath());
    }

    default public boolean isWrapperType(Object object) {
        return this.isWrapperType(this.toPath(object));
    }

    default public boolean isWrapperType(Object ... objectArray) {
        return this.isWrapperType(this.toPath(objectArray));
    }

    default public boolean isWrapperType(String ... stringArray) {
        return this.isWrapperType(this.toPath(stringArray));
    }

    default public boolean isWrapperType(Collection<?> collection) {
        return this.isWrapperType(this.toPath(collection));
    }

    default public boolean isWrapperType(String string) {
        Class clazz;
        if (!this.isWrapperArrayType() && (clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)))) != null) {
            return SimpleType.isWrapperType(clazz);
        }
        return false;
    }

    default public Class<?> getWrapperType() {
        return this.getWrapperArrayType(this.getRootPath());
    }

    default public Class<?> getWrapperType(Object object) {
        return this.getWrapperArrayType(this.toPath(object));
    }

    default public Class<?> getWrapperType(Object ... objectArray) {
        return this.getWrapperArrayType(this.toPath(objectArray));
    }

    default public Class<?> getWrapperType(String ... stringArray) {
        return this.getWrapperArrayType(this.toPath(stringArray));
    }

    default public Class<?> getWrapperType(Collection<?> collection) {
        return this.getWrapperArrayType(this.toPath(collection));
    }

    default public Class<?> getWrapperType(String string) {
        Class clazz = (Class)this.get((Object)(string = this.toNormalizedPath(string)));
        return SimpleType.isWrapperType(clazz) ? clazz : null;
    }

    default public boolean isCompositeArrayDir() {
        return this.isCompositeArrayDir(this.getRootPath());
    }

    default public boolean isCompositeArrayDir(Object object) {
        return this.isCompositeArrayDir(this.toPath(object));
    }

    default public boolean isCompositeArrayDir(Object ... objectArray) {
        return this.isCompositeArrayDir(this.toPath(objectArray));
    }

    default public boolean isCompositeArrayDir(String ... stringArray) {
        return this.isCompositeArrayDir(this.toPath(stringArray));
    }

    default public boolean isCompositeArrayDir(Collection<?> collection) {
        return this.isCompositeArrayDir(this.toPath(collection));
    }

    default public boolean isCompositeArrayDir(String string) {
        return this.isDir((string = this.toNormalizedPath(string)).endsWith(this.getDelimiter() + this.getArraySelector()) ? string : this.toPath(string, this.getArraySelector()));
    }

    default public ClassStructMap getCompositeArrayDir() {
        return this.getCompositeArrayDir(this.getRootPath());
    }

    default public ClassStructMap getCompositeArrayDir(Object object) {
        return this.getCompositeArrayDir(this.toPath(object));
    }

    default public ClassStructMap getCompositeArrayDir(Object ... objectArray) {
        return this.getCompositeArrayDir(this.toPath(objectArray));
    }

    default public ClassStructMap getCompositeArrayDir(String ... stringArray) {
        return this.getCompositeArrayDir(this.toPath(stringArray));
    }

    default public ClassStructMap getCompositeArrayDir(Collection<?> collection) {
        return this.getCompositeArrayDir(this.toPath(collection));
    }

    default public ClassStructMap getCompositeArrayDir(String string) {
        if (this.isCompositeArrayDir(string = this.toNormalizedPath(string))) {
            return this.retrieveFrom(string.endsWith(this.getDelimiter() + this.getArraySelector()) ? string : this.toPath(string, this.getArraySelector()));
        }
        return null;
    }

    default public boolean isCompositeDir() {
        return this.isCompositeDir(this.getRootPath());
    }

    default public boolean isCompositeDir(Object object) {
        return this.isCompositeDir(this.toPath(object));
    }

    default public boolean isCompositeDir(Object ... objectArray) {
        return this.isCompositeDir(this.toPath(objectArray));
    }

    default public boolean isCompositeDir(String ... stringArray) {
        return this.isCompositeDir(this.toPath(stringArray));
    }

    default public boolean isCompositeDir(Collection<?> collection) {
        return this.isCompositeDir(this.toPath(collection));
    }

    default public boolean isCompositeDir(String string) {
        return this.isDir(string = this.toNormalizedPath(string)) && !this.isCompositeArrayDir() && !this.isSimpleType(string);
    }

    default public ClassStructMap getCompositeDir() {
        return this.getCompositeDir(this.getRootPath());
    }

    default public ClassStructMap getCompositeDir(Object object) {
        return this.getCompositeDir(this.toPath(object));
    }

    default public ClassStructMap getCompositeDir(Object ... objectArray) {
        return this.getCompositeDir(this.toPath(objectArray));
    }

    default public ClassStructMap getCompositeDir(String ... stringArray) {
        return this.getCompositeDir(this.toPath(stringArray));
    }

    default public ClassStructMap getCompositeDir(Collection<?> collection) {
        return this.getCompositeDir(this.toPath(collection));
    }

    default public ClassStructMap getCompositeDir(String string) {
        if (this.isCompositeDir(string = this.toNormalizedPath(string))) {
            return this.retrieveFrom(string);
        }
        return null;
    }

    public static interface MutableClassStructMap
    extends ClassStructMap,
    PathMap.MutablePathMap<Class<?>>,
    Map<String, Class<?>> {
        @Override
        default public boolean containsValue(Object object) {
            return this.values().contains(object);
        }

        default public void insert(ClassStructMap classStructMap) {
            this.insert(classStructMap);
        }

        default public void insertBetween(String string, ClassStructMap classStructMap, String string2) {
            this.insertBetween(string, classStructMap, string2);
        }

        default public void insertFrom(ClassStructMap classStructMap, String string) {
            this.insertFrom(classStructMap, string);
        }

        default public void insertTo(String string, ClassStructMap classStructMap) {
            this.insertTo(string, classStructMap);
        }

        @Override
        default public String put(Object object, String string) {
            return this.put(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null), string);
        }

        @Override
        default public Class<?> put(Object[] objectArray, Class<?> clazz) {
            return (Class)this.put(this.toPath(objectArray), clazz);
        }

        default public String put(Property property) {
            return this.put(property.getKey(), (String)property.getValue());
        }

        @Override
        default public Class<?> put(Relation<String, Class<?>> relation) {
            return (Class)this.put((String)relation.getKey(), (Class)relation.getValue());
        }

        @Override
        default public Class<?> put(String[] stringArray, Class<?> clazz) {
            return (Class)this.put(this.toPath(stringArray), clazz);
        }

        default public void putAll(ClassStructMap classStructMap) {
            for (Object k : classStructMap.keySet()) {
                this.put((String)k, (Class)this.get((Object)((String)k)));
            }
        }

        default public void putAll(Properties properties) {
            for (Object object : properties.keySet()) {
                this.put((String)object, (Class)this.get((Object)((String)object)));
            }
        }

        @Override
        default public void putAll(Map<? extends String, ? extends Class<?>> map) {
            for (String string : map.keySet()) {
                this.put(string, (Class)this.get((Object)string));
            }
        }

        default public ClassStructMap putDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(collection), n, object);
        }

        default public ClassStructMap putDirAt(Collection<?> collection, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(collection), n, (PathMap)pathMap);
        }

        default public ClassStructMap putDirAt(int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.getRootPath(), n, object);
        }

        default public ClassStructMap putDirAt(int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.getRootPath(), n, (PathMap)pathMap);
        }

        default public ClassStructMap putDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(object), n, object2);
        }

        default public ClassStructMap putDirAt(Object object, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(object), n, (PathMap)pathMap);
        }

        default public ClassStructMap putDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(objectArray), n, object);
        }

        default public ClassStructMap putDirAt(Object[] objectArray, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(objectArray), n, (PathMap)pathMap);
        }

        default public ClassStructMap putDirAt(String string, int n, Object object) throws IllegalArgumentException {
            ClassStructMap classStructMap = this.removeDirAt(string, n);
            this.insertTo(this.toPath(string, n), object);
            return classStructMap;
        }

        default public ClassStructMap putDirAt(String string, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            ClassStructMap classStructMap = this.removeDirAt(string, n);
            this.insertTo(this.toPath(string, n), pathMap);
            return classStructMap;
        }

        default public ClassStructMap putDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(stringArray), n, object);
        }

        default public ClassStructMap putDirAt(String[] stringArray, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(stringArray), n, (PathMap)pathMap);
        }

        default public ClassStructMap removeAll(Collection<?> collection) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(collection));
        }

        default public ClassStructMap removeAll(Object ... objectArray) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(objectArray));
        }

        default public ClassStructMap removeAll(Object object) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(object));
        }

        default public ClassStructMap removeAll(Pattern pattern) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(pattern));
        }

        default public ClassStructMap removeAll(String ... stringArray) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(stringArray));
        }

        default public ClassStructMap removeAll(String string) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(string));
        }

        default public ClassStructMap removeDirAt(int n) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(n));
        }

        default public ClassStructMap removeDirAt(Object object, int n) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(object, n));
        }

        default public ClassStructMap removeDirAt(Object[] objectArray, int n) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(objectArray, n));
        }

        default public ClassStructMap removeDirAt(String string, int n) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(string, n));
        }

        default public ClassStructMap removeDirAt(String[] stringArray, int n) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(stringArray, n));
        }

        default public ClassStructMap removeFrom(Collection<?> collection) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(collection));
        }

        default public ClassStructMap removeFrom(Object ... objectArray) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(objectArray));
        }

        default public ClassStructMap removeFrom(Object object) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(object));
        }

        default public ClassStructMap removeFrom(String string) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(string));
        }

        default public ClassStructMap removeFrom(String ... stringArray) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(stringArray));
        }

        default public ClassStructMap removePaths(Collection<?> collection) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removePaths(collection));
        }

        default public ClassStructMap removePaths(String ... stringArray) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removePaths(stringArray));
        }

        default public Map<String, String> toDump(Map<String, String> map) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                Class clazz = (Class)this.get((Object)(string = (String)iterator.next()));
                map.put(string, clazz != null ? clazz.getName() : null);
            }
            return map;
        }
    }

    public static interface ClassStructMapBuilder
    extends MutableClassStructMap,
    PathMap.PathMapBuilder<Class<?>> {
        @Override
        default public ClassStructMapBuilder withPut(Collection<?> collection, Class<?> clazz) {
            this.put(collection, clazz);
            return this;
        }

        @Override
        default public ClassStructMapBuilder withPut(Object[] objectArray, Class<?> clazz) throws NumberFormatException {
            this.put(objectArray, clazz);
            return this;
        }

        @Override
        default public ClassStructMapBuilder withPut(Relation<String, Class<?>> relation) {
            this.put((Relation)relation);
            return this;
        }

        default public ClassStructMapBuilder withPut(Property property) {
            this.put(property);
            return this;
        }

        @Override
        default public ClassStructMapBuilder withPut(String[] stringArray, Class<?> clazz) {
            this.put(stringArray, clazz);
            return this;
        }

        default public ClassStructMapBuilder withInsert(Object object) {
            this.insert(object);
            return this;
        }

        default public ClassStructMapBuilder withInsert(PathMap<Class<?>> pathMap) {
            this.insert(pathMap);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.insertBetween(collection, object, collection2);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Collection<?> collection, PathMap<Class<?>> pathMap, Collection<?> collection2) {
            this.insertBetween(collection, pathMap, collection2);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Object object, Object object2, Object object3) {
            this.insertBetween(object, object2, object3);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Object object, PathMap<Class<?>> pathMap, Object object2) {
            this.insertBetween(object, pathMap, object2);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.insertBetween(objectArray, object, objectArray2);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Object[] objectArray, PathMap<Class<?>> pathMap, Object[] objectArray2) {
            this.insertBetween(objectArray, pathMap, objectArray2);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(String string, Object object, String string2) {
            this.insertBetween(string, object, string2);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(String string, PathMap<Class<?>> pathMap, String string2) {
            this.insertBetween(string, pathMap, string2);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.insertBetween(stringArray, object, stringArray2);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(String[] stringArray, PathMap<Class<?>> pathMap, String[] stringArray2) {
            this.insertBetween(stringArray, pathMap, stringArray2);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object object, Collection<?> collection) {
            this.insertFrom(object, collection);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object object, Object object2) {
            this.insertFrom(object, object2);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object object, Object ... objectArray) {
            this.withInsertFrom(object, objectArray);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object object, String string) {
            this.insertFrom(object, string);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object object, String ... stringArray) {
            this.insertFrom(object, stringArray);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> pathMap, Collection<?> collection) {
            this.insertFrom(pathMap, collection);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> pathMap, Object object) {
            this.insertFrom(pathMap, object);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> pathMap, Object ... objectArray) {
            this.withInsertFrom((PathMap)pathMap, objectArray);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> pathMap, String string) {
            this.insertFrom(pathMap, string);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> pathMap, String ... stringArray) {
            this.insertFrom(pathMap, stringArray);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Collection<?> collection, Object object) {
            this.insertTo(collection, object);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Collection<?> collection, PathMap<Class<?>> pathMap) {
            this.insertTo(collection, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Object object, Object object2) {
            this.insertTo(object, object2);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Object object, PathMap<Class<?>> pathMap) {
            this.insertTo(object, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Object[] objectArray, Object object) {
            this.insertTo(objectArray, object);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Object[] objectArray, PathMap<Class<?>> pathMap) {
            this.insertTo(objectArray, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(String string, Object object) {
            this.insertTo(string, object);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(String string, PathMap<Class<?>> pathMap) {
            this.insertTo(string, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(String[] stringArray, Object object) {
            this.insertTo(stringArray, object);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(String[] stringArray, PathMap<Class<?>> pathMap) {
            this.insertTo(stringArray, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withMerge(Object object) {
            this.merge(object);
            return this;
        }

        default public ClassStructMapBuilder withMerge(PathMap<Class<?>> pathMap) {
            this.merge(pathMap);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.mergeBetween(collection, object, collection2);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Collection<?> collection, PathMap<Class<?>> pathMap, Collection<?> collection2) {
            this.mergeBetween(collection, pathMap, collection2);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Object object, Object object2, Object object3) {
            this.mergeBetween(object, object2, object3);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Object object, PathMap<Class<?>> pathMap, Object object2) {
            this.mergeBetween(object, pathMap, object2);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.mergeBetween(objectArray, object, objectArray2);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Object[] objectArray, PathMap<Class<?>> pathMap, Object[] objectArray2) {
            this.mergeBetween(objectArray, objectArray2, objectArray2);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(String string, Object object, String string2) {
            this.mergeBetween(string, object, string2);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(String string, PathMap<Class<?>> pathMap, String string2) {
            this.mergeBetween(string, pathMap, string2);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.mergeBetween(stringArray, object, stringArray2);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(String[] stringArray, PathMap<Class<?>> pathMap, String[] stringArray2) {
            this.mergeBetween(stringArray, pathMap, stringArray2);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object object, Collection<?> collection) {
            this.mergeFrom(object, collection);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object object, Object object2) {
            this.mergeFrom(object, object2);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object object, Object ... objectArray) {
            this.mergeFrom(object, objectArray);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object object, String string) {
            this.mergeFrom(object, string);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object object, String ... stringArray) {
            this.mergeFrom(object, stringArray);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> pathMap, Collection<?> collection) {
            this.mergeFrom(pathMap, collection);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> pathMap, Object object) {
            this.mergeFrom(pathMap, object);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> pathMap, Object ... objectArray) {
            this.mergeFrom(pathMap, objectArray);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> pathMap, String string) {
            this.mergeFrom(pathMap, string);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> pathMap, String ... stringArray) {
            this.mergeFrom(pathMap, stringArray);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Collection<?> collection, Object object) {
            this.mergeTo(collection, object);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Collection<?> collection, PathMap<Class<?>> pathMap) {
            this.mergeTo(collection, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Object object, Object object2) {
            this.mergeTo(object, object2);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Object object, PathMap<Class<?>> pathMap) {
            this.mergeTo(object, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Object[] objectArray, Object object) {
            this.mergeTo(objectArray, object);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Object[] objectArray, PathMap<Class<?>> pathMap) {
            this.mergeTo(objectArray, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(String string, Object object) {
            this.mergeTo(string, object);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(String string, PathMap<Class<?>> pathMap) {
            this.mergeTo(string, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(String[] stringArray, Object object) {
            this.mergeTo(stringArray, object);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(String[] stringArray, PathMap<Class<?>> pathMap) {
            this.mergeTo(stringArray, pathMap);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
            this.putDirAt((Collection)collection, n, object);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Collection<?> collection, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            this.putDirAt((Collection)collection, n, (PathMap)pathMap);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(int n, Object object) throws IllegalArgumentException {
            this.putDirAt(n, object);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            this.putDirAt(n, (PathMap)pathMap);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            this.putDirAt(object, n, object2);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Object object, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            this.putDirAt(object, n, (PathMap)pathMap);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, object);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Object[] objectArray, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, (PathMap)pathMap);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(String string, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(string, n, object);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(String string, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            this.putDirAt(string, n, (PathMap)pathMap);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, object);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(String[] stringArray, int n, PathMap<Class<?>> pathMap) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, (PathMap)pathMap);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(Collection<?> collection) {
            this.removeFrom((Collection)collection);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(Object object) {
            this.removeFrom(object);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(Object ... objectArray) {
            this.removeFrom(objectArray);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(String string) {
            this.removeFrom(string);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(String ... stringArray) {
            this.removeFrom(stringArray);
            return this;
        }

        default public ClassStructMapBuilder withRemovePaths(String ... stringArray) {
            this.removeFrom(stringArray);
            return this;
        }
    }
}

