/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.refcodes.data.Literal;
import org.refcodes.struct.SimpleType;

public class TypeUtility {
    private static final String[] SETTER_PREFIXES = new String[]{"set"};
    private static final String[] GETTER_PREFIXES = new String[]{"is", "has", "get"};
    private static final String[] FIELD_PREFIXES = new String[]{"_"};

    public static <T> T toType(Object object, Class<T> clazz) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, InvocationTargetException, ClassNotFoundException {
        T t;
        if (clazz.isArray()) {
            t = TypeUtility.toArray(object, clazz);
        } else {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            t = TypeUtility.toInstance(object, clazz);
        }
        return t;
    }

    public static <T> void toInstance(Object object, T t) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = t.getClass();
        if (clazz.isArray()) {
            Object obj = TypeUtility.toArray(object, clazz);
            int n = Array.getLength(obj);
            int n2 = Array.getLength(t);
            for (int i = 0; i < n && i < n2; ++i) {
                Array.set(t, i, Array.get(obj, i));
            }
        } else {
            TypeUtility.updateInstance(object, t);
        }
    }

    public static boolean isSetter(Method method) {
        String string = TypeUtility.fromSetterMethod(method);
        if (string == null || string.length() == 0) {
            return false;
        }
        return Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 1 && Void.TYPE.equals(method.getReturnType());
    }

    public static boolean isGetter(Method method) {
        String string = TypeUtility.fromGetterMethod(method);
        if (string == null || string.length() == 0) {
            return false;
        }
        return Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 0 && !Void.TYPE.equals(method.getReturnType());
    }

    public static String toPropertyName(Method method) {
        if (TypeUtility.isSetter(method)) {
            return TypeUtility.fromSetterMethod(method);
        }
        if (TypeUtility.isGetter(method)) {
            return TypeUtility.fromGetterMethod(method);
        }
        return null;
    }

    public static String toPropertyName(Field field) {
        String string = field.getName();
        return TypeUtility.fromFieldName(string);
    }

    public static <T> T toArrayType(Object object, Class<T> clazz) throws IllegalArgumentException {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("The provided value <" + object + "> of type <" + object.getClass() + "> must be an array type!");
        }
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("The provided type <" + clazz + "> must be an array type!");
        }
        try {
            return TypeUtility.toArray(object, clazz);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("Cannot create an array type <" + clazz + "> for the given value <" + object + "): " + reflectiveOperationException.getMessage(), reflectiveOperationException);
        }
    }

    public static <T> Map<String, Object> toMap(T t) {
        Object object;
        Object object2;
        Class<?> clazz = t.getClass();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray != null && methodArray.length > 0) {
            for (Method method : methodArray) {
                if (!TypeUtility.isGetter(method)) continue;
                object2 = TypeUtility.fromGetterMethod(method);
                try {
                    method.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    object = method.invoke(t, new Object[0]);
                    hashMap.put((String)object2, object);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        if ((object2 = clazz.getDeclaredFields()) != null && ((Field[])object2).length > 0) {
            for (Field exception : object2) {
                object = TypeUtility.toPropertyName(exception);
                try {
                    exception.setAccessible(true);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    Object object3 = exception.get(t);
                    hashMap.put((String)object, object3);
                }
                catch (IllegalAccessException | IllegalArgumentException exception3) {
                    // empty catch block
                }
            }
        }
        return hashMap;
    }

    private static <T> T toInstance(Object object, Class<T> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        GenericDeclaration genericDeclaration;
        if (object instanceof String) {
            try {
                genericDeclaration = Class.forName((String)object);
                if (clazz.isAssignableFrom((Class<?>)genericDeclaration)) {
                    Constructor constructor = ((Class)genericDeclaration).getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        genericDeclaration = clazz.getConstructor(new Class[0]);
        try {
            ((Constructor)genericDeclaration).setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object t = ((Constructor)genericDeclaration).newInstance(new Object[0]);
        TypeUtility.toInstance(object, t);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> void updateInstance(Object object, T t) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = t.getClass();
        if (object instanceof Map) {
            Object[] objectArray;
            Object v;
            String string;
            Object object2;
            Map map = (Map)object;
            HashSet<String> hashSet = new HashSet<String>();
            Method[] methodArray = clazz.getDeclaredMethods();
            if (methodArray != null && methodArray.length > 0) {
                object2 = new HashSet();
                for (Method method : methodArray) {
                    if (!TypeUtility.isSetter(method)) continue;
                    try {
                        string = TypeUtility.fromSetterMethod(method);
                        if (hashSet.contains(string) || (v = map.get(string)) == null) continue;
                        try {
                            method.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (v.getClass().isArray() && !method.getParameters()[0].getType().isArray() && !Collection.class.isAssignableFrom(method.getParameters()[0].getType())) {
                            objectArray = (Object[])v;
                            Object var14_21 = null;
                            Object[] objectArray2 = objectArray;
                            int n = objectArray2.length;
                            for (int i = 0; i < n; ++i) {
                                void object3;
                                Object object4 = objectArray2[i];
                                if (object4 == null) continue;
                                if (object3 != null && object4 instanceof Map) {
                                    TypeUtility.updateInstance(object4, object3);
                                    continue;
                                }
                                try {
                                    Object object5 = TypeUtility.addToMethod(t, object4, method);
                                    hashSet.add(string);
                                    continue;
                                }
                                catch (Exception exception) {
                                    object2.add(string);
                                }
                            }
                            continue;
                        }
                        try {
                            TypeUtility.addToMethod(t, v, method);
                            hashSet.add(string);
                        }
                        catch (Exception exception) {
                            object2.add(string);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
                if (!object2.isEmpty()) {
                    for (String string2 : hashSet) {
                        object2.remove(string2);
                    }
                    if (!object2.isEmpty()) {
                        throw new NoSuchMethodException("Unable to satisfy the following properties " + Arrays.toString(object2.toArray()) + " (without the square braces) as there are no according methods with the required argument types!");
                    }
                }
            }
            if ((object2 = clazz.getDeclaredFields()) != null && ((Field[])object2).length > 0) {
                for (Method method : object2) {
                    try {
                        string = TypeUtility.toPropertyName((Field)((Object)method));
                        if (hashSet.contains(string) || (v = map.get(string)) == null) continue;
                        try {
                            ((Field)((Object)method)).setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (v.getClass().isArray() && !((Field)((Object)method)).getType().isArray() && !Collection.class.isAssignableFrom(((Field)((Object)method)).getType())) {
                            for (Object object6 : objectArray = (Object[])v) {
                                if (object6 == null) continue;
                                TypeUtility.addToField(t, object6, (Field)((Object)method));
                                hashSet.add(string);
                            }
                            continue;
                        }
                        TypeUtility.addToField(t, v, (Field)((Object)method));
                        hashSet.add(string);
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static <T> Object addToMethod(T t, Object object, Method method) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String string = object.toString();
        Class<?> clazz = method.getParameters()[0].getType();
        if (clazz.equals(String.class)) {
            method.invoke(t, string);
        } else if (string.length() != 0 && !Literal.NULL.getValue().equals(string) && !SimpleType.invokeSimpleType(t, method, string, clazz)) {
            if (List.class.isAssignableFrom(clazz)) {
                List<?> list = TypeUtility.toList(object, method.getParameters()[0].getType(), method.getParameters()[0].getParameterizedType());
                method.invoke(t, list);
            } else if (Map.class.isAssignableFrom(clazz)) {
                Map<?, ?> map = TypeUtility.toMap(object, method.getParameters()[0].getType(), method.getParameters()[0].getParameterizedType());
                method.invoke(t, map);
            } else {
                Object obj = TypeUtility.toType(object, clazz);
                method.invoke(t, obj);
                return obj;
            }
        }
        return null;
    }

    private static <T> void addToField(T t, Object object, Field field) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        String string = object.toString();
        Class<?> clazz = field.getType();
        if (clazz.equals(String.class)) {
            field.set(t, string);
        } else if (string.length() != 0 && !Literal.NULL.getValue().equals(string) && !SimpleType.invokeSimpleType(t, field, string, clazz)) {
            if (List.class.isAssignableFrom(clazz)) {
                List<?> list = TypeUtility.toList(object, field.getType(), field.getGenericType());
                field.set(t, list);
            } else if (Map.class.isAssignableFrom(clazz)) {
                Map<?, ?> map = TypeUtility.toMap(object, field.getType(), field.getGenericType());
                field.set(t, map);
            } else {
                field.set(t, TypeUtility.toType(object, clazz));
            }
        }
    }

    private static <T> T toArray(Object object, Class<T> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz2 = clazz.getComponentType();
        Object[] objectArray = (Object[])object;
        Object object2 = Array.newInstance(clazz.getComponentType(), objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            String string = objectArray[i].toString();
            if (clazz2.equals(String.class)) {
                Array.set(object2, i, string);
                continue;
            }
            if (string.length() == 0 || Literal.NULL.getValue().equals(string) || SimpleType.invokeSimpleType(object2, i, string, clazz2)) continue;
            Array.set(object2, i, TypeUtility.toType(objectArray[i], clazz2));
        }
        return (T)object2;
    }

    private static Map<?, ?> toMap(Object object, Class<?> clazz, Type type) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Map map = (Map)object;
        Map map2 = clazz.equals(Map.class) ? new HashMap() : (Map)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class clazz2 = Object.class;
        Class clazz3 = Object.class;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz2 = TypeUtility.toClass(parameterizedType.getActualTypeArguments()[0]);
            clazz3 = TypeUtility.toClass(parameterizedType.getActualTypeArguments()[1]);
        }
        for (Object e : map.keySet()) {
            Object v = map.get(e);
            if (v == null) continue;
            map2.put(TypeUtility.toValue(e, clazz2), TypeUtility.toValue(v, clazz3));
        }
        return map;
    }

    private static List<?> toList(Object object, Class<?> clazz, Type type) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        List list = null;
        Object[] objectArray = (Object[])object;
        list = clazz.equals(List.class) ? new ArrayList() : (List)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class clazz2 = Object.class;
        if (type instanceof ParameterizedType) {
            clazz2 = TypeUtility.toClass(((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                list.add(null);
                continue;
            }
            list.add(TypeUtility.toValue(objectArray[i], clazz2));
        }
        return list;
    }

    private static Object toValue(Object object, Class<?> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        String string = object.toString();
        String string2 = null;
        if (clazz.equals(String.class)) {
            string2 = string;
        } else if (string.length() != 0 && !Literal.NULL.getValue().equals(string) && (string2 = SimpleType.toSimpleType(string, clazz)) == null) {
            string2 = TypeUtility.toType(object, clazz);
        }
        return string2;
    }

    private static Class<?> toClass(Type type) throws ClassNotFoundException {
        if (type instanceof Class) {
            return (Class)type;
        }
        return Class.forName(type.getTypeName());
    }

    private static String toPropertyName(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length && Character.isUpperCase(cArray[i]); ++i) {
            cArray[i] = Character.toLowerCase(cArray[i]);
        }
        return new String(cArray);
    }

    private static String fromSetterMethod(Method method) {
        String string = method.getName();
        return TypeUtility.fromSetterName(string);
    }

    private static String fromSetterName(String string) {
        String string22;
        block4: {
            for (String string22 : SETTER_PREFIXES) {
                if (!string.startsWith(string22)) {
                    continue;
                }
                break block4;
            }
            return null;
        }
        string = string.substring(string22.length());
        if (string.length() > 0) {
            if (Character.isLowerCase(string.charAt(0))) {
                return null;
            }
            return TypeUtility.toPropertyName(string);
        }
        return null;
    }

    protected static String fromGetterMethod(Method method) {
        String string = method.getName();
        return TypeUtility.fromGetterName(string);
    }

    private static String fromGetterName(String string) {
        String string22;
        block4: {
            for (String string22 : GETTER_PREFIXES) {
                if (!string.startsWith(string22)) {
                    continue;
                }
                break block4;
            }
            return null;
        }
        string = string.substring(string22.length());
        if (string.length() > 0) {
            if (Character.isLowerCase(string.charAt(0))) {
                return null;
            }
            return TypeUtility.toPropertyName(string);
        }
        return null;
    }

    private static String fromFieldName(String string) {
        String string2 = string;
        for (String string3 : FIELD_PREFIXES) {
            if (!string2.startsWith(string3)) continue;
            string2 = string.substring(string3.length());
            break;
        }
        if (string2.length() > 0) {
            string = string2;
        }
        if ((string2 = TypeUtility.fromGetterName(string)) != null && string2.length() > 0) {
            string = string2;
        }
        return TypeUtility.toPropertyName(string);
    }
}

