/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.refcodes.data.Delimiter;
import org.refcodes.struct.Keys;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.PathMapImpl;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.StructureUtility;
import org.refcodes.struct.TypeUtility;

public class PathMapBuilderImpl<T>
implements PathMap.PathMapBuilder<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean IS_DEBUG_OUTPUT = false;
    private static final String ESCAPE = "\\";
    private static final String SPECIAL_REGEX_CHARS = ".^$*+?()[{\\|";
    private static final String[] BLACKLISTED_PROPERTIES = new String[]{"class"};
    private char _delimiter;
    private char _annotator = ANNOTATOR;
    private Class<T> _type;
    protected Map<String, T> _backingMap = this.createBackingMap();

    public PathMapBuilderImpl(Class<T> aType) {
        this(Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(char aDelimiter, Class<T> aType) {
        this._delimiter = aDelimiter;
        this._type = aType;
    }

    public PathMapBuilderImpl(Object aObj, Class<T> aType) {
        this(aObj, Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(String aToPath, Object aObj, Class<T> aType) {
        this(aToPath, aObj, Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(Object aObj, String aFromPath, Class<T> aType) {
        this(aObj, aFromPath, Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(String aToPath, Object aObj, String aFromPath, Class<T> aType) {
        this(aToPath, aObj, aFromPath, Delimiter.PATH.getChar(), aType);
    }

    public PathMapBuilderImpl(Object aObj, char aDelimiter, Class<T> aType) {
        this(aDelimiter, aType);
        this.fromValue(this.getRootPath(), aObj);
    }

    public PathMapBuilderImpl(String aToPath, Object aObj, char aDelimiter, Class<T> aType) {
        this(aDelimiter, aType);
        this.insertTo(aToPath, aObj);
    }

    public PathMapBuilderImpl(Object aObj, String aFromPath, char aDelimiter, Class<T> aType) {
        this(aDelimiter, aType);
        this.insertFrom(aObj, aFromPath);
    }

    public PathMapBuilderImpl(String aToPath, Object aObj, String aFromPath, char aDelimiter, Class<T> aType) {
        this(aDelimiter, aType);
        this.insertBetween(aToPath, aObj, aFromPath);
    }

    @Override
    public boolean containsKey(Object aPath) {
        return this._backingMap.containsKey(this.toNormalizedPath(aPath != null ? aPath.toString() : null));
    }

    @Override
    public T get(Object aPath) {
        return this._backingMap.get(this.toNormalizedPath(aPath != null ? aPath.toString() : null));
    }

    @Override
    public T put(String aPath, T aValue) {
        Object theValue = null;
        if (aValue != null && (theValue = (Object)this.fromInstance(aValue)) == null) {
            throw new IllegalArgumentException("The key <" + aPath + "> cannot be set as the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> is not of a supported type!");
        }
        return this._backingMap.put(this.toNormalizedPath(aPath), theValue);
    }

    @Override
    public T remove(Object aPath) {
        return this._backingMap.remove(this.toNormalizedPath(aPath != null ? aPath.toString() : null));
    }

    @Override
    public T getOrDefault(Object aPath, T publicValue) {
        return this._backingMap.getOrDefault(this.toNormalizedPath(aPath != null ? aPath.toString() : null), publicValue);
    }

    @Override
    public T putIfAbsent(String aPath, T value) {
        return this._backingMap.putIfAbsent(this.toNormalizedPath(aPath), value);
    }

    @Override
    public boolean remove(Object aPath, Object value) {
        return this._backingMap.remove(this.toNormalizedPath(aPath != null ? aPath.toString() : null), value);
    }

    @Override
    public boolean replace(String aPath, T oldValue, T newValue) {
        return this._backingMap.replace(this.toNormalizedPath(aPath), oldValue, newValue);
    }

    @Override
    public T replace(String aPath, T value) {
        return this._backingMap.replace(this.toNormalizedPath(aPath), value);
    }

    @Override
    public T computeIfAbsent(String aPath, Function<? super String, ? extends T> mappingFunction) {
        return this._backingMap.computeIfAbsent(this.toNormalizedPath(aPath), mappingFunction);
    }

    @Override
    public T computeIfPresent(String aPath, BiFunction<? super String, ? super T, ? extends T> remappingFunction) {
        return this._backingMap.computeIfPresent(this.toNormalizedPath(aPath), remappingFunction);
    }

    @Override
    public T compute(String aPath, BiFunction<? super String, ? super T, ? extends T> remappingFunction) {
        return this._backingMap.compute(this.toNormalizedPath(aPath), remappingFunction);
    }

    @Override
    public T merge(String aPath, T value, BiFunction<? super T, ? super T, ? extends T> remappingFunction) {
        return this._backingMap.merge(this.toNormalizedPath(aPath), value, remappingFunction);
    }

    @Override
    public PathMap<T> retrieveTo(String aToPath) {
        PathMapBuilderImpl<T> theToPathMap = new PathMapBuilderImpl<T>(this.getDelimiter(), this._type);
        StructureUtility.retrieveTo(this, aToPath, theToPathMap);
        return theToPathMap;
    }

    @Override
    public PathMap<T> retrieveFrom(String aFromPath) {
        PathMapBuilderImpl<T> theToPathMap = new PathMapBuilderImpl<T>(this.getDelimiter(), this._type);
        StructureUtility.retrieveFrom(this, aFromPath, theToPathMap);
        return theToPathMap;
    }

    public char getDelimiter() {
        return this._delimiter;
    }

    public char getAnnotator() {
        return this._annotator;
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public Object toDataStructure(String aFromPath) {
        return StructureUtility.toDataStructure(this, aFromPath);
    }

    @Override
    public void insert(Object aFrom) {
        PathMap<T> thePathMap = this.fromObject(aFrom);
        for (String ePath : thePathMap.paths()) {
            this.put(ePath, thePathMap.get((Object)ePath));
        }
    }

    @Override
    public void insertBetween(String aToPath, Object aFrom, String aFromPath) {
        PathMap<T> thePathMap = this.fromObject(aFrom);
        this.insertTo(aToPath, thePathMap.retrieveFrom(aFromPath));
    }

    @Override
    public void insertFrom(Object aFrom, String aFromPath) {
        PathMap<T> thePathMap = this.fromObject(aFrom);
        thePathMap = thePathMap.retrieveFrom(aFromPath);
        for (String ePath : thePathMap.paths()) {
            this.put(ePath, thePathMap.get((Object)ePath));
        }
    }

    @Override
    public void insertTo(String aToPath, Object aFrom) {
        aToPath = this.toNormalizedPath(aToPath);
        if (aFrom == null) {
            this.put(aToPath, (T)null);
        } else {
            PathMap<T> thePathMap = this.fromObject(aFrom);
            for (String ePath : thePathMap.paths()) {
                this.put(this.toPath(aToPath, ePath), thePathMap.get((Object)ePath));
            }
        }
    }

    @Override
    public void merge(Object aFrom) {
        PathMap<T> thePathMap = this.fromObject(aFrom);
        for (String ePath : thePathMap.paths()) {
            if (this.get((Object)ePath) != null) continue;
            this.put(ePath, thePathMap.get((Object)ePath));
        }
    }

    @Override
    public void mergeBetween(String aToPath, Object aFrom, String aFromPath) {
        PathMap<T> thePathMap = this.fromObject(aFrom);
        this.mergeTo(aToPath, thePathMap.retrieveFrom(aFromPath));
    }

    @Override
    public void mergeFrom(Object aFrom, String aFromPath) {
        PathMap<T> thePathMap = this.fromObject(aFrom);
        thePathMap = thePathMap.retrieveFrom(aFromPath);
        for (String ePath : thePathMap.paths()) {
            if (this.get((Object)ePath) != null) continue;
            this.put(ePath, thePathMap.get((Object)ePath));
        }
    }

    @Override
    public void mergeTo(String aToPath, Object aFrom) {
        aToPath = this.toNormalizedPath(aToPath);
        if (aFrom == null && !this.containsKey((Object)aToPath)) {
            this.put(aToPath, (T)null);
        } else {
            PathMap<T> thePathMap = this.fromObject(aFrom);
            for (String ePath : thePathMap.paths()) {
                String eToPath = this.toPath(aToPath, ePath);
                if (this.get((Object)eToPath) != null) continue;
                this.put(eToPath, thePathMap.get((Object)ePath));
            }
        }
    }

    @Override
    public PathMap.PathMapBuilder<T> withPut(String aKey, T aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public int size() {
        return this._backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._backingMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this._backingMap.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        this._backingMap.putAll(m);
    }

    @Override
    public void clear() {
        this._backingMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this._backingMap.keySet();
    }

    @Override
    public Collection<T> values() {
        return this._backingMap.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this._backingMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this._backingMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this._backingMap.hashCode();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super T> action) {
        this._backingMap.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super T, ? extends T> function) {
        this._backingMap.replaceAll(function);
    }

    @Override
    public <TYPE> TYPE toType(String aFromPath, Class<TYPE> aType) {
        TYPE theInstance;
        T theValue = this.get((Object)aFromPath);
        if (theValue != null && !this.hasChildren(aFromPath) && (theInstance = this.toInstance(theValue, aType)) != null) {
            return theInstance;
        }
        return PathMap.PathMapBuilder.super.toType(aFromPath, aType);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this._backingMap.toString();
    }

    private void fromPathMap(String aToPath, PathMap<?> aPathMap, Set<Object> aVisited) {
        if (!aVisited.contains(aPathMap)) {
            aVisited.add(aPathMap);
            String theRegex = "" + aPathMap.getDelimiter();
            if (SPECIAL_REGEX_CHARS.contains(theRegex)) {
                theRegex = ESCAPE + theRegex;
            }
            for (String ePath : aPathMap.paths()) {
                String eBasePath = this.toPath(aToPath, ePath.replaceAll(theRegex, this.getRootPath()));
                Object eValue = aPathMap.get((Object)ePath);
                this.fromValue(eBasePath, eValue, aVisited);
            }
            aVisited.remove(aPathMap);
        }
    }

    private void fromMap(String aToPath, Map<?, ?> aMap, Set<Object> aVisited) {
        if (!aVisited.contains(aMap)) {
            aVisited.add(aMap);
            for (Object eObj : aMap.keySet()) {
                String eKey = eObj instanceof String ? (String)eObj : (eObj != null ? eObj.toString() : null);
                String eBasePath = this.toPath(aToPath, eKey);
                Object eValue = aMap.get(eObj);
                this.fromValue(eBasePath, eValue, aVisited);
            }
            aVisited.remove(aMap);
        }
    }

    private void fromKeys(String aToPath, Keys<?, ?> aKeys, Set<Object> aVisited) {
        if (!aVisited.contains(aKeys)) {
            aVisited.add(aKeys);
            for (Object eObj : aKeys.keySet()) {
                String eKey = eObj instanceof String ? (String)eObj : (eObj != null ? eObj.toString() : null);
                String eBasePath = this.toPath(aToPath, eKey);
                Object eValue = aKeys.get(eObj);
                this.fromValue(eBasePath, eValue, aVisited);
            }
            aVisited.remove(aKeys);
        }
    }

    private void fromCollection(String aToPath, Collection<?> aCollection, Set<Object> aVisited) {
        if (!aVisited.contains(aCollection)) {
            aVisited.add(aCollection);
            int index = 0;
            for (Object eValue : aCollection) {
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aCollection);
        }
    }

    private void fromArray(String aToPath, Object[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            for (Object eValue : aArray) {
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, boolean[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray) && !aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            boolean[] blArray = aArray;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean eValue = blArray[i];
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, byte[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            byte[] byArray = aArray;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte eValue = byArray[i];
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, char[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            char[] cArray = aArray;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character eValue = Character.valueOf(cArray[i]);
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, short[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            short[] sArray = aArray;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short eValue = sArray[i];
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, int[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            int[] nArray = aArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer eValue = nArray[i];
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, long[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            long[] lArray = aArray;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long eValue = lArray[i];
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, float[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            float[] fArray = aArray;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float eValue = Float.valueOf(fArray[i]);
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromArray(String aToPath, double[] aArray, Set<Object> aVisited) {
        if (!aVisited.contains(aArray)) {
            aVisited.add(aArray);
            int index = 0;
            double[] dArray = aArray;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double eValue = dArray[i];
                String eBasePath = this.toPath(aToPath, index);
                this.fromValue(eBasePath, eValue, aVisited);
                ++index;
            }
            aVisited.remove(aArray);
        }
    }

    private void fromObject(String aToPath, Object aObj, Set<Object> aVisited) {
        if (!aVisited.contains(aObj)) {
            aVisited.add(aObj);
            T theObj = this.fromInstance(aObj);
            if (theObj != null) {
                this.put(aToPath, theObj);
            } else {
                Class<?> theClass = aObj.getClass();
                HashMap<String, Object> theMap = new HashMap<String, Object>();
                if (theClass.isRecord()) {
                    RecordComponent[] theComponents = theClass.getRecordComponents();
                    if (theComponents != null && theComponents.length > 0) {
                        for (RecordComponent eComponent : theComponents) {
                            try {
                                Object eInvoked;
                                String ePropertyName = eComponent.getName();
                                if (this.isBlackListed(ePropertyName) || theMap.containsKey(ePropertyName) || aVisited.contains(eInvoked = eComponent.getAccessor().invoke(aObj, new Object[0]))) continue;
                                theMap.put(ePropertyName, eInvoked);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                                // empty catch block
                            }
                        }
                    }
                } else {
                    Field[] theFields;
                    Object eInvoked;
                    String ePropertyName;
                    Method[] theMethods = theClass.getMethods();
                    if (theMethods != null && theMethods.length > 0) {
                        for (Method eMethod : theMethods) {
                            if (!TypeUtility.isGetter(eMethod)) continue;
                            try {
                                ePropertyName = TypeUtility.fromGetterMethod(eMethod);
                                if (this.isBlackListed(ePropertyName) || theMap.containsKey(ePropertyName)) continue;
                                try {
                                    eMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                eInvoked = eMethod.invoke(aObj, new Object[0]);
                                if (aVisited.contains(eInvoked)) continue;
                                theMap.put(ePropertyName, eInvoked);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                                // empty catch block
                            }
                        }
                    }
                    if ((theFields = theClass.getDeclaredFields()) != null && theFields.length > 0) {
                        for (Field eField : theFields) {
                            try {
                                ePropertyName = TypeUtility.toPropertyName(eField);
                                if (this.isBlackListed(ePropertyName) || theMap.containsKey(ePropertyName)) continue;
                                try {
                                    eField.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (Modifier.isTransient(eField.getModifiers()) || (eInvoked = eField.get(aObj)) == null || aVisited.contains(eInvoked)) continue;
                                theMap.put(ePropertyName, eInvoked);
                            }
                            catch (IllegalAccessException | IllegalArgumentException exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!theMap.isEmpty()) {
                    this.fromValue(aToPath, theMap, aVisited);
                }
            }
            aVisited.remove(aObj);
        }
    }

    protected void fromValue(String aToPath, Object aValue, Set<Object> aVisited) {
        aToPath = this.toNormalizedPath(aToPath);
        if (aValue == null) {
            this.put(aToPath, (T)null);
        } else if (aValue instanceof PathMap) {
            this.fromPathMap(aToPath, (PathMap)aValue, aVisited);
        } else if (aValue instanceof Map) {
            this.fromMap(aToPath, (Map)aValue, aVisited);
        } else if (aValue instanceof Keys) {
            this.fromKeys(aToPath, (Keys)aValue, aVisited);
        } else if (aValue instanceof Collection) {
            this.fromCollection(aToPath, (Collection)aValue, aVisited);
        } else if (aValue.getClass().isArray()) {
            Class<?> theType = aValue.getClass().getComponentType();
            if (theType.equals(Boolean.TYPE)) {
                this.fromArray(aToPath, (boolean[])aValue, aVisited);
            } else if (theType.equals(Byte.TYPE)) {
                this.fromArray(aToPath, (byte[])aValue, aVisited);
            } else if (theType.equals(Character.TYPE)) {
                this.fromArray(aToPath, (char[])aValue, aVisited);
            } else if (theType.equals(Short.TYPE)) {
                this.fromArray(aToPath, (short[])aValue, aVisited);
            } else if (theType.equals(Integer.TYPE)) {
                this.fromArray(aToPath, (int[])aValue, aVisited);
            } else if (theType.equals(Long.TYPE)) {
                this.fromArray(aToPath, (long[])aValue, aVisited);
            } else if (theType.equals(Float.TYPE)) {
                this.fromArray(aToPath, (float[])aValue, aVisited);
            } else if (theType.equals(Double.TYPE)) {
                this.fromArray(aToPath, (double[])aValue, aVisited);
            } else {
                this.fromArray(aToPath, (Object[])aValue, aVisited);
            }
        } else {
            this.fromObject(aToPath, aValue, aVisited);
        }
    }

    private boolean isBlackListed(String aPropertyName) {
        for (String eBlackListed : BLACKLISTED_PROPERTIES) {
            if (!eBlackListed.equals(aPropertyName)) continue;
            return true;
        }
        return false;
    }

    protected void fromValue(String aToPath, Object aObj) {
        this.fromValue(aToPath, aObj, new HashSet<Object>());
    }

    protected PathMap<T> fromObject(Object aFrom) {
        return new PathMapImpl<T>(aFrom, this.getDelimiter(), this.getType());
    }

    protected T fromInstance(Object aValue) {
        if (this._type.isAssignableFrom(aValue.getClass())) {
            return (T)aValue;
        }
        if (this._type.isAssignableFrom(String.class)) {
            return (T)SimpleType.fromSimpleType(aValue);
        }
        return null;
    }

    protected <TYPE> TYPE toInstance(T aValue, Class<TYPE> aType) {
        if (aType.isAssignableFrom(aValue.getClass())) {
            return (TYPE)aValue;
        }
        return null;
    }

    protected Map<String, T> createBackingMap() {
        return new LinkedHashMap();
    }
}

