/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Comparator;
import java.util.regex.Pattern;
import org.refcodes.struct.PathSortStrategy;

public class PathComparator
implements Comparator<String> {
    private char _delimiter;
    private PathSortStrategy _pathSortStrategy;

    public PathComparator(char aDelimiter) {
        this(aDelimiter, PathSortStrategy.DEFAULT);
    }

    public PathComparator(char aDelimiter, PathSortStrategy aPathSortStrategy) {
        this._delimiter = aDelimiter;
        this._pathSortStrategy = aPathSortStrategy != null ? aPathSortStrategy : PathSortStrategy.DEFAULT;
    }

    @Override
    public int compare(String o1, String o2) {
        if (this._pathSortStrategy.isIgnoreCase()) {
            o1 = o1.toLowerCase();
            o2 = o2.toLowerCase();
        }
        if (this._pathSortStrategy.isAlphanumeric()) {
            String[] thePathB;
            String theDelimiter = Pattern.quote("" + this._delimiter);
            String[] thePathA = o1.split(theDelimiter);
            int theMin = thePathA.length < (thePathB = o2.split(theDelimiter)).length ? thePathA.length : thePathB.length;
            int theMax = thePathA.length > thePathB.length ? thePathA.length : thePathB.length;
            StringBuilder theBufA = new StringBuilder();
            StringBuilder theBufB = new StringBuilder();
            int i = 0;
            while (i < theMax) {
                if (i < thePathA.length) {
                    theBufA.append(this._delimiter);
                }
                if (i < thePathB.length) {
                    theBufB.append(this._delimiter);
                }
                if (i < theMin) {
                    try {
                        Integer.valueOf(thePathA[i]);
                        Integer.valueOf(thePathB[i]);
                        int eLength = thePathA[i].length() > thePathB[i].length() ? thePathA[i].length() : thePathB[i].length();
                        while (thePathA[i].length() < eLength) {
                            thePathA[i] = "0" + thePathA[i];
                        }
                        while (thePathB[i].length() < eLength) {
                            thePathB[i] = "0" + thePathB[i];
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (i < thePathA.length) {
                    theBufA.append(thePathA[i]);
                }
                if (i < thePathB.length) {
                    theBufB.append(thePathB[i]);
                }
                ++i;
            }
            return theBufA.toString().compareTo(theBufB.toString());
        }
        return o1.compareTo(o2);
    }
}

