/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.security.dynamically.example.repository;

import org.apache.commons.lang3.StringUtils;
import org.rxjava.security.dynamically.example.config.AuthenticationManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class DynamicallySecurityContextRepository
implements ServerSecurityContextRepository {
    @Autowired
    private AuthenticationManager authenticationManager;

    public Mono<Void> save(ServerWebExchange exchange, SecurityContext context) {
        return Mono.empty();
    }

    public Mono<SecurityContext> load(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        String token = request.getHeaders().getFirst("Authorization");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)token, (Object)token);
            return this.authenticationManager.authenticate((Authentication)auth).map(SecurityContextImpl::new);
        }
        return Mono.empty();
    }
}

