/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.assertj.core.util.Strings;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={Validator.class})
public @interface EnumValue {
    public String message() default "value is not enum";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public Class<? extends Enum<?>> enumClass();

    public String enumMethod() default "isValidName";

    public static class Validator
    implements ConstraintValidator<EnumValue, Object> {
        private Class<? extends Enum<?>> enumClass;
        private String enumMethod;

        public void initialize(EnumValue enumValue) {
            this.enumMethod = enumValue.enumMethod();
            this.enumClass = enumValue.enumClass();
        }

        public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
            if (value == null) {
                return Boolean.TRUE;
            }
            if (this.enumClass == null || this.enumMethod == null) {
                return Boolean.TRUE;
            }
            Class<?> valueClass = value.getClass();
            try {
                Method method = this.enumClass.getMethod(this.enumMethod, valueClass);
                if (!Boolean.TYPE.equals(method.getReturnType()) && !Boolean.class.equals(method.getReturnType())) {
                    throw new RuntimeException(Strings.formatIfArgs((String)"%s method return is not boolean type in the %s class", (Object[])new Object[]{this.enumMethod, this.enumClass}));
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException(Strings.formatIfArgs((String)"%s method is not static method in the %s class", (Object[])new Object[]{this.enumMethod, this.enumClass}));
                }
                Boolean result = (Boolean)method.invoke(null, value);
                return result == null ? false : result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(Strings.formatIfArgs((String)"This %s(%s) method does not exist in the %s", (Object[])new Object[]{this.enumMethod, valueClass, this.enumClass}), e);
            }
        }
    }
}

