/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.api;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.rxjava.apikit.client.ClientAdapter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.ConversionService;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;

public class ReactiveHttpClientAdapter
implements ClientAdapter {
    private static final Logger log = LogManager.getLogger();
    private WebClient webClient;
    private WebClient.Builder webClientBuilder;
    private String serviceId;
    private String host;
    private String port;
    private Function<Object, String> typeConvert;
    private String token;

    @PostConstruct
    public void init() {
        this.port = ":" + this.port;
        if (!StringUtils.isEmpty((Object)this.host)) {
            this.webClient = this.webClientBuilder.baseUrl("http://" + this.host + this.port + this.serviceId + "/").build();
            return;
        }
        this.webClient = this.webClientBuilder.baseUrl("http://" + this.serviceId + this.port + "/").build();
    }

    private ReactiveHttpClientAdapter(WebClient.Builder webClientBuilder, String serviceId) {
        this.serviceId = serviceId;
        this.webClientBuilder = webClientBuilder;
        this.port = "8080";
    }

    private ReactiveHttpClientAdapter(WebClient.Builder webClientBuilder, String serviceId, String port) {
        this.serviceId = serviceId;
        this.webClientBuilder = webClientBuilder;
        this.port = port;
        if (StringUtils.isEmpty((Object)port)) {
            this.port = "8080";
        }
    }

    private ReactiveHttpClientAdapter(WebClient.Builder webClientBuilder, String host, String port, String serviceId) {
        this.host = host;
        this.port = port;
        this.serviceId = serviceId;
        this.webClientBuilder = webClientBuilder;
    }

    public static ReactiveHttpClientAdapter build(ConversionService conversionService, WebClient.Builder webClientBuilder, String serviceId) {
        return ReactiveHttpClientAdapter.build(conversionService, webClientBuilder, serviceId, "8080");
    }

    public static ReactiveHttpClientAdapter build(ConversionService conversionService, WebClient.Builder webClientBuilder, String serviceId, String port) {
        ReactiveHttpClientAdapter adapter = new ReactiveHttpClientAdapter(webClientBuilder, serviceId, port);
        adapter.typeConvert = o -> (String)conversionService.convert(o, String.class);
        return adapter;
    }

    public static ReactiveHttpClientAdapter build(ConversionService conversionService, WebClient.Builder webClientBuilder, String host, String port, String serviceId) {
        ReactiveHttpClientAdapter adapter = new ReactiveHttpClientAdapter(webClientBuilder, host, port, serviceId);
        adapter.typeConvert = o -> (String)conversionService.convert(o, String.class);
        return adapter;
    }

    public <T> Mono<T> request(String method, String uri, List<Map.Entry<String, Object>> form, final Type returnType) {
        ParameterizedTypeReference typeRef = new ParameterizedTypeReference<T>(){

            @NotNull
            public Type getType() {
                return returnType;
            }
        };
        HttpMethod httpMethod = HttpMethod.valueOf((String)method);
        boolean postData = form != null && (httpMethod == HttpMethod.PUT || httpMethod == HttpMethod.POST || httpMethod == HttpMethod.PATCH || httpMethod == HttpMethod.DELETE);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (form != null) {
            for (Map.Entry<String, Object> item : form) {
                params.add((Object)item.getKey(), (Object)this.typeConvert.apply(item.getValue()));
            }
        }
        WebClient.RequestBodySpec bodySpec = (WebClient.RequestBodySpec)this.webClient.method(httpMethod).uri(arg_0 -> ReactiveHttpClientAdapter.lambda$request$2(uri, postData, form, (MultiValueMap)params, arg_0));
        bodySpec.header("Accept-Language", new String[]{"zh_CN"});
        if (this.token != null) {
            bodySpec = (WebClient.RequestBodySpec)bodySpec.header("authorization", new String[]{this.token});
        }
        WebClient.ResponseSpec retrieve = postData ? bodySpec.syncBody((Object)params).retrieve() : bodySpec.retrieve();
        return retrieve.bodyToMono(typeRef);
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public WebClient.Builder getWebClientBuilder() {
        return this.webClientBuilder;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public Function<Object, String> getTypeConvert() {
        return this.typeConvert;
    }

    public String getToken() {
        return this.token;
    }

    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public void setWebClientBuilder(WebClient.Builder webClientBuilder) {
        this.webClientBuilder = webClientBuilder;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setTypeConvert(Function<Object, String> typeConvert) {
        this.typeConvert = typeConvert;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactiveHttpClientAdapter)) {
            return false;
        }
        ReactiveHttpClientAdapter other = (ReactiveHttpClientAdapter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WebClient this$webClient = this.getWebClient();
        WebClient other$webClient = other.getWebClient();
        if (this$webClient == null ? other$webClient != null : !this$webClient.equals(other$webClient)) {
            return false;
        }
        WebClient.Builder this$webClientBuilder = this.getWebClientBuilder();
        WebClient.Builder other$webClientBuilder = other.getWebClientBuilder();
        if (this$webClientBuilder == null ? other$webClientBuilder != null : !this$webClientBuilder.equals(other$webClientBuilder)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        Function<Object, String> this$typeConvert = this.getTypeConvert();
        Function<Object, String> other$typeConvert = other.getTypeConvert();
        if (this$typeConvert == null ? other$typeConvert != null : !this$typeConvert.equals(other$typeConvert)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReactiveHttpClientAdapter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebClient $webClient = this.getWebClient();
        result = result * 59 + ($webClient == null ? 43 : $webClient.hashCode());
        WebClient.Builder $webClientBuilder = this.getWebClientBuilder();
        result = result * 59 + ($webClientBuilder == null ? 43 : $webClientBuilder.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        Function<Object, String> $typeConvert = this.getTypeConvert();
        result = result * 59 + ($typeConvert == null ? 43 : $typeConvert.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "ReactiveHttpClientAdapter(webClient=" + this.getWebClient() + ", webClientBuilder=" + this.getWebClientBuilder() + ", serviceId=" + this.getServiceId() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", typeConvert=" + this.getTypeConvert() + ", token=" + this.getToken() + ")";
    }

    private static /* synthetic */ URI lambda$request$2(String uri, boolean postData, List form, MultiValueMap params, UriBuilder uriBuilder) {
        uriBuilder = uriBuilder.path(uri);
        if (!postData && form != null) {
            uriBuilder = uriBuilder.queryParams(params);
        }
        return uriBuilder.build(new Object[0]);
    }
}

