/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.exception;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.rxjava.common.core.exception.DefaultError;
import org.rxjava.common.core.exception.FieldError;
import org.springframework.context.MessageSourceResolvable;

public class ErrorMessage
implements MessageSourceResolvable {
    private String[] codes;
    private Object[] arguments;
    private String defaultMessage;
    private LocalDateTime timestamp;
    private String path;
    private String message;
    private List<FieldError> errors;
    private int status;

    public ErrorMessage(String[] codes, Object[] arguments, String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public ErrorMessage(String code, Object ... args) {
        this(new String[]{code}, args);
    }

    public ErrorMessage(String[] codes, Object[] arguments) {
        this(codes, arguments, codes[0]);
    }

    public ErrorMessage(String code, String ... argCode) {
        this(code, (Object[])Stream.of(argCode).map(DefaultError::new).toArray(DefaultError[]::new));
    }

    public ErrorMessage addFieldObjs(String field, String[] codes, Object ... args) {
        return this.add(new FieldError(field, codes, args));
    }

    public ErrorMessage add(FieldError fieldError) {
        if (this.errors == null) {
            this.errors = new ArrayList<FieldError>();
        }
        this.errors.add(fieldError);
        return this;
    }

    public String[] getCodes() {
        return this.codes;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getPath() {
        return this.path;
    }

    public String getMessage() {
        return this.message;
    }

    public List<FieldError> getErrors() {
        return this.errors;
    }

    public int getStatus() {
        return this.status;
    }

    public void setCodes(String[] codes) {
        this.codes = codes;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setErrors(List<FieldError> errors) {
        this.errors = errors;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCodes(), other.getCodes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArguments(), other.getArguments())) {
            return false;
        }
        String this$defaultMessage = this.getDefaultMessage();
        String other$defaultMessage = other.getDefaultMessage();
        if (this$defaultMessage == null ? other$defaultMessage != null : !this$defaultMessage.equals(other$defaultMessage)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<FieldError> this$errors = this.getErrors();
        List<FieldError> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        return this.getStatus() == other.getStatus();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getCodes());
        result = result * 59 + Arrays.deepHashCode(this.getArguments());
        String $defaultMessage = this.getDefaultMessage();
        result = result * 59 + ($defaultMessage == null ? 43 : $defaultMessage.hashCode());
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<FieldError> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        result = result * 59 + this.getStatus();
        return result;
    }

    public String toString() {
        return "ErrorMessage(codes=" + Arrays.deepToString(this.getCodes()) + ", arguments=" + Arrays.deepToString(this.getArguments()) + ", defaultMessage=" + this.getDefaultMessage() + ", timestamp=" + this.getTimestamp() + ", path=" + this.getPath() + ", message=" + this.getMessage() + ", errors=" + this.getErrors() + ", status=" + this.getStatus() + ")";
    }
}

