/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.exception;

import java.text.MessageFormat;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.rxjava.common.core.exception.DefaultError;
import org.rxjava.common.core.exception.ErrorMessage;
import reactor.core.publisher.Mono;

public class ErrorMessageException
extends RuntimeException {
    private ErrorMessage errorMessage;

    private ErrorMessageException(String[] codes, Object[] arguments, String defaultMessage, Throwable cause) {
        super(MessageFormat.format("codes:{0},args:{1}, defaultMessage:{2}", ArrayUtils.toString((Object)codes), ArrayUtils.toString((Object)arguments), defaultMessage), cause);
        this.errorMessage = new ErrorMessage(codes, arguments, defaultMessage);
    }

    private static ErrorMessageException parseCode(String code, String ... argsCode) {
        return new ErrorMessageException(code, argsCode);
    }

    private ErrorMessageException(String code, String ... argsCodes) {
        this(new String[]{code}, Stream.of(argsCodes).map(DefaultError::new).toArray(DefaultError[]::new), null, null);
    }

    public static <T> Mono<T> mono(String code) {
        return Mono.error((Throwable)ErrorMessageException.parseCode(code, new String[0]));
    }

    public static ErrorMessageException of(String code) {
        return new ErrorMessageException(new String[]{code}, null, null, null);
    }

    public ErrorMessage getErrorMessage() {
        return this.errorMessage;
    }
}

