/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.exception;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.Assert;
import reactor.util.annotation.Nullable;

@JsonIgnoreProperties(value={"code"})
public class FieldError
implements MessageSourceResolvable {
    private String[] codes;
    private Object[] arguments;
    private String defaultMessage;
    private String field;
    private String message;

    public FieldError() {
    }

    private FieldError(String[] codes, Object[] arguments, String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public FieldError(String field, String defaultMessage) {
        this(field, null, null, defaultMessage);
    }

    public FieldError(String field, @Nullable String[] codes, @Nullable Object[] arguments, @Nullable String defaultMessage) {
        this(codes, arguments, defaultMessage);
        Assert.notNull((Object)field, (String)"Object name must not be null");
        this.field = field;
    }

    public FieldError(String field, @Nullable String[] codes, @Nullable Object[] arguments) {
        this(codes, arguments, null);
        Assert.notNull((Object)field, (String)"Object name must not be null");
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String[] getCodes() {
        return this.codes;
    }

    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getDefaultMessage() {
        String defaultMessage = this.defaultMessage;
        if (defaultMessage == null) {
            return this.getCode();
        }
        return defaultMessage;
    }

    public void setCodes(String[] codes) {
        this.codes = codes;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public void setDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
    }

    public String toString() {
        return "FieldError{codes=" + Arrays.toString(this.codes) + ", arguments=" + Arrays.toString(this.arguments) + ", defaultMessage='" + this.defaultMessage + '\'' + ", field='" + this.field + '\'' + ", message='" + this.message + '\'' + '}';
    }
}

