/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.exception;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rxjava.common.core.exception.ErrorMessage;
import org.rxjava.common.core.exception.ErrorMessageException;
import org.rxjava.common.core.exception.UnauthorizedException;
import org.rxjava.common.core.utils.ErrorMessageUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.handler.WebFluxResponseStatusExceptionHandler;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JsonResponseStatusExceptionHandler
extends WebFluxResponseStatusExceptionHandler
implements ErrorWebExceptionHandler,
InitializingBean,
MessageSourceAware {
    private static final Logger log = LogManager.getLogger();
    private List<HttpMessageWriter<?>> messageWriters = Collections.emptyList();
    private List<ViewResolver> viewResolvers = Collections.emptyList();
    private MessageSourceAccessor messageAccessor;
    private ServerResponse.Context serverResponseContext = new ServerResponse.Context(){

        public List<HttpMessageWriter<?>> messageWriters() {
            return JsonResponseStatusExceptionHandler.this.messageWriters;
        }

        public List<ViewResolver> viewResolvers() {
            return JsonResponseStatusExceptionHandler.this.viewResolvers;
        }
    };

    public Mono<Void> handle(ServerWebExchange exchange, Throwable throwable) {
        if (exchange.getResponse().isCommitted()) {
            return Mono.error((Throwable)throwable);
        }
        ErrorMessage errorMessage = this.toErrorMessage(exchange, throwable);
        return ServerResponse.status((int)errorMessage.getStatus()).contentType(MediaType.APPLICATION_JSON_UTF8).body(BodyInserters.fromObject((Object)errorMessage)).flatMap(response -> this.write(exchange, (ServerResponse)response));
    }

    private Mono<Void> write(ServerWebExchange exchange, ServerResponse response) {
        exchange.getResponse().getHeaders().setContentType(response.headers().getContentType());
        return response.writeTo(exchange, this.serverResponseContext);
    }

    private ErrorMessage toErrorMessage(ServerWebExchange exchange, Throwable throwable) {
        ErrorMessage errorMessage;
        HttpStatus status;
        ServerHttpRequest request = exchange.getRequest();
        if (throwable instanceof WebExchangeBindException) {
            WebExchangeBindException webExchangeBindException = (WebExchangeBindException)throwable;
            status = HttpStatus.UNPROCESSABLE_ENTITY;
            errorMessage = JsonResponseStatusExceptionHandler.transform(webExchangeBindException.getBindingResult());
            log.info("WebExchangeBindException:", throwable);
        } else if (throwable instanceof ErrorMessageException) {
            ErrorMessageException errorMessageException = (ErrorMessageException)throwable;
            status = HttpStatus.UNPROCESSABLE_ENTITY;
            errorMessage = errorMessageException.getErrorMessage();
            log.info("ErrorMessageException:", throwable);
        } else if (throwable instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)throwable;
            status = responseStatusException.getStatus();
            errorMessage = new ErrorMessage(responseStatusException.getReason(), new String[0]);
            RequestPath path = request.getPath();
            log.info("http status:{},reason:{},path:{},method:{}", (Object)status, (Object)responseStatusException.getReason(), (Object)path, (Object)request.getMethodValue());
            log.debug("http status:{},reason:{}", (Object)status, (Object)responseStatusException.getReason(), (Object)throwable);
        } else if (throwable instanceof UnauthorizedException) {
            status = HttpStatus.UNAUTHORIZED;
            errorMessage = new ErrorMessage("unauthorized", new String[0]);
            log.info("http status:{},reason:{}", (Object)status, (Object)"\u9700\u8981\u767b\u9646");
            log.debug("http status:{},reason:{}", (Object)status, (Object)"\u9700\u8981\u767b\u9646", (Object)throwable);
        } else {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
            log.info("Error:", throwable);
            errorMessage = new ErrorMessage("server.error", new Object[]{throwable.getMessage()});
        }
        errorMessage.setStatus(status.value());
        errorMessage.setTimestamp(LocalDateTime.now());
        errorMessage.setPath(request.getPath().pathWithinApplication().value());
        ErrorMessageUtils.handlerI18n(errorMessage, this.messageAccessor);
        return errorMessage;
    }

    private static ErrorMessage transform(BindingResult bindingResult) {
        ErrorMessage errorMessage = new ErrorMessage("server.validator", new String[0]);
        for (ObjectError error : bindingResult.getAllErrors()) {
            String key = error instanceof FieldError ? ((FieldError)error).getField() : error.getObjectName();
            errorMessage.addFieldObjs(key, error.getCodes(), error.getArguments());
        }
        return errorMessage;
    }

    public void setMessageWriters(List<HttpMessageWriter<?>> messageWriters) {
        Assert.notNull(messageWriters, (String)"'messageWriters' must not be null");
        this.messageWriters = messageWriters;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.messageWriters)) {
            throw new IllegalArgumentException("Property 'messageWriters' is required");
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageAccessor = new MessageSourceAccessor(messageSource, Locale.CHINA);
    }
}

