/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.rxjava.common.core.utils.JsonUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class RequestTool {
    public Mono<JsonNode> get(String requestUrl) {
        return this.get(requestUrl, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public Mono<JsonNode> get(String requestUrl, MultiValueMap<String, String> params) {
        return ((WebClient.RequestBodySpec)WebClient.create((String)requestUrl).method(HttpMethod.GET).uri(uriBuilder -> {
            if (params.isEmpty()) {
                return uriBuilder.build(new Object[0]);
            }
            return uriBuilder.queryParams(params).build(new Object[0]);
        })).retrieve().bodyToMono(String.class).map(jsonStr -> {
            if (StringUtils.isEmpty((Object)jsonStr) || !jsonStr.startsWith("[") && !jsonStr.startsWith("{")) {
                return JsonNodeFactory.instance.missingNode();
            }
            return JsonUtils.deserialize(jsonStr, JsonNode.class);
        });
    }

    public Mono<String> post(String requestUrl) {
        return this.post(requestUrl, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public Mono<String> post(String requestUrl, MultiValueMap<String, String> params) {
        return WebClient.create((String)requestUrl).method(HttpMethod.POST).body((BodyInserter)BodyInserters.fromFormData(params)).retrieve().bodyToMono(String.class);
    }

    public static void main(String[] args) {
        JsonNode block = (JsonNode)new RequestTool().get("https://qy-h5-dev.billbear.cn/api/javahotel/cityList").block();
        System.out.println(block);
    }
}

