/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FileRenameUtils {
    public static final HanyuPinyinOutputFormat FORMAT = new HanyuPinyinOutputFormat();

    public static void main(String[] args) {
        Path source = Paths.get("/Users/happy/DeskTop/img", new String[0]);
        Path dist = Paths.get("/Users/happy/DeskTop/img_py", new String[0]);
        FileRenameUtils.handler(source, dist, "@", "Select");
    }

    private static void handler(Path source, Path dist, String split, String suffix) {
        try {
            if (Files.isDirectory(source, new LinkOption[0])) {
                Files.list(source).forEach(child -> {
                    Path fileName = child.getFileName();
                    String pinyinName = FileRenameUtils.toPinyin(fileName.getFileName().toString());
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{split, suffix})) {
                        pinyinName = pinyinName.replace(split, suffix + split);
                    }
                    FileRenameUtils.handler(child, dist.resolve(pinyinName));
                });
            } else {
                String pinyinName = FileRenameUtils.toPinyin(dist.getFileName().toString()) + suffix;
                Files.createDirectories(dist.getParent(), new FileAttribute[0]);
                Files.copy(source, dist.resolveSibling(pinyinName), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void handler(Path source, Path dist) {
        FileRenameUtils.handler(source, dist, "", "");
    }

    public static String toPinyin(String name) {
        return name.chars().mapToObj(r -> {
            try {
                char ch = (char)r;
                Object[] pinyins = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)FORMAT);
                if (ArrayUtils.isEmpty((Object[])pinyins)) {
                    return Character.toString(ch);
                }
                Object pinyin = pinyins[0];
                return ((String)pinyin).substring(0, 1).toUpperCase() + (((String)pinyin).length() > 1 ? ((String)pinyin).substring(1) : "");
            }
            catch (BadHanyuPinyinOutputFormatCombination ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.joining());
    }

    static {
        FORMAT.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        FORMAT.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        FORMAT.setVCharType(HanyuPinyinVCharType.WITH_V);
    }
}

