/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.common.core.utils;

import java.util.Base64;
import java.util.UUID;

public class UUIDUtils {
    public static String randomUUIDToBase64() {
        UUID uuid = UUID.randomUUID();
        byte[] uuidArr = UUIDUtils.asByteArray(uuid);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(uuidArr);
    }

    public static void main(String[] args) {
        System.out.println(UUIDUtils.randomUUIDToBase64());
        System.out.println(UUIDUtils.randomUUIDToBase64().length());
    }

    public static byte[] asByteArray(UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return buffer;
    }

    public static UUID toUUID(byte[] byteArray) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(byteArray[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(byteArray[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

