/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.AppearanceRetained;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.ColoringAttributesRetained;
import org.scijava.java3d.CompressedGeometryRetained;
import org.scijava.java3d.Context;
import org.scijava.java3d.DisplayListRenderMethod;
import org.scijava.java3d.GeometryArrayRetained;
import org.scijava.java3d.GeometryAtom;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.IndexedGeometryArrayRetained;
import org.scijava.java3d.IndexedObject;
import org.scijava.java3d.IndexedUnorderSet;
import org.scijava.java3d.LineAttributesRetained;
import org.scijava.java3d.Locale;
import org.scijava.java3d.MaterialRetained;
import org.scijava.java3d.MorphRetained;
import org.scijava.java3d.NodeComponentRetained;
import org.scijava.java3d.NodeComponentUpdate;
import org.scijava.java3d.ObjectUpdate;
import org.scijava.java3d.OrientedShape3DRetained;
import org.scijava.java3d.PointAttributesRetained;
import org.scijava.java3d.PolygonAttributesRetained;
import org.scijava.java3d.RasterRetained;
import org.scijava.java3d.RenderAtom;
import org.scijava.java3d.RenderAtomListInfo;
import org.scijava.java3d.RenderBin;
import org.scijava.java3d.RenderMethod;
import org.scijava.java3d.RenderingAttributesRetained;
import org.scijava.java3d.SwitchRetained;
import org.scijava.java3d.TextureBin;
import org.scijava.java3d.TextureUnitStateRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransparencyAttributesRetained;
import org.scijava.java3d.TransparentRenderingInfo;
import org.scijava.java3d.VertexArrayRenderMethod;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Vector3d;

class RenderMolecule
extends IndexedObject
implements ObjectUpdate,
NodeComponentUpdate {
    static final int REMOVE_RENDER_ATOM_IN_RM_LIST = 0;
    static final int RENDER_MOLECULE_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    static final int POINT = 1;
    static final int LINE = 2;
    static final int SURFACE = 4;
    static final int RASTER = 8;
    static final int COMPRESSED = 16;
    static int RM_COMPONENTS = 945;
    PolygonAttributesRetained polygonAttributes = null;
    LineAttributesRetained lineAttributes = null;
    PointAttributesRetained pointAttributes = null;
    MaterialRetained material = null;
    ColoringAttributesRetained coloringAttributes = null;
    TransparencyAttributesRetained transparency = null;
    boolean normalPresent = true;
    static final int POINTATTRS_DIRTY = 512;
    static final int LINEATTRS_DIRTY = 256;
    static final int POLYGONATTRS_DIRTY = 128;
    static final int MATERIAL_DIRTY = 1;
    static final int TRANSPARENCY_DIRTY = 32;
    static final int COLORINGATTRS_DIRTY = 16;
    static final int ALL_DIRTY_BITS = 945;
    int dirtyAttrsAcrossRms = 945;
    int soleUserCompDirty = 0;
    PolygonAttributesRetained definingPolygonAttributes = null;
    LineAttributesRetained definingLineAttributes = null;
    PointAttributesRetained definingPointAttributes = null;
    TextureBin textureBin = null;
    Transform3D[] localToVworld = null;
    int[] localToVworldIndex = null;
    MaterialRetained definingMaterial = null;
    ColoringAttributesRetained definingColoringAttributes = null;
    TransparencyAttributesRetained definingTransparency = null;
    Transform3D[] trans = null;
    boolean isNonUniformScale = false;
    int numRenderAtoms = 0;
    int numEditingRenderAtoms = 0;
    RenderAtom addRAs = null;
    RenderAtom removeRAs = null;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    float dRed = 1.0f;
    float dGreen = 1.0f;
    float dBlue = 1.0f;
    float alpha = 0.0f;
    int geometryType = -1;
    boolean enableLighting = false;
    int primaryMoleculeType = 0;
    static int COMPRESSED_MOLECULE = 1;
    static int TEXT3D_MOLECULE = 2;
    static int DLIST_MOLECULE = 4;
    static int RASTER_MOLECULE = 8;
    static int ORIENTEDSHAPE3D_MOLECULE = 16;
    static int SEPARATE_DLIST_PER_RINFO_MOLECULE = 32;
    int polygonMode = 2;
    boolean lineAA = false;
    boolean pointAA = false;
    int vertexFormat = -1;
    int texCoordSetMapLen = 0;
    RenderMethod primaryRenderMethod = null;
    RenderMethod secondaryRenderMethod = null;
    RenderBin renderBin = null;
    RenderMolecule next = null;
    RenderMolecule prev = null;
    RenderAtomListInfo primaryRenderAtomList = null;
    RenderAtomListInfo separateDlistRenderAtomList = null;
    RenderAtomListInfo vertexArrayRenderAtomList = null;
    BoundingBox vwcBounds = null;
    RenderMolecule nextMap = null;
    RenderMolecule prevMap = null;
    boolean soleUser = false;
    Object appHandle = null;
    VertexArrayRenderMethod cachedVertexArrayRenderMethod = (VertexArrayRenderMethod)VirtualUniverse.mc.getVertexArrayRenderMethod();
    boolean isQuadGeometryArray = false;
    boolean isTriGeometryArray = false;
    int displayListId = 0;
    Integer displayListIdObj = null;
    int onUpdateList = 0;
    static int NEW_RENDERATOMS_UPDATE = 1;
    static int BOUNDS_RECOMPUTE_UPDATE = 2;
    static int LOCALE_TRANSLATION = 4;
    static int UPDATE_BACKGROUND_TRANSFORM = 8;
    static int IN_DIRTY_RENDERMOLECULE_LIST = 16;
    static int LOCALE_CHANGED = 32;
    static int ON_UPDATE_CHECK_LIST = 64;
    boolean doInfinite;
    Transform3D[] infLocalToVworld;
    boolean useAlpha = false;
    Locale locale = null;
    Transform3D[] localeLocalToVworld = null;
    Vector3d localeTranslation = null;
    boolean primaryChanged = false;
    boolean isOpaqueOrInOG = true;
    boolean inOrderedGroup = false;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;

    RenderMolecule(GeometryAtom ga, PolygonAttributesRetained polygonAttributes, LineAttributesRetained lineAttributes, PointAttributesRetained pointAttributes, MaterialRetained material, ColoringAttributesRetained coloringAttributes, TransparencyAttributesRetained transparency, RenderingAttributesRetained renderAttrs, TextureUnitStateRetained[] texUnits, Transform3D[] transform, int[] transformIndex, RenderBin rb) {
        this.renderBin = rb;
        IndexedUnorderSet.init(this, 2);
        this.reset(ga, polygonAttributes, lineAttributes, pointAttributes, material, coloringAttributes, transparency, renderAttrs, texUnits, transform, transformIndex);
    }

    void reset(GeometryAtom ga, PolygonAttributesRetained polygonAttributes, LineAttributesRetained lineAttributes, PointAttributesRetained pointAttributes, MaterialRetained material, ColoringAttributesRetained coloringAttributes, TransparencyAttributesRetained transparency, RenderingAttributesRetained renderAttrs, TextureUnitStateRetained[] texUnits, Transform3D[] transform, int[] transformIndex) {
        this.primaryMoleculeType = 0;
        this.numRenderAtoms = 0;
        this.numEditingRenderAtoms = 0;
        this.onUpdateList = 0;
        this.dirtyAttrsAcrossRms = 945;
        this.primaryRenderMethod = null;
        this.isNonUniformScale = false;
        this.primaryChanged = false;
        this.material = material;
        this.polygonAttributes = polygonAttributes;
        this.lineAttributes = lineAttributes;
        this.pointAttributes = pointAttributes;
        this.coloringAttributes = coloringAttributes;
        this.transparency = transparency;
        this.closestSwitchParent = ga.source.closestSwitchParent;
        this.closestSwitchIndex = ga.source.closestSwitchIndex;
        GeometryRetained geo = null;
        this.isOpaqueOrInOG = true;
        this.inOrderedGroup = false;
        for (int k = 0; geo == null && k < ga.geometryArray.length; ++k) {
            geo = ga.geometryArray[k];
        }
        this.soleUser = false;
        if (VirtualUniverse.mc.allowSoleUser && ga.source.appearance != null) {
            this.soleUser = (ga.source.appearance.changedFrequent & RM_COMPONENTS) != 0;
        }
        this.appHandle = this.soleUser ? ga.source.appearance : this;
        if (ga.geoType <= 14 || ga.geoType == 16) {
            if (ga.source instanceof OrientedShape3DRetained) {
                this.primaryRenderMethod = VirtualUniverse.mc.getOrientedShape3DRenderMethod();
                this.primaryMoleculeType = ORIENTEDSHAPE3D_MOLECULE;
            } else if (ga.geoType == 16) {
                this.primaryRenderMethod = VirtualUniverse.mc.getText3DRenderMethod();
                this.primaryMoleculeType = TEXT3D_MOLECULE;
            } else {
                this.secondaryRenderMethod = this.cachedVertexArrayRenderMethod;
            }
        } else if (ga.geoType == 17) {
            this.primaryRenderMethod = VirtualUniverse.mc.getCompressedGeometryRenderMethod();
            this.primaryMoleculeType = COMPRESSED_MOLECULE;
        } else if (geo instanceof RasterRetained) {
            this.primaryRenderMethod = VirtualUniverse.mc.getDefaultRenderMethod();
            this.primaryMoleculeType = RASTER_MOLECULE;
        }
        this.prev = null;
        this.next = null;
        this.prevMap = null;
        this.nextMap = null;
        this.primaryRenderAtomList = null;
        this.vertexArrayRenderAtomList = null;
        block0 : switch (ga.geoType) {
            case 3: 
            case 10: {
                this.geometryType = 1;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                this.geometryType = 2;
                break;
            }
            case 15: {
                this.geometryType = 8;
                break;
            }
            case 17: {
                this.geometryType = 16;
                switch (((CompressedGeometryRetained)geo).getBufferType()) {
                    case 0: {
                        this.geometryType |= 1;
                        break block0;
                    }
                    case 1: {
                        this.geometryType |= 2;
                        break block0;
                    }
                }
                this.geometryType |= 4;
                if (polygonAttributes == null) break;
                if (polygonAttributes.polygonMode == 0) {
                    this.geometryType |= 1;
                    break;
                }
                if (polygonAttributes.polygonMode != 1) break;
                this.geometryType |= 2;
                break;
            }
            default: {
                this.geometryType = 4;
                if (polygonAttributes == null) break;
                if (polygonAttributes.polygonMode == 0) {
                    this.geometryType |= 1;
                    break;
                }
                if (polygonAttributes.polygonMode != 1) break;
                this.geometryType |= 2;
            }
        }
        this.isQuadGeometryArray = geo.getClassType() == 4;
        this.isTriGeometryArray = geo.getClassType() == 3;
        this.localToVworld = transform;
        this.localToVworldIndex = transformIndex;
        this.doInfinite = ga.source.inBackgroundGroup;
        if (this.doInfinite) {
            if (this.infLocalToVworld == null) {
                this.infLocalToVworld = new Transform3D[2];
                this.infLocalToVworld[0] = this.infLocalToVworld[1] = new Transform3D();
            }
            this.localToVworld[0].getRotation(this.infLocalToVworld[0]);
        }
        int mask = 0;
        if (polygonAttributes != null) {
            if (polygonAttributes.changedFrequent != 0) {
                this.definingPolygonAttributes = polygonAttributes;
                mask |= 0x80;
            } else if (this.definingPolygonAttributes != null) {
                this.definingPolygonAttributes.set(polygonAttributes);
            } else {
                this.definingPolygonAttributes = (PolygonAttributesRetained)polygonAttributes.clone();
            }
            this.polygonMode = this.definingPolygonAttributes.polygonMode;
        } else {
            this.polygonMode = 2;
            this.definingPolygonAttributes = null;
        }
        if (lineAttributes != null) {
            if (lineAttributes.changedFrequent != 0) {
                this.definingLineAttributes = lineAttributes;
                mask |= 0x100;
            } else if (this.definingLineAttributes != null) {
                this.definingLineAttributes.set(lineAttributes);
            } else {
                this.definingLineAttributes = (LineAttributesRetained)lineAttributes.clone();
            }
            this.lineAA = this.definingLineAttributes.lineAntialiasing;
        } else {
            this.lineAA = false;
            this.definingLineAttributes = null;
        }
        if (pointAttributes != null) {
            if (pointAttributes.changedFrequent != 0) {
                this.definingPointAttributes = pointAttributes;
                mask |= 0x200;
            } else if (this.definingPointAttributes != null) {
                this.definingPointAttributes.set(pointAttributes);
            } else {
                this.definingPointAttributes = (PointAttributesRetained)pointAttributes.clone();
            }
            this.pointAA = this.definingPointAttributes.pointAntialiasing;
        } else {
            this.pointAA = false;
            this.definingPointAttributes = null;
        }
        this.normalPresent = true;
        if (geo instanceof GeometryArrayRetained) {
            GeometryArrayRetained gr = (GeometryArrayRetained)geo;
            this.vertexFormat = gr.vertexFormat;
            this.texCoordSetMapLen = gr.texCoordSetMap != null ? gr.texCoordSetMap.length : 0;
            if ((this.vertexFormat & 2) == 0) {
                this.normalPresent = false;
            }
        } else if (geo instanceof CompressedGeometryRetained) {
            this.vertexFormat = ((CompressedGeometryRetained)geo).getVertexFormat();
            if ((this.vertexFormat & 2) == 0) {
                this.normalPresent = false;
            }
            this.texCoordSetMapLen = 0;
        } else {
            this.vertexFormat = -1;
            this.texCoordSetMapLen = 0;
        }
        if (material != null) {
            if (material.changedFrequent != 0) {
                this.definingMaterial = material;
                mask |= 1;
            } else if (this.definingMaterial != null) {
                this.definingMaterial.set(material);
            } else {
                this.definingMaterial = (MaterialRetained)material.clone();
            }
        } else {
            this.definingMaterial = null;
        }
        this.evalMaterialCachedState();
        if (coloringAttributes != null) {
            if (coloringAttributes.changedFrequent != 0) {
                this.definingColoringAttributes = coloringAttributes;
                mask |= 0x10;
            } else if (this.definingColoringAttributes != null) {
                this.definingColoringAttributes.set(coloringAttributes);
            } else {
                this.definingColoringAttributes = (ColoringAttributesRetained)coloringAttributes.clone();
            }
            this.red = coloringAttributes.color.x;
            this.green = coloringAttributes.color.y;
            this.blue = coloringAttributes.color.z;
        } else {
            this.red = 1.0f;
            this.green = 1.0f;
            this.blue = 1.0f;
            this.definingColoringAttributes = null;
        }
        if (transparency != null) {
            if (transparency.changedFrequent != 0) {
                this.definingTransparency = transparency;
                mask |= 0x20;
            } else if (this.definingTransparency != null) {
                this.definingTransparency.set(transparency);
            } else {
                this.definingTransparency = (TransparencyAttributesRetained)transparency.clone();
            }
            this.alpha = 1.0f - transparency.transparency;
        } else {
            this.alpha = 1.0f;
            this.definingTransparency = null;
        }
        this.locale = ga.source.locale;
        if (this.locale != this.renderBin.locale) {
            if (this.localeLocalToVworld == null) {
                this.localeLocalToVworld = new Transform3D[2];
            }
            this.localeLocalToVworld[0] = new Transform3D();
            this.localeLocalToVworld[1] = new Transform3D();
            this.localeTranslation = new Vector3d();
            ga.locale.hiRes.difference(this.renderBin.locale.hiRes, this.localeTranslation);
            this.translate();
        } else {
            this.localeLocalToVworld = this.localToVworld;
        }
        this.trans = this.doInfinite ? this.infLocalToVworld : this.localeLocalToVworld;
        this.evalAlphaUsage(renderAttrs, texUnits);
        this.isOpaqueOrInOG = this.isOpaque() || ga.source.orderedPath != null;
        boolean bl = this.inOrderedGroup = ga.source.orderedPath != null;
        if (mask != 0) {
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= mask;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean equals(RenderAtom ra, PolygonAttributesRetained polygonAttributes, LineAttributesRetained lineAttributes, PointAttributesRetained pointAttributes, MaterialRetained material, ColoringAttributesRetained coloringAttributes, TransparencyAttributesRetained transparency, Transform3D[] transform) {
        block68: {
            block67: {
                block66: {
                    block65: {
                        block64: {
                            block63: {
                                block62: {
                                    block61: {
                                        block60: {
                                            block59: {
                                                int geoType = 0;
                                                GeometryAtom ga = ra.geometryAtom;
                                                if (this.localToVworld != transform) {
                                                    return false;
                                                }
                                                if (this.locale != ra.geometryAtom.source.locale) {
                                                    return false;
                                                }
                                                if (ra.geometryAtom.source.closestSwitchParent != this.closestSwitchParent) return false;
                                                if (ra.geometryAtom.source.closestSwitchIndex != this.closestSwitchIndex) {
                                                    return false;
                                                }
                                                GeometryRetained geo = null;
                                                for (int k = 0; geo == null && k < ga.geometryArray.length; ++k) {
                                                    geo = ga.geometryArray[k];
                                                }
                                                block0 : switch (ga.geoType) {
                                                    case 3: 
                                                    case 10: {
                                                        geoType = 1;
                                                        break;
                                                    }
                                                    case 4: 
                                                    case 7: 
                                                    case 11: 
                                                    case 14: {
                                                        geoType = 2;
                                                        break;
                                                    }
                                                    case 15: {
                                                        geoType = 8;
                                                        break;
                                                    }
                                                    case 17: {
                                                        geoType = 16;
                                                        switch (((CompressedGeometryRetained)geo).getBufferType()) {
                                                            case 0: {
                                                                geoType |= 1;
                                                                break block0;
                                                            }
                                                            case 1: {
                                                                geoType |= 2;
                                                                break block0;
                                                            }
                                                        }
                                                        geoType |= 4;
                                                        break;
                                                    }
                                                    default: {
                                                        geoType = 4;
                                                        if (polygonAttributes == null) break;
                                                        if (polygonAttributes.polygonMode == 0) {
                                                            geoType |= 1;
                                                            break;
                                                        }
                                                        if (polygonAttributes.polygonMode != 1) break;
                                                        geoType |= 2;
                                                    }
                                                }
                                                if (this.geometryType != geoType) {
                                                    return false;
                                                }
                                                if (ga.geoType == 16 && this.primaryMoleculeType != 0 && (this.primaryMoleculeType & TEXT3D_MOLECULE) == 0) {
                                                    return false;
                                                }
                                                if (!(ra.geometryAtom.source instanceof OrientedShape3DRetained) && (this.primaryMoleculeType & ORIENTEDSHAPE3D_MOLECULE) != 0) {
                                                    return false;
                                                }
                                                if (geo instanceof GeometryArrayRetained) {
                                                    GeometryArrayRetained gr = (GeometryArrayRetained)geo;
                                                    if (this.vertexFormat != gr.vertexFormat) {
                                                        return false;
                                                    }
                                                    if (gr.texCoordSetMap != null) {
                                                        if (this.texCoordSetMapLen != gr.texCoordSetMap.length) return false;
                                                    }
                                                    if (gr.texCoordSetMap == null && this.texCoordSetMapLen != 0) {
                                                        return false;
                                                    }
                                                } else if (geo instanceof CompressedGeometryRetained ? this.vertexFormat != ((CompressedGeometryRetained)geo).getVertexFormat() : this.vertexFormat != -1) {
                                                    return false;
                                                }
                                                if (this.soleUser || ra.geometryAtom.source.appearance != null && (ra.geometryAtom.source.appearance.changedFrequent & RM_COMPONENTS) != 0) {
                                                    if (this.appHandle != ra.geometryAtom.source.appearance) return false;
                                                    if (this.numEditingRenderAtoms != 0) return true;
                                                    if ((this.soleUserCompDirty & 0x3B1) == 0) {
                                                        this.renderBin.rmUpdateList.add(this);
                                                    }
                                                    this.soleUserCompDirty |= 0x3B1;
                                                    return true;
                                                }
                                                if (this.definingPolygonAttributes == null) break block59;
                                                if (this.definingPolygonAttributes.changedFrequent != 0 || polygonAttributes != null && polygonAttributes.changedFrequent != 0) {
                                                    if (this.definingPolygonAttributes != polygonAttributes) return false;
                                                    if (this.definingPolygonAttributes.compChanged != 0) {
                                                        if ((this.soleUserCompDirty & 0x3B1) == 0) {
                                                            this.renderBin.rmUpdateList.add(this);
                                                        }
                                                        this.soleUserCompDirty |= 0x80;
                                                    }
                                                    break block60;
                                                } else if (!this.definingPolygonAttributes.equivalent(polygonAttributes)) {
                                                    return false;
                                                }
                                                break block60;
                                            }
                                            if (polygonAttributes != null) {
                                                return false;
                                            }
                                        }
                                        if (this.definingLineAttributes == null) break block61;
                                        if (this.definingLineAttributes.changedFrequent != 0 || lineAttributes != null && lineAttributes.changedFrequent != 0) {
                                            if (this.definingLineAttributes != lineAttributes) return false;
                                            if (this.definingLineAttributes.compChanged != 0) {
                                                if ((this.soleUserCompDirty & 0x3B1) == 0) {
                                                    this.renderBin.rmUpdateList.add(this);
                                                }
                                                this.soleUserCompDirty |= 0x100;
                                            }
                                            break block62;
                                        } else if (!this.definingLineAttributes.equivalent(lineAttributes)) {
                                            return false;
                                        }
                                        break block62;
                                    }
                                    if (lineAttributes != null) {
                                        return false;
                                    }
                                }
                                if (this.definingPointAttributes == null) break block63;
                                if (this.definingPointAttributes.changedFrequent != 0 || pointAttributes != null && pointAttributes.changedFrequent != 0) {
                                    if (this.definingPointAttributes != pointAttributes) return false;
                                    if (this.definingPointAttributes.compChanged != 0) {
                                        if ((this.soleUserCompDirty & 0x3B1) == 0) {
                                            this.renderBin.rmUpdateList.add(this);
                                        }
                                        this.soleUserCompDirty |= 0x200;
                                    }
                                    break block64;
                                } else if (!this.definingPointAttributes.equivalent(pointAttributes)) {
                                    return false;
                                }
                                break block64;
                            }
                            if (pointAttributes != null) {
                                return false;
                            }
                        }
                        if (this.definingMaterial == null) break block65;
                        if (this.definingMaterial.changedFrequent != 0 || material != null && material.changedFrequent != 0) {
                            if (this.definingMaterial != material) return false;
                            if (this.definingMaterial.compChanged != 0) {
                                if ((this.soleUserCompDirty & 0x3B1) == 0) {
                                    this.renderBin.rmUpdateList.add(this);
                                }
                                this.soleUserCompDirty |= 1;
                            }
                            break block66;
                        } else if (!this.definingMaterial.equivalent(material)) {
                            return false;
                        }
                        break block66;
                    }
                    if (material != null) {
                        return false;
                    }
                }
                if (this.definingColoringAttributes == null) break block67;
                if (this.definingColoringAttributes.changedFrequent != 0 || coloringAttributes != null && coloringAttributes.changedFrequent != 0) {
                    if (this.definingColoringAttributes != coloringAttributes) return false;
                    if (this.definingColoringAttributes.compChanged != 0) {
                        if ((this.soleUserCompDirty & 0x3B1) == 0) {
                            this.renderBin.rmUpdateList.add(this);
                        }
                        this.soleUserCompDirty |= 0x10;
                    }
                    break block68;
                } else if (!this.definingColoringAttributes.equivalent(coloringAttributes)) {
                    return false;
                }
                break block68;
            }
            if (coloringAttributes != null) {
                return false;
            }
        }
        if (this.definingTransparency == null) {
            if (transparency == null) return true;
            return false;
        }
        if (this.definingTransparency.changedFrequent != 0 || transparency != null && transparency.changedFrequent != 0) {
            if (this.definingTransparency != transparency) return false;
            if (this.definingTransparency.compChanged == 0) return true;
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= 0x20;
            return true;
        }
        if (this.definingTransparency.equivalent(transparency)) return true;
        return false;
    }

    public void updateRemoveRenderAtoms() {
        RenderAtomListInfo rinfo;
        if (this.numRenderAtoms == 0 && this.removeRAs == null && this.addRAs == null) {
            this.textureBin.removeRenderMolecule(this);
            return;
        }
        while (this.removeRAs != null) {
            RenderAtom r = this.removeRAs;
            r.removed = null;
            --this.numRenderAtoms;
            for (int index = 0; index < r.rListInfo.length; ++index) {
                GeometryRetained geo;
                rinfo = r.rListInfo[index];
                if (rinfo.geometry() == null) continue;
                if ((rinfo.groupType & RenderAtom.PRIMARY) != 0) {
                    this.primaryChanged = true;
                    if (rinfo.prev == null) {
                        this.primaryRenderAtomList = rinfo.next;
                        if (rinfo.next != null) {
                            rinfo.next.prev = null;
                        }
                    } else {
                        rinfo.prev.next = rinfo.next;
                        if (rinfo.next != null) {
                            rinfo.next.prev = rinfo.prev;
                        }
                    }
                    if (this.primaryMoleculeType == 8) {
                        geo = (RasterRetained)rinfo.geometry();
                        this.renderBin.removeGeometryFromLockList(geo);
                        if (((RasterRetained)geo).image != null) {
                            this.renderBin.removeNodeComponent(((RasterRetained)geo).image);
                        }
                    } else if ((rinfo.groupType & RenderAtom.SEPARATE_DLIST_PER_RINFO) != 0 && !rinfo.renderAtom.inRenderBin()) {
                        this.renderBin.removeDlistPerRinfo.add(rinfo);
                    }
                } else if ((rinfo.groupType & RenderAtom.SEPARATE_DLIST_PER_GEO) != 0) {
                    if (rinfo.prev == null) {
                        this.separateDlistRenderAtomList = rinfo.next;
                        if (rinfo.next != null) {
                            rinfo.next.prev = null;
                        }
                    } else {
                        rinfo.prev.next = rinfo.next;
                        if (rinfo.next != null) {
                            rinfo.next.prev = rinfo.prev;
                        }
                    }
                    this.renderBin.removeGeometryDlist(rinfo);
                } else {
                    if (rinfo.prev == null) {
                        this.vertexArrayRenderAtomList = rinfo.next;
                        if (rinfo.next != null) {
                            rinfo.next.prev = null;
                        }
                    } else {
                        rinfo.prev.next = rinfo.next;
                        if (rinfo.next != null) {
                            rinfo.next.prev = rinfo.prev;
                        }
                    }
                    if (!((geo = (GeometryArrayRetained)rinfo.geometry()) instanceof IndexedGeometryArrayRetained) || (geo.vertexFormat & 0x200) != 0) {
                        this.renderBin.removeGeometryFromLockList(geo);
                    }
                }
                rinfo.prev = null;
                rinfo.next = null;
            }
            this.removeRAs = this.removeRAs.nextRemove;
            r.nextRemove = null;
            r.prevRemove = null;
            if (r.isOriented()) {
                this.renderBin.orientedRAs.remove(r);
            }
            if (this.textureBin.environmentSet.lightBin.geometryBackground != null || this.isOpaqueOrInOG || this.renderBin.transpSortMode != 1) continue;
            this.renderBin.removeTransparentObject(r);
        }
        if (this.addRAs == null) {
            if (this.numRenderAtoms == 0) {
                if ((this.primaryMoleculeType & DLIST_MOLECULE) != 0) {
                    this.renderBin.addDisplayListResourceFreeList(this);
                    this.vwcBounds.set(null);
                    this.displayListId = 0;
                    this.displayListIdObj = null;
                }
                if (this.locale != this.renderBin.locale) {
                    this.localeLocalToVworld = null;
                }
                this.textureBin.removeRenderMolecule(this);
            } else if ((this.primaryMoleculeType & DLIST_MOLECULE) != 0 && this.primaryChanged) {
                this.renderBin.addDirtyRenderMolecule(this);
                this.vwcBounds.set(null);
                rinfo = this.primaryRenderAtomList;
                while (rinfo != null) {
                    this.vwcBounds.combine(rinfo.renderAtom.localeVwcBounds);
                    rinfo = rinfo.next;
                }
                this.primaryChanged = false;
            }
        }
        this.numEditingRenderAtoms = this.numRenderAtoms;
    }

    @Override
    public void updateObject() {
        if (this.textureBin == null) {
            return;
        }
        if (this.addRAs != null) {
            RenderAtomListInfo r;
            while (this.addRAs != null) {
                int k;
                ++this.numRenderAtoms;
                RenderAtom renderAtom = this.addRAs;
                renderAtom.renderMolecule = this;
                renderAtom.added = null;
                for (int j = 0; j < renderAtom.rListInfo.length; ++j) {
                    r = renderAtom.rListInfo[j];
                    if (r.geometry() == null) continue;
                    r.groupType = this.evalRinfoGroupType(r);
                    if ((r.groupType & RenderAtom.PRIMARY) != 0) {
                        if ((r.groupType & RenderAtom.DLIST) != 0 && this.primaryRenderMethod == null) {
                            this.primaryMoleculeType = DLIST_MOLECULE;
                            this.renderBin.renderMoleculeList.add(this);
                            if (this.vwcBounds == null) {
                                this.vwcBounds = new BoundingBox((Bounds)null);
                            }
                            this.primaryRenderMethod = VirtualUniverse.mc.getDisplayListRenderMethod();
                            if (this.displayListId == 0) {
                                this.displayListIdObj = VirtualUniverse.mc.getDisplayListId();
                                this.displayListId = this.displayListIdObj;
                            }
                        } else if ((r.groupType & RenderAtom.SEPARATE_DLIST_PER_RINFO) != 0 && this.primaryRenderMethod == null) {
                            this.primaryMoleculeType = SEPARATE_DLIST_PER_RINFO_MOLECULE;
                            this.renderBin.renderMoleculeList.add(this);
                            this.primaryRenderMethod = VirtualUniverse.mc.getDisplayListRenderMethod();
                        }
                        this.primaryChanged = true;
                        if (this.primaryRenderAtomList == null) {
                            this.primaryRenderAtomList = r;
                        } else {
                            r.next = this.primaryRenderAtomList;
                            this.primaryRenderAtomList.prev = r;
                            this.primaryRenderAtomList = r;
                        }
                        if (this.primaryMoleculeType == SEPARATE_DLIST_PER_RINFO_MOLECULE) {
                            if (r.renderAtom.dlistIds == null) {
                                r.renderAtom.dlistIds = new int[r.renderAtom.rListInfo.length];
                                for (k = 0; k < r.renderAtom.dlistIds.length; ++k) {
                                    r.renderAtom.dlistIds[k] = -1;
                                }
                            }
                            if (r.renderAtom.dlistIds[r.index] == -1) {
                                r.renderAtom.dlistIds[r.index] = VirtualUniverse.mc.getDisplayListId();
                                this.renderBin.addDlistPerRinfo.add(r);
                            }
                        }
                        if (this.primaryMoleculeType != 8) continue;
                        RasterRetained geo = (RasterRetained)r.geometry();
                        this.renderBin.addGeometryToLockList(geo);
                        if (geo.image == null) continue;
                        this.renderBin.addNodeComponent(geo.image);
                        continue;
                    }
                    if ((r.groupType & RenderAtom.SEPARATE_DLIST_PER_GEO) != 0) {
                        if (this.separateDlistRenderAtomList == null) {
                            this.separateDlistRenderAtomList = r;
                        } else {
                            r.next = this.separateDlistRenderAtomList;
                            this.separateDlistRenderAtomList.prev = r;
                            this.separateDlistRenderAtomList = r;
                        }
                        ((GeometryArrayRetained)r.geometry()).assignDlistId();
                        this.renderBin.addGeometryDlist(r);
                        continue;
                    }
                    if (this.secondaryRenderMethod == null) {
                        this.secondaryRenderMethod = this.cachedVertexArrayRenderMethod;
                    }
                    if (this.vertexArrayRenderAtomList == null) {
                        this.vertexArrayRenderAtomList = r;
                    } else {
                        r.next = this.vertexArrayRenderAtomList;
                        this.vertexArrayRenderAtomList.prev = r;
                        this.vertexArrayRenderAtomList = r;
                    }
                    GeometryArrayRetained geo = (GeometryArrayRetained)r.geometry();
                    if (geo instanceof IndexedGeometryArrayRetained && (geo.vertexFormat & 0x200) == 0) continue;
                    this.renderBin.addGeometryToLockList(geo);
                    if ((geo.vertexFormat & 0x80) == 0 || geo.c4fAllocated != 0 || (geo.vertexFormat & 4) == 0 || !this.useAlpha) continue;
                    this.renderBin.addDirtyReferenceGeometry(geo);
                }
                this.addRAs = this.addRAs.nextAdd;
                renderAtom.nextAdd = null;
                renderAtom.prevAdd = null;
                if (renderAtom.isOriented()) {
                    this.renderBin.orientedRAs.add(renderAtom);
                }
                if (this.isOpaqueOrInOG || this.textureBin.environmentSet.lightBin.geometryBackground != null || this.renderBin.transpSortMode != 1) continue;
                GeometryRetained geo = null;
                for (k = 0; geo == null && k < renderAtom.rListInfo.length; ++k) {
                    geo = renderAtom.rListInfo[k].geometry();
                }
                if (geo == null) continue;
                if (renderAtom.parentTInfo != null && renderAtom.parentTInfo[k - 1] != null) {
                    this.renderBin.updateTransparentInfo(renderAtom);
                    continue;
                }
                this.renderBin.addTransparentObject(renderAtom);
            }
            if ((this.primaryMoleculeType & DLIST_MOLECULE) != 0 && this.primaryChanged) {
                this.renderBin.addDirtyRenderMolecule(this);
                this.vwcBounds.set(null);
                r = this.primaryRenderAtomList;
                while (r != null) {
                    this.vwcBounds.combine(r.renderAtom.localeVwcBounds);
                    r = r.next;
                }
                this.primaryChanged = false;
            }
            if ((this.onUpdateList & LOCALE_CHANGED) != 0) {
                this.handleLocaleChange();
            }
            if (this.locale != this.renderBin.locale) {
                this.translate();
            }
        } else {
            if (this.renderBin.localeChanged) {
                this.handleLocaleChange();
            }
            if (this.locale != this.renderBin.locale) {
                this.translate();
            }
            if ((this.onUpdateList & UPDATE_BACKGROUND_TRANSFORM) != 0) {
                int i = this.localToVworldIndex[0];
                this.localeLocalToVworld[i].getRotation(this.infLocalToVworld[i]);
            }
            if ((this.onUpdateList & BOUNDS_RECOMPUTE_UPDATE) != 0) {
                this.vwcBounds.set(null);
                RenderAtomListInfo r = this.primaryRenderAtomList;
                while (r != null) {
                    this.vwcBounds.combine(r.renderAtom.localeVwcBounds);
                    r = r.next;
                }
            }
        }
        this.onUpdateList &= IN_DIRTY_RENDERMOLECULE_LIST;
        this.numEditingRenderAtoms = this.numRenderAtoms;
    }

    boolean canBeInDisplayList(GeometryRetained geo, GeometryAtom ga) {
        if (ga.source.sourceNode instanceof MorphRetained) {
            return false;
        }
        return geo.canBeInDisplayList(ga.alphaEditable);
    }

    final boolean geoNotAltered(GeometryArrayRetained geo) {
        return (geo.vertexFormat & 4) == 0 || !this.textureBin.attributeBin.ignoreVertexColors && !this.useAlpha;
    }

    int evalRinfoGroupType(RenderAtomListInfo r) {
        int groupType = 0;
        GeometryRetained geo = r.geometry();
        if (geo == null) {
            return groupType;
        }
        groupType = (this.primaryMoleculeType & (COMPRESSED_MOLECULE | RASTER_MOLECULE | TEXT3D_MOLECULE | ORIENTEDSHAPE3D_MOLECULE)) != 0 ? RenderAtom.OTHER : (this.canBeInDisplayList(geo, r.renderAtom.geometryAtom) ? (!((GeometryArrayRetained)geo).isShared || r.renderAtom.geometryAtom.source.staticTransform != null ? (this.primaryMoleculeType == SEPARATE_DLIST_PER_RINFO_MOLECULE ? RenderAtom.SEPARATE_DLIST_PER_RINFO : (this.isOpaqueOrInOG || this.renderBin.transpSortMode == 0 ? RenderAtom.DLIST : RenderAtom.SEPARATE_DLIST_PER_RINFO)) : (this.geoNotAltered((GeometryArrayRetained)r.geometry()) ? RenderAtom.SEPARATE_DLIST_PER_GEO : RenderAtom.VARRAY)) : RenderAtom.VARRAY);
        return groupType;
    }

    void addRenderAtom(RenderAtom renderAtom, RenderBin rb) {
        int i;
        TransparencyAttributesRetained trAttrs;
        ColoringAttributesRetained coAttrs;
        MaterialRetained mat;
        renderAtom.envSet = this.textureBin.environmentSet;
        renderAtom.renderMolecule = this;
        renderAtom.dirtyMask &= ~RenderAtom.NEED_SEPARATE_LOCALE_VWC_BOUNDS;
        AppearanceRetained raApp = renderAtom.geometryAtom.source.appearance;
        MaterialRetained materialRetained = mat = raApp == null ? null : raApp.material;
        if (!this.soleUser && this.material != mat) {
            this.material = this.definingMaterial;
        }
        if ((this.geometryType & 4) != 0) {
            PolygonAttributesRetained pgAttrs;
            PolygonAttributesRetained polygonAttributesRetained = pgAttrs = raApp == null ? null : raApp.polygonAttributes;
            if (!this.soleUser && this.polygonAttributes != pgAttrs) {
                this.polygonAttributes = this.definingPolygonAttributes;
            }
        }
        if ((this.geometryType & 2) != 0) {
            LineAttributesRetained lnAttrs;
            LineAttributesRetained lineAttributesRetained = lnAttrs = raApp == null ? null : raApp.lineAttributes;
            if (!this.soleUser && this.lineAttributes != lnAttrs) {
                this.lineAttributes = this.definingLineAttributes;
            }
        }
        if ((this.geometryType & 1) != 0) {
            PointAttributesRetained pnAttrs;
            PointAttributesRetained pointAttributesRetained = pnAttrs = raApp == null ? null : raApp.pointAttributes;
            if (!this.soleUser && this.pointAttributes != pnAttrs) {
                this.pointAttributes = this.definingPointAttributes;
            }
        }
        ColoringAttributesRetained coloringAttributesRetained = coAttrs = raApp == null ? null : raApp.coloringAttributes;
        if (!this.soleUser && this.coloringAttributes != coAttrs) {
            this.coloringAttributes = this.definingColoringAttributes;
        }
        TransparencyAttributesRetained transparencyAttributesRetained = trAttrs = raApp == null ? null : raApp.transparencyAttributes;
        if (!this.soleUser && this.transparency != trAttrs) {
            this.transparency = this.definingTransparency;
        }
        if (!renderAtom.inRenderBin()) {
            for (i = 0; i < renderAtom.rListInfo.length; ++i) {
                int groupType;
                if (renderAtom.rListInfo[i].geometry() == null || (groupType = this.evalRinfoGroupType(renderAtom.rListInfo[i])) == RenderAtom.DLIST) continue;
                renderAtom.dirtyMask |= RenderAtom.NEED_SEPARATE_LOCALE_VWC_BOUNDS;
            }
        }
        if (renderAtom.removed == this) {
            if (renderAtom == this.removeRAs) {
                this.removeRAs = renderAtom.nextRemove;
                if (this.removeRAs != null) {
                    this.removeRAs.prevRemove = null;
                }
                renderAtom.nextRemove = null;
                renderAtom.prevRemove = null;
            } else {
                renderAtom.prevRemove.nextRemove = renderAtom.nextRemove;
                if (renderAtom.nextRemove != null) {
                    renderAtom.nextRemove.prevRemove = renderAtom.prevRemove;
                }
                renderAtom.nextRemove = null;
                renderAtom.prevRemove = null;
            }
            renderAtom.removed = null;
            for (i = 0; i < renderAtom.rListInfo.length; ++i) {
                if (renderAtom.rListInfo[i].geometry() == null) continue;
                if ((renderAtom.rListInfo[i].groupType & RenderAtom.DLIST) != 0) {
                    this.renderBin.addDirtyRenderMolecule(this);
                    continue;
                }
                if ((renderAtom.rListInfo[i].groupType & RenderAtom.SEPARATE_DLIST_PER_RINFO) != 0) {
                    this.renderBin.addDlistPerRinfo.add(renderAtom.rListInfo[i]);
                    continue;
                }
                if ((renderAtom.rListInfo[i].groupType & RenderAtom.SEPARATE_DLIST_PER_GEO) == 0) continue;
                this.renderBin.addGeometryDlist(renderAtom.rListInfo[i]);
            }
            if (this.removeRAs == null) {
                rb.removeRenderAtomInRMList.remove(this);
            }
        } else {
            if (this.addRAs == null) {
                this.addRAs = renderAtom;
                renderAtom.nextAdd = null;
                renderAtom.prevAdd = null;
            } else {
                renderAtom.nextAdd = this.addRAs;
                renderAtom.prevAdd = null;
                this.addRAs.prevAdd = renderAtom;
                this.addRAs = renderAtom;
            }
            renderAtom.added = this;
            if (this.onUpdateList == 0) {
                rb.objUpdateList.add(this);
            }
            this.onUpdateList |= NEW_RENDERATOMS_UPDATE;
        }
        if (this.renderBin.localeChanged && !this.doInfinite) {
            if (this.onUpdateList == 0) {
                rb.objUpdateList.add(this);
            }
            this.onUpdateList |= LOCALE_CHANGED;
        }
        if (this.numEditingRenderAtoms == 0) {
            this.textureBin.incrActiveRenderMolecule();
        }
        ++this.numEditingRenderAtoms;
    }

    void removeRenderAtom(RenderAtom r) {
        r.renderMolecule = null;
        if (r.added == this) {
            if (r == this.addRAs) {
                this.addRAs = r.nextAdd;
                if (this.addRAs != null) {
                    this.addRAs.prevAdd = null;
                }
                r.nextAdd = null;
                r.prevAdd = null;
            } else {
                r.prevAdd.nextAdd = r.nextAdd;
                if (r.nextAdd != null) {
                    r.nextAdd.prevAdd = r.prevAdd;
                }
                r.nextAdd = null;
                r.prevAdd = null;
            }
            r.added = null;
            r.envSet = null;
        } else {
            if (this.removeRAs == null) {
                this.removeRAs = r;
                r.nextRemove = null;
                r.prevRemove = null;
            } else {
                r.nextRemove = this.removeRAs;
                r.prevRemove = null;
                this.removeRAs.prevRemove = r;
                this.removeRAs = r;
            }
            r.removed = this;
        }
        if (!this.renderBin.removeRenderAtomInRMList.contains(this)) {
            this.renderBin.removeRenderAtomInRMList.add(this);
        }
        --this.numEditingRenderAtoms;
        if (this.numEditingRenderAtoms == 0) {
            this.textureBin.decrActiveRenderMolecule();
        }
    }

    void recalcBounds() {
        if (this.primaryRenderMethod == VirtualUniverse.mc.getDisplayListRenderMethod()) {
            this.vwcBounds.set(null);
            RenderAtomListInfo ra = this.primaryRenderAtomList;
            while (ra != null) {
                this.vwcBounds.combine(ra.renderAtom.localeVwcBounds);
                ra = ra.next;
            }
        }
    }

    void evalAlphaUsage(RenderingAttributesRetained renderAttrs, TextureUnitStateRetained[] texUnits) {
        boolean textureBlend = false;
        boolean alphaBlend = TransparencyAttributesRetained.useAlpha(this.definingTransparency);
        if (texUnits != null) {
            for (int i = 0; !textureBlend && i < texUnits.length; ++i) {
                if (texUnits[i] == null || texUnits[i].texAttrs == null) continue;
                textureBlend = textureBlend || texUnits[i].texAttrs.textureMode == 4;
            }
        }
        boolean alphaTest = renderAttrs != null && renderAttrs.alphaTestFunction != 0;
        boolean oldUseAlpha = this.useAlpha;
        boolean bl = this.useAlpha = alphaBlend || alphaTest || textureBlend;
        if (!oldUseAlpha && this.useAlpha) {
            GeometryArrayRetained geo = null;
            if (this.vertexArrayRenderAtomList != null) {
                geo = (GeometryArrayRetained)this.vertexArrayRenderAtomList.geometry();
            }
            if (!(geo == null || geo instanceof IndexedGeometryArrayRetained && (geo.vertexFormat & 0x200) == 0)) {
                this.renderBin.addGeometryToLockList(geo);
                if ((geo.vertexFormat & 0x80) != 0 && geo.c4fAllocated == 0 && (geo.vertexFormat & 4) != 0 && this.useAlpha) {
                    this.renderBin.addDirtyReferenceGeometry(geo);
                }
            }
        }
    }

    final boolean isSwitchOn() {
        if (this.primaryRenderAtomList != null) {
            return this.primaryRenderAtomList.renderAtom.geometryAtom.source.switchState.lastSwitchOn;
        }
        if (this.vertexArrayRenderAtomList != null) {
            return this.vertexArrayRenderAtomList.renderAtom.geometryAtom.source.switchState.lastSwitchOn;
        }
        if (this.separateDlistRenderAtomList != null) {
            return this.separateDlistRenderAtomList.renderAtom.geometryAtom.source.switchState.lastSwitchOn;
        }
        return false;
    }

    boolean render(Canvas3D cv, int pass, int dirtyBits) {
        assert (pass < 0);
        boolean isVisible = this.isSwitchOn();
        if (!isVisible) {
            return false;
        }
        isVisible = false;
        cv.setStateToUpdate(4, this);
        boolean modeSupportDL = true;
        boolean bl = this.isNonUniformScale = !this.trans[this.localToVworldIndex[0]].isCongruent();
        if (pass != -2 || this.texCoordSetMapLen > cv.maxTexCoordSets) {
            modeSupportDL = false;
        }
        if ((this.primaryMoleculeType & (TEXT3D_MOLECULE | ORIENTEDSHAPE3D_MOLECULE)) == 0) {
            if (this.primaryRenderAtomList != null) {
                if (this.primaryRenderMethod != VirtualUniverse.mc.getDisplayListRenderMethod() || modeSupportDL) {
                    if (this.primaryMoleculeType != SEPARATE_DLIST_PER_RINFO_MOLECULE) {
                        if (this.primaryRenderMethod.render(this, cv, this.primaryRenderAtomList, dirtyBits)) {
                            isVisible = true;
                        }
                    } else if (this.renderBin.dlistRenderMethod.renderSeparateDlistPerRinfo(this, cv, this.primaryRenderAtomList, dirtyBits)) {
                        isVisible = true;
                    }
                } else if (this.cachedVertexArrayRenderMethod.render(this, cv, this.primaryRenderAtomList, dirtyBits)) {
                    isVisible = true;
                }
            }
        } else if (this.primaryRenderAtomList != null && this.primaryRenderMethod.render(this, cv, this.primaryRenderAtomList, dirtyBits)) {
            isVisible = true;
        }
        if (this.separateDlistRenderAtomList != null) {
            if (modeSupportDL) {
                if (this.renderBin.dlistRenderMethod.renderSeparateDlists(this, cv, this.separateDlistRenderAtomList, dirtyBits)) {
                    isVisible = true;
                }
            } else if (this.cachedVertexArrayRenderMethod.render(this, cv, this.separateDlistRenderAtomList, dirtyBits)) {
                isVisible = true;
            }
        }
        if (this.vertexArrayRenderAtomList != null && this.cachedVertexArrayRenderMethod.render(this, cv, this.vertexArrayRenderAtomList, dirtyBits)) {
            isVisible = true;
        }
        return isVisible;
    }

    void updateAttributes(Canvas3D cv, int dirtyBits) {
        Transform3D modelMatrix;
        boolean setTransparency = false;
        int bitMask = this.geometryType | 8 | 0x20 | 0x10;
        if ((cv.canvasDirty & bitMask) != 0) {
            if ((this.geometryType & 4) != 0) {
                if (this.definingPolygonAttributes == null) {
                    cv.resetPolygonAttributes(cv.ctx);
                } else {
                    this.definingPolygonAttributes.updateNative(cv.ctx);
                }
                cv.polygonAttributes = this.polygonAttributes;
            }
            if ((this.geometryType & 2) != 0) {
                if (this.definingLineAttributes == null) {
                    cv.resetLineAttributes(cv.ctx);
                } else {
                    this.definingLineAttributes.updateNative(cv.ctx);
                }
                cv.lineAttributes = this.lineAttributes;
            }
            if ((this.geometryType & 1) != 0) {
                if (this.definingPointAttributes == null) {
                    cv.resetPointAttributes(cv.ctx);
                } else {
                    this.definingPointAttributes.updateNative(cv.ctx);
                }
                cv.pointAttributes = this.pointAttributes;
            }
            if (this.definingTransparency == null) {
                cv.resetTransparency(cv.ctx, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
            } else {
                this.definingTransparency.updateNative(cv.ctx, this.alpha, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
            }
            cv.transparency = this.transparency;
            if (this.definingMaterial == null) {
                cv.updateMaterial(cv.ctx, this.red, this.green, this.blue, this.alpha);
            } else {
                this.definingMaterial.updateNative(cv.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
            }
            cv.material = this.material;
            cv.enableLighting = this.enableLighting;
            if (this.definingColoringAttributes == null) {
                cv.resetColoringAttributes(cv.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
            } else {
                this.definingColoringAttributes.updateNative(cv.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
            }
            cv.coloringAttributes = this.coloringAttributes;
            cv.appHandle = this.appHandle;
        } else if (cv.renderMolecule != this && dirtyBits != 0) {
            if (cv.appHandle != this.appHandle) {
                if (cv.transparency != this.transparency && (dirtyBits & 0x20) != 0) {
                    setTransparency = true;
                    if (this.definingTransparency == null) {
                        cv.resetTransparency(cv.ctx, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
                    } else {
                        this.definingTransparency.updateNative(cv.ctx, this.alpha, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
                    }
                    cv.transparency = this.transparency;
                }
                if (setTransparency || cv.enableLighting != this.enableLighting || cv.material != this.material && (dirtyBits & 1) != 0) {
                    if (this.definingMaterial == null) {
                        cv.updateMaterial(cv.ctx, this.red, this.green, this.blue, this.alpha);
                    } else {
                        this.definingMaterial.updateNative(cv.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                    }
                    cv.material = this.material;
                    cv.enableLighting = this.enableLighting;
                }
                if ((this.geometryType & 4) != 0 && cv.polygonAttributes != this.polygonAttributes && (dirtyBits & 0x80) != 0) {
                    if (this.definingPolygonAttributes == null) {
                        cv.resetPolygonAttributes(cv.ctx);
                    } else {
                        this.definingPolygonAttributes.updateNative(cv.ctx);
                    }
                    cv.polygonAttributes = this.polygonAttributes;
                }
                if ((this.geometryType & 2) != 0 && cv.lineAttributes != this.lineAttributes && (dirtyBits & 0x100) != 0) {
                    if (this.definingLineAttributes == null) {
                        cv.resetLineAttributes(cv.ctx);
                    } else {
                        this.definingLineAttributes.updateNative(cv.ctx);
                    }
                    cv.lineAttributes = this.lineAttributes;
                }
                if ((this.geometryType & 1) != 0 && cv.pointAttributes != this.pointAttributes && (dirtyBits & 0x200) != 0) {
                    if (this.definingPointAttributes == null) {
                        cv.resetPointAttributes(cv.ctx);
                    } else {
                        this.definingPointAttributes.updateNative(cv.ctx);
                    }
                    cv.pointAttributes = this.pointAttributes;
                }
                cv.appHandle = this.appHandle;
            }
            if (setTransparency || (dirtyBits & 0x10) != 0) {
                if (this.definingColoringAttributes == null) {
                    cv.resetColoringAttributes(cv.ctx, this.red, this.green, this.blue, this.alpha, this.enableLighting);
                } else {
                    this.definingColoringAttributes.updateNative(cv.ctx, this.dRed, this.dBlue, this.dGreen, this.alpha, this.enableLighting);
                }
                cv.coloringAttributes = this.coloringAttributes;
            }
        }
        if ((this.primaryMoleculeType & (TEXT3D_MOLECULE | ORIENTEDSHAPE3D_MOLECULE)) == 0 && cv.modelMatrix != (modelMatrix = this.trans[this.localToVworldIndex[0]])) {
            cv.setModelViewMatrix(cv.ctx, cv.vworldToEc.mat, modelMatrix);
        }
        cv.canvasDirty &= ~bitMask;
        cv.renderMolecule = this;
    }

    void transparentSortRender(Canvas3D cv, int pass, TransparentRenderingInfo tinfo) {
        assert (pass < 0);
        Transform3D modelMatrix = this.trans[this.localToVworldIndex[0]];
        cv.setStateToUpdate(4, this);
        boolean modeSupportDL = true;
        if (pass != -2 || this.texCoordSetMapLen > cv.maxTexCoordSets) {
            modeSupportDL = false;
        }
        if ((tinfo.rInfo.groupType & RenderAtom.SEPARATE_DLIST_PER_RINFO) != 0) {
            RenderAtomListInfo save = tinfo.rInfo.next;
            tinfo.rInfo.next = null;
            if (modeSupportDL) {
                this.renderBin.dlistRenderMethod.renderSeparateDlistPerRinfo(this, cv, tinfo.rInfo, 945);
            } else {
                this.cachedVertexArrayRenderMethod.render(this, cv, tinfo.rInfo, 945);
            }
            tinfo.rInfo.next = save;
        } else if ((tinfo.rInfo.groupType & (RenderAtom.VARRAY | RenderAtom.DLIST)) != 0) {
            RenderAtomListInfo save = tinfo.rInfo.next;
            tinfo.rInfo.next = null;
            this.cachedVertexArrayRenderMethod.render(this, cv, tinfo.rInfo, 945);
            tinfo.rInfo.next = save;
        } else if ((tinfo.rInfo.groupType & RenderAtom.SEPARATE_DLIST_PER_GEO) != 0) {
            RenderAtomListInfo save = tinfo.rInfo.next;
            tinfo.rInfo.next = null;
            if (modeSupportDL) {
                this.renderBin.dlistRenderMethod.renderSeparateDlists(this, cv, tinfo.rInfo, 945);
            } else {
                this.cachedVertexArrayRenderMethod.render(this, cv, tinfo.rInfo, 945);
            }
            tinfo.rInfo.next = save;
        } else {
            RenderAtomListInfo save = tinfo.rInfo.next;
            this.primaryRenderMethod.render(this, cv, this.primaryRenderAtomList, 945);
            tinfo.rInfo.next = save;
        }
    }

    void updateTransparencyAttributes(Canvas3D cv) {
        if (this.definingTransparency == null) {
            cv.resetTransparency(cv.ctx, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
        } else {
            this.definingTransparency.updateNative(cv.ctx, this.alpha, this.geometryType, this.polygonMode, this.lineAA, this.pointAA);
        }
    }

    void updateDisplayList(Canvas3D cv) {
        if (this.primaryRenderAtomList != null) {
            ((DisplayListRenderMethod)this.primaryRenderMethod).buildDisplayList(this, cv);
        }
    }

    void releaseAllPrimaryDisplayListID() {
        if (this.primaryRenderAtomList != null) {
            if (this.primaryMoleculeType == SEPARATE_DLIST_PER_RINFO_MOLECULE) {
                RenderAtomListInfo ra = this.primaryRenderAtomList;
                while (ra != null) {
                    int id = ra.renderAtom.dlistIds[ra.index];
                    if (id > 0) {
                        VirtualUniverse.mc.freeDisplayListId(new Integer(id));
                        ra.renderAtom.dlistIds[ra.index] = -1;
                    }
                    ra = ra.next;
                }
            } else if (this.primaryMoleculeType == DLIST_MOLECULE && this.displayListIdObj != null) {
                VirtualUniverse.mc.freeDisplayListId(this.displayListIdObj);
                this.displayListIdObj = null;
                this.displayListId = -1;
            }
        }
    }

    void releaseAllPrimaryDisplayListResources(Canvas3D cv, Context ctx) {
        if (this.primaryRenderAtomList != null) {
            if (this.primaryMoleculeType == SEPARATE_DLIST_PER_RINFO_MOLECULE) {
                RenderAtomListInfo ra = this.primaryRenderAtomList;
                while (ra != null) {
                    int id = ra.renderAtom.dlistIds[ra.index];
                    if (id > 0) {
                        Canvas3D.freeDisplayList(ctx, id);
                    }
                    ra = ra.next;
                }
            } else if (this.primaryMoleculeType == DLIST_MOLECULE && this.displayListId > 0) {
                Canvas3D.freeDisplayList(ctx, this.displayListId);
            }
        }
    }

    void updateAllPrimaryDisplayLists(Canvas3D cv) {
        if (this.primaryRenderAtomList != null) {
            if (this.primaryMoleculeType == SEPARATE_DLIST_PER_RINFO_MOLECULE) {
                RenderAtomListInfo ra = this.primaryRenderAtomList;
                while (ra != null) {
                    this.renderBin.dlistRenderMethod.buildDlistPerRinfo(ra, this, cv);
                    ra = ra.next;
                }
            } else if (this.primaryMoleculeType == DLIST_MOLECULE) {
                ((DisplayListRenderMethod)this.primaryRenderMethod).buildDisplayList(this, cv);
            }
        }
    }

    void checkEquivalenceWithBothNeighbors(int dirtyBits) {
        this.dirtyAttrsAcrossRms = 945;
        if (this.prev != null) {
            this.checkEquivalenceWithLeftNeighbor(this.prev, dirtyBits);
        }
        if (this.next != null) {
            this.next.checkEquivalenceWithLeftNeighbor(this, dirtyBits);
        }
    }

    boolean reloadColor(RenderMolecule rm) {
        return (rm.vertexFormat & 4) != 0 && ((rm.vertexFormat & 4) == 0 || (this.vertexFormat & 4) == 0);
    }

    void checkEquivalenceWithLeftNeighbor(RenderMolecule rm, int dirtyBits) {
        boolean reload_color = this.reloadColor(rm);
        this.dirtyAttrsAcrossRms = 945;
        int materialColoringDirty = 49;
        int transparencyDirty = 928;
        if ((this.dirtyAttrsAcrossRms & 0x80) != 0 && rm.geometryType == this.geometryType && (rm.polygonAttributes == this.polygonAttributes || rm.definingPolygonAttributes != null && rm.definingPolygonAttributes.equivalent(this.definingPolygonAttributes))) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFF7F;
        }
        if ((this.dirtyAttrsAcrossRms & 0x200) != 0 && rm.geometryType == this.geometryType && (rm.pointAttributes == this.pointAttributes || rm.definingPointAttributes != null && rm.definingPointAttributes.equivalent(this.definingPointAttributes))) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFDFF;
        }
        if ((this.dirtyAttrsAcrossRms & 0x100) != 0 && rm.geometryType == this.geometryType && (rm.lineAttributes == this.lineAttributes || rm.definingLineAttributes != null && rm.definingLineAttributes.equivalent(this.definingLineAttributes))) {
            this.dirtyAttrsAcrossRms &= 0xFFFFFEFF;
        }
        if ((this.dirtyAttrsAcrossRms & materialColoringDirty) != 0) {
            this.dirtyAttrsAcrossRms = this.materialEquivalent(rm, reload_color) ? (this.dirtyAttrsAcrossRms &= 0xFFFFFFFE) : (this.dirtyAttrsAcrossRms |= 1);
        }
        if ((this.dirtyAttrsAcrossRms & materialColoringDirty) != 0) {
            this.dirtyAttrsAcrossRms = this.coloringEquivalent(rm, reload_color) ? (this.dirtyAttrsAcrossRms &= 0xFFFFFFEF) : (this.dirtyAttrsAcrossRms |= 0x10);
        }
        if ((this.dirtyAttrsAcrossRms & transparencyDirty) != 0) {
            this.dirtyAttrsAcrossRms = this.transparencyEquivalent(rm) ? (this.dirtyAttrsAcrossRms &= 0xFFFFFFDF) : (this.dirtyAttrsAcrossRms |= 0x20);
        }
    }

    void translate() {
        int i = this.localToVworldIndex[0];
        this.localeLocalToVworld[i].mat[0] = this.localToVworld[i].mat[0];
        this.localeLocalToVworld[i].mat[1] = this.localToVworld[i].mat[1];
        this.localeLocalToVworld[i].mat[2] = this.localToVworld[i].mat[2];
        this.localeLocalToVworld[i].mat[3] = this.localToVworld[i].mat[3] + this.localeTranslation.x;
        this.localeLocalToVworld[i].mat[4] = this.localToVworld[i].mat[4];
        this.localeLocalToVworld[i].mat[5] = this.localToVworld[i].mat[5];
        this.localeLocalToVworld[i].mat[6] = this.localToVworld[i].mat[6];
        this.localeLocalToVworld[i].mat[7] = this.localToVworld[i].mat[7] + this.localeTranslation.y;
        this.localeLocalToVworld[i].mat[8] = this.localToVworld[i].mat[8];
        this.localeLocalToVworld[i].mat[9] = this.localToVworld[i].mat[9];
        this.localeLocalToVworld[i].mat[10] = this.localToVworld[i].mat[10];
        this.localeLocalToVworld[i].mat[11] = this.localToVworld[i].mat[11] + this.localeTranslation.z;
        this.localeLocalToVworld[i].mat[12] = this.localToVworld[i].mat[12];
        this.localeLocalToVworld[i].mat[13] = this.localToVworld[i].mat[13];
        this.localeLocalToVworld[i].mat[14] = this.localToVworld[i].mat[14];
        this.localeLocalToVworld[i].mat[15] = this.localToVworld[i].mat[15];
    }

    boolean isOpaque() {
        if ((this.geometryType & 4) != 0) {
            if (this.definingPolygonAttributes != null) {
                if (this.definingPolygonAttributes.polygonMode == 0 && this.definingPointAttributes != null && this.definingPointAttributes.pointAntialiasing) {
                    return false;
                }
                if (this.definingPolygonAttributes.polygonMode == 1 && this.definingLineAttributes != null && this.definingLineAttributes.lineAntialiasing) {
                    return false;
                }
            }
        } else if ((this.geometryType & 1) != 0 ? this.definingPointAttributes != null && this.definingPointAttributes.pointAntialiasing : (this.geometryType & 2) != 0 && this.definingLineAttributes != null && this.definingLineAttributes.lineAntialiasing) {
            return false;
        }
        return !TransparencyAttributesRetained.useAlpha(this.definingTransparency);
    }

    boolean updateNodeComponent() {
        boolean cloned;
        if ((this.soleUserCompDirty & 1) != 0) {
            if (this.soleUser) {
                cloned = this.definingMaterial != null && this.definingMaterial != this.material;
                this.material = ((AppearanceRetained)this.appHandle).material;
                if (this.material == null) {
                    this.definingMaterial = null;
                } else if (this.material.changedFrequent != 0) {
                    this.definingMaterial = this.material;
                } else if (cloned) {
                    this.definingMaterial.set(this.material);
                } else {
                    this.definingMaterial = (MaterialRetained)this.material.clone();
                }
            }
            this.evalMaterialCachedState();
        }
        if ((this.soleUserCompDirty & 0x100) != 0) {
            if (this.soleUser) {
                cloned = this.definingLineAttributes != null && this.definingLineAttributes != this.lineAttributes;
                this.lineAttributes = ((AppearanceRetained)this.appHandle).lineAttributes;
                if (this.lineAttributes == null) {
                    this.lineAA = false;
                    this.definingLineAttributes = null;
                } else {
                    if (this.lineAttributes.changedFrequent != 0) {
                        this.definingLineAttributes = this.lineAttributes;
                    } else if (cloned) {
                        this.definingLineAttributes.set(this.lineAttributes);
                    } else {
                        this.definingLineAttributes = (LineAttributesRetained)this.lineAttributes.clone();
                    }
                    this.lineAA = this.definingLineAttributes.lineAntialiasing;
                }
            } else {
                this.lineAA = this.definingLineAttributes.lineAntialiasing;
            }
        }
        if ((this.soleUserCompDirty & 0x200) != 0) {
            if (this.soleUser) {
                cloned = this.definingPointAttributes != null && this.definingPointAttributes != this.pointAttributes;
                this.pointAttributes = ((AppearanceRetained)this.appHandle).pointAttributes;
                if (this.pointAttributes == null) {
                    this.pointAA = false;
                    this.definingPointAttributes = null;
                } else {
                    if (this.pointAttributes.changedFrequent != 0) {
                        this.definingPointAttributes = this.pointAttributes;
                    } else if (cloned) {
                        this.definingPointAttributes.set(this.pointAttributes);
                    } else {
                        this.definingPointAttributes = (PointAttributesRetained)this.pointAttributes.clone();
                    }
                    this.pointAA = this.definingPointAttributes.pointAntialiasing;
                }
            } else {
                this.pointAA = this.definingPointAttributes.pointAntialiasing;
            }
        }
        if ((this.soleUserCompDirty & 0x80) != 0) {
            if (this.soleUser) {
                cloned = this.definingPolygonAttributes != null && this.definingPolygonAttributes != this.polygonAttributes;
                this.polygonAttributes = ((AppearanceRetained)this.appHandle).polygonAttributes;
                if (this.polygonAttributes == null) {
                    this.polygonMode = 2;
                    this.definingPolygonAttributes = null;
                } else {
                    if (this.polygonAttributes.changedFrequent != 0) {
                        this.definingPolygonAttributes = this.polygonAttributes;
                    } else if (cloned) {
                        this.definingPolygonAttributes.set(this.polygonAttributes);
                    } else {
                        this.definingPolygonAttributes = (PolygonAttributesRetained)this.polygonAttributes.clone();
                    }
                    this.polygonMode = this.definingPolygonAttributes.polygonMode;
                }
            } else {
                this.polygonMode = this.definingPolygonAttributes.polygonMode;
            }
            if (this.polygonMode == 1) {
                this.geometryType |= 2;
            } else if (this.polygonMode == 0) {
                this.geometryType |= 1;
            }
        }
        if ((this.soleUserCompDirty & 0x20) != 0) {
            if (this.soleUser) {
                cloned = this.definingTransparency != null && this.definingTransparency != this.transparency;
                this.transparency = ((AppearanceRetained)this.appHandle).transparencyAttributes;
                if (this.transparency == null) {
                    this.alpha = 1.0f;
                    this.definingTransparency = null;
                } else {
                    if (this.transparency.changedFrequent != 0) {
                        this.definingTransparency = this.transparency;
                    } else if (cloned) {
                        this.definingTransparency.set(this.transparency);
                    } else {
                        this.definingTransparency = (TransparencyAttributesRetained)this.transparency.clone();
                    }
                    this.alpha = 1.0f - this.definingTransparency.transparency;
                }
            } else {
                this.alpha = 1.0f - this.definingTransparency.transparency;
            }
        }
        if ((this.soleUserCompDirty & 0x10) != 0) {
            if (this.soleUser) {
                cloned = this.definingColoringAttributes != null && this.definingColoringAttributes != this.coloringAttributes;
                this.coloringAttributes = ((AppearanceRetained)this.appHandle).coloringAttributes;
                if (this.coloringAttributes == null) {
                    this.definingColoringAttributes = null;
                    this.red = 1.0f;
                    this.green = 1.0f;
                    this.blue = 1.0f;
                } else {
                    if (this.coloringAttributes.changedFrequent != 0) {
                        this.definingColoringAttributes = this.coloringAttributes;
                    } else if (cloned) {
                        this.definingColoringAttributes.set(this.coloringAttributes);
                    } else {
                        this.definingColoringAttributes = (ColoringAttributesRetained)this.coloringAttributes.clone();
                    }
                    this.red = this.definingColoringAttributes.color.x;
                    this.green = this.definingColoringAttributes.color.y;
                    this.blue = this.definingColoringAttributes.color.z;
                }
            } else {
                this.red = this.definingColoringAttributes.color.x;
                this.green = this.definingColoringAttributes.color.y;
                this.blue = this.definingColoringAttributes.color.z;
            }
        }
        boolean newVal = this.isOpaque() || this.inOrderedGroup;
        return this.isOpaqueOrInOG != newVal;
    }

    void addRemoveTransparentObject(RenderBin renderBin, boolean add) {
        this.addRemoveTransparentObject(renderBin, add, this.primaryRenderAtomList);
        this.addRemoveTransparentObject(renderBin, add, this.separateDlistRenderAtomList);
        this.addRemoveTransparentObject(renderBin, add, this.vertexArrayRenderAtomList);
    }

    private void addRemoveTransparentObject(RenderBin renderBin, boolean add, RenderAtomListInfo rinfo) {
        while (rinfo != null) {
            if (add) {
                renderBin.addTransparentObject(rinfo.renderAtom);
            } else {
                renderBin.removeTransparentObject(rinfo.renderAtom);
            }
            rinfo = rinfo.next;
        }
    }

    void evalMaterialCachedState() {
        if (this.definingMaterial == null) {
            this.enableLighting = false;
            this.definingMaterial = null;
            this.dRed = 1.0f;
            this.dGreen = 1.0f;
            this.dBlue = 1.0f;
        } else if ((this.geometryType & 8) != 0) {
            this.enableLighting = false;
            this.dRed = 1.0f;
            this.dGreen = 1.0f;
            this.dBlue = 1.0f;
        } else {
            this.enableLighting = this.normalPresent ? this.definingMaterial.lightingEnable : false;
            this.dRed = this.definingMaterial.diffuseColor.x;
            this.dGreen = this.definingMaterial.diffuseColor.y;
            this.dBlue = this.definingMaterial.diffuseColor.z;
        }
    }

    void markBitsAsDirty(int leftBits, int rightBits) {
        if (this.prev != null) {
            this.checkEquivalenceWithLeftNeighbor(this.prev, leftBits);
            this.prev.soleUserCompDirty &= 0xFFFFFC4E;
        } else if (this.prevMap != null) {
            this.checkEquivalenceWithLeftNeighbor(this.prevMap, leftBits);
            this.prevMap.soleUserCompDirty &= 0xFFFFFC4E;
        }
        if (this.next != null) {
            if ((this.next.soleUserCompDirty & 0x3B1) == 0) {
                this.next.checkEquivalenceWithLeftNeighbor(this, rightBits);
            } else {
                this.next.soleUserCompDirty = rightBits;
            }
        } else if (this.nextMap != null) {
            if ((this.nextMap.soleUserCompDirty & 0x3B1) == 0) {
                this.nextMap.checkEquivalenceWithLeftNeighbor(this, rightBits);
            } else {
                this.nextMap.soleUserCompDirty = rightBits;
            }
        }
    }

    void handleMaterialEquivalence() {
        RenderMolecule curPrevRm = null;
        RenderMolecule curNextRm = null;
        boolean found = false;
        int leftBits = 945;
        int rightBits = 945;
        if (this.prev != null) {
            curPrevRm = this.prev.prev;
            if (this.materialEquivalent(this.prev, this.reloadColor(this.prev))) {
                found = true;
                leftBits = (this.soleUserCompDirty | this.prev.soleUserCompDirty) & 0x3B1 & 0xFFFFFFFE;
                rightBits = this.soleUserCompDirty & 0x3B1;
                this.markBitsAsDirty(leftBits, rightBits);
            }
        } else if (!found && this.next != null) {
            curNextRm = this.next.next;
            if (this.materialEquivalent(this.next, this.reloadColor(this.next))) {
                found = true;
                int bits = 0;
                if (this.prev != null) {
                    bits = this.prev.soleUserCompDirty;
                } else if (this.prevMap != null) {
                    bits = this.prevMap.soleUserCompDirty;
                }
                leftBits = (this.soleUserCompDirty | bits) & 0x3B1;
                rightBits = this.soleUserCompDirty & 0x3B1 & 0xFFFFFFFE;
                this.markBitsAsDirty(leftBits, rightBits);
            }
        }
        while (!found && curPrevRm != null) {
            if (this.materialEquivalent(curPrevRm, this.reloadColor(curPrevRm))) {
                found = true;
                this.prev.next = this.next;
                this.prev.nextMap = this.nextMap;
                if (this.next != null) {
                    this.next.prev = this.prev;
                    if ((this.next.soleUserCompDirty & 0x3B1) == 0) {
                        this.next.checkEquivalenceWithLeftNeighbor(this.prev, 945);
                    } else {
                        this.next.soleUserCompDirty = 945;
                    }
                } else if (this.nextMap != null) {
                    this.nextMap.prevMap = this.prev;
                    if ((this.nextMap.soleUserCompDirty & 0x3B1) == 0) {
                        this.nextMap.checkEquivalenceWithLeftNeighbor(this.prev, 945);
                    } else {
                        this.nextMap.soleUserCompDirty |= 0x3B1;
                    }
                }
                this.next = curPrevRm.next;
                this.nextMap = curPrevRm.nextMap;
                curPrevRm.nextMap = null;
                if (this.next != null) {
                    this.next.prev = this;
                } else if (this.nextMap != null) {
                    this.nextMap.prevMap = this;
                }
                this.prev = curPrevRm;
                curPrevRm.next = this;
                leftBits = 944;
                this.markBitsAsDirty(leftBits, 945);
            }
            curPrevRm = curPrevRm.prev;
        }
        while (!found && curNextRm != null) {
            if (this.materialEquivalent(curNextRm, this.reloadColor(curNextRm))) {
                found = true;
                this.next.prev = this.prev;
                this.next.prevMap = this.prevMap;
                if (this.prev != null) {
                    this.prev.next = this.next;
                    if ((this.next.soleUserCompDirty & 0x3B1) == 0) {
                        this.next.checkEquivalenceWithLeftNeighbor(this.prev, 945);
                    } else {
                        this.next.soleUserCompDirty = 945;
                    }
                } else if (this.prevMap != null) {
                    this.prevMap.nextMap = this.next;
                    if ((this.next.soleUserCompDirty & 0x3B1) == 0) {
                        this.next.checkEquivalenceWithLeftNeighbor(this.prevMap, 945);
                    } else {
                        this.next.soleUserCompDirty = 945;
                    }
                }
                this.prev = curNextRm.prev;
                this.prevMap = curNextRm.prevMap;
                curNextRm.prevMap = null;
                if (curNextRm.prev != null) {
                    curNextRm.prev.next = this;
                } else if (this.prevMap != null) {
                    this.prevMap.nextMap = this;
                }
                this.next = curNextRm;
                curNextRm.prev = this;
                rightBits = 944;
                this.markBitsAsDirty(945, rightBits);
            }
            curNextRm = curNextRm.next;
        }
        if (!found) {
            if (this.prev != null) {
                leftBits = (this.soleUserCompDirty | this.prev.soleUserCompDirty) & 0x3B1;
            } else if (this.prevMap != null) {
                leftBits = (this.soleUserCompDirty | this.prevMap.soleUserCompDirty) & 0x3B1;
            }
            if (this.next != null) {
                rightBits = (this.soleUserCompDirty | this.next.soleUserCompDirty) & 0x3B1;
            } else if (this.nextMap != null) {
                rightBits = (this.soleUserCompDirty | this.nextMap.soleUserCompDirty) & 0x3B1;
            }
            this.markBitsAsDirty(leftBits, rightBits);
        }
    }

    void reEvaluateEquivalence() {
        if ((this.soleUserCompDirty & 0x3B1) != 0) {
            if ((this.soleUserCompDirty & 1) != 0) {
                this.handleMaterialEquivalence();
            } else {
                int dirtyBits = this.soleUserCompDirty & 0x3B1;
                if (this.prev != null) {
                    this.checkEquivalenceWithLeftNeighbor(this.prev, (dirtyBits | this.prev.soleUserCompDirty) & 0x3B1);
                    this.prev.soleUserCompDirty = 0;
                } else if (this.prevMap != null) {
                    this.checkEquivalenceWithLeftNeighbor(this.prevMap, (dirtyBits | this.prevMap.soleUserCompDirty) & 0x3B1);
                    this.prevMap.soleUserCompDirty = 0;
                }
                if (this.next != null) {
                    this.next.checkEquivalenceWithLeftNeighbor(this, (this.next.soleUserCompDirty | this.soleUserCompDirty) & 0x3B1);
                } else if (this.nextMap != null) {
                    this.nextMap.checkEquivalenceWithLeftNeighbor(this, (this.nextMap.soleUserCompDirty | this.soleUserCompDirty) & 0x3B1);
                }
            }
        }
        this.soleUserCompDirty &= 0xFFFFFC4E;
    }

    boolean materialEquivalent(RenderMolecule rm, boolean reloadColor) {
        return !reloadColor && (this.material == rm.material || rm.definingMaterial != null && rm.definingMaterial.equivalent(this.definingMaterial)) && rm.alpha == this.alpha && this.enableLighting == rm.enableLighting && (this.enableLighting || !this.enableLighting && rm.red == this.red && rm.green == this.green && rm.blue == this.blue);
    }

    boolean coloringEquivalent(RenderMolecule rm, boolean reload_color) {
        return !reload_color && (rm.coloringAttributes == this.coloringAttributes || rm.definingColoringAttributes != null && rm.definingColoringAttributes.equivalent(this.definingColoringAttributes)) && (!this.enableLighting || this.enableLighting && this.dRed == rm.dRed && this.dBlue == rm.dBlue && this.dGreen == rm.dGreen);
    }

    boolean transparencyEquivalent(RenderMolecule rm) {
        return rm.transparency == this.transparency || rm.definingTransparency != null && rm.definingTransparency.equivalent(this.definingTransparency) && rm.definingTransparency.transparencyMode < 3 && this.blendOn() == rm.blendOn();
    }

    boolean blendOn() {
        if (this.lineAA && ((this.geometryType & 2) != 0 || this.polygonMode == 1)) {
            return true;
        }
        return this.pointAA && ((this.geometryType & 1) != 0 || this.polygonMode == 0);
    }

    @Override
    VirtualUniverse getVirtualUniverse() {
        return null;
    }

    void handleLocaleChange() {
        if (this.locale == this.renderBin.locale) {
            if (this.localToVworld != this.localeLocalToVworld) {
                this.localeLocalToVworld = this.localToVworld;
                this.localeTranslation = null;
            }
        } else if (this.localeTranslation == null) {
            this.localeLocalToVworld = new Transform3D[2];
            this.localeLocalToVworld[0] = new Transform3D();
            this.localeLocalToVworld[1] = new Transform3D();
            this.localeTranslation = new Vector3d();
            this.locale.hiRes.difference(this.renderBin.locale.hiRes, this.localeTranslation);
            this.translate();
            int i = this.localToVworldIndex[1];
            this.localeLocalToVworld[i].mat[0] = this.localToVworld[i].mat[0];
            this.localeLocalToVworld[i].mat[1] = this.localToVworld[i].mat[1];
            this.localeLocalToVworld[i].mat[2] = this.localToVworld[i].mat[2];
            this.localeLocalToVworld[i].mat[3] = this.localToVworld[i].mat[3] + this.localeTranslation.x;
            this.localeLocalToVworld[i].mat[4] = this.localToVworld[i].mat[4];
            this.localeLocalToVworld[i].mat[5] = this.localToVworld[i].mat[5];
            this.localeLocalToVworld[i].mat[6] = this.localToVworld[i].mat[6];
            this.localeLocalToVworld[i].mat[7] = this.localToVworld[i].mat[7] + this.localeTranslation.y;
            this.localeLocalToVworld[i].mat[8] = this.localToVworld[i].mat[8];
            this.localeLocalToVworld[i].mat[9] = this.localToVworld[i].mat[9];
            this.localeLocalToVworld[i].mat[10] = this.localToVworld[i].mat[10];
            this.localeLocalToVworld[i].mat[11] = this.localToVworld[i].mat[11] + this.localeTranslation.z;
            this.localeLocalToVworld[i].mat[12] = this.localToVworld[i].mat[12];
            this.localeLocalToVworld[i].mat[13] = this.localToVworld[i].mat[13];
            this.localeLocalToVworld[i].mat[14] = this.localToVworld[i].mat[14];
            this.localeLocalToVworld[i].mat[15] = this.localToVworld[i].mat[15];
        }
        this.trans = this.localeLocalToVworld;
    }

    @Override
    public void updateNodeComponentCheck() {
        if ((this.onUpdateList & ON_UPDATE_CHECK_LIST) == 0) {
            return;
        }
        this.onUpdateList &= ~ON_UPDATE_CHECK_LIST;
        NodeComponentRetained nc = (NodeComponentRetained)this.appHandle;
        if ((nc.compChanged & RM_COMPONENTS) != 0) {
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= nc.compChanged & RM_COMPONENTS;
        }
        if (this.definingPolygonAttributes != null && this.definingPolygonAttributes == this.polygonAttributes && this.definingPolygonAttributes.compChanged != 0) {
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= 0x80;
        }
        if (this.definingLineAttributes != null && this.definingLineAttributes == this.lineAttributes && this.definingLineAttributes.compChanged != 0) {
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= 0x100;
        }
        if (this.definingPointAttributes != null && this.definingPointAttributes.compChanged != 0) {
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= 0x200;
        }
        if (this.definingMaterial != null && this.definingMaterial == this.material && this.definingMaterial.compChanged != 0) {
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= 1;
        }
        if (this.definingColoringAttributes != null && this.definingColoringAttributes == this.coloringAttributes && this.definingColoringAttributes.compChanged != 0) {
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= 0x10;
        }
        if (this.definingTransparency != null && this.definingTransparency == this.transparency && this.definingTransparency.compChanged != 0) {
            if ((this.soleUserCompDirty & 0x3B1) == 0) {
                this.renderBin.rmUpdateList.add(this);
            }
            this.soleUserCompDirty |= 0x20;
        }
    }
}

