/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.BitSet;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.Group;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Node;
import org.scijava.java3d.SwitchRetained;

public class Switch
extends Group {
    public static final int ALLOW_SWITCH_READ = 17;
    public static final int ALLOW_SWITCH_WRITE = 18;
    public static final int CHILD_NONE = -1;
    public static final int CHILD_ALL = -2;
    public static final int CHILD_MASK = -3;
    private static final int[] readCapabilities = new int[]{17};

    public Switch() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Switch(int whichChild) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SwitchRetained)this.retained).setWhichChild(whichChild, true);
    }

    public Switch(int whichChild, BitSet childMask) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SwitchRetained)this.retained).setWhichChild(whichChild, true);
        ((SwitchRetained)this.retained).setChildMask(childMask);
    }

    @Override
    void createRetained() {
        this.retained = new SwitchRetained();
        this.retained.setSource(this);
    }

    public void setWhichChild(int child) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Switch0"));
        }
        ((SwitchRetained)this.retained).setWhichChild(child, false);
    }

    public int getWhichChild() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Switch1"));
        }
        return ((SwitchRetained)this.retained).getWhichChild();
    }

    public void setChildMask(BitSet childMask) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Switch2"));
        }
        ((SwitchRetained)this.retained).setChildMask(childMask);
    }

    public BitSet getChildMask() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Switch3"));
        }
        return ((SwitchRetained)this.retained).getChildMask();
    }

    public Node currentChild() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Switch4"));
        }
        return ((SwitchRetained)this.retained).currentChild();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Switch s = new Switch();
        s.duplicateNode(this, forceDuplicate);
        return s;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        SwitchRetained attr = (SwitchRetained)originalNode.retained;
        SwitchRetained rt = (SwitchRetained)this.retained;
        rt.setChildMask(attr.getChildMask());
        rt.setWhichChild(attr.getWhichChild(), true);
    }
}

