/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.loaders.lw3d.LwsBackground;
import com.sun.j3d.loaders.lw3d.LwsCamera;
import com.sun.j3d.loaders.lw3d.LwsFog;
import com.sun.j3d.loaders.lw3d.LwsLight;
import com.sun.j3d.loaders.lw3d.LwsObject;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Fog;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;

public class Lw3dLoader
extends TextfileParser
implements Loader {
    Vector objectList;
    Vector lightList;
    BranchGroup sceneGroupNode;
    Color3f ambientColor = new Color3f(0.0f, 0.0f, 0.0f);
    LwsCamera camera = null;
    LwsFog fog = null;
    LwsBackground background = null;
    int loadFlags = 0;
    int loadBehaviors = 0;
    Vector sceneBehaviors;
    SceneBase scene = null;
    String basePath = null;
    String internalBasePath = null;
    URL baseUrl = null;
    String internalBaseUrl = null;
    static final int FILE_TYPE_NONE = 0;
    static final int FILE_TYPE_URL = 1;
    static final int FILE_TYPE_FILENAME = 2;
    static final int FILE_TYPE_READER = 4;
    int fileType = 0;

    public Lw3dLoader() {
        this.objectList = new Vector();
        this.lightList = new Vector();
        this.debugPrinter.setValidOutput(0);
    }

    public Lw3dLoader(int flags) {
        this();
        this.loadFlags = flags;
        this.loadBehaviors = this.loadFlags & 8;
    }

    @Override
    public Scene load(URL url) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        InputStreamReader reader;
        this.fileType = 1;
        this.setInternalBaseUrl(url);
        try {
            reader = new InputStreamReader(new BufferedInputStream(url.openStream()));
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        Scene returnScene = this.load(reader);
        this.fileType = 0;
        return returnScene;
    }

    @Override
    public Scene load(String fileName) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.fileType = 2;
        this.setInternalBasePath(fileName);
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        Scene returnScene = this.load(reader);
        this.fileType = 0;
        return returnScene;
    }

    @Override
    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        if (this.fileType == 0) {
            this.fileType = 4;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        this.setupTokenizer(tokenizer);
        this.getAndCheckString(tokenizer, "LWSC");
        this.getNumber(tokenizer);
        this.getAndCheckString(tokenizer, "FirstFrame");
        int firstFrame = (int)this.getNumber(tokenizer);
        this.getAndCheckString(tokenizer, "LastFrame");
        int finalFrame = (int)this.getNumber(tokenizer);
        this.skipUntilString(tokenizer, "FramesPerSecond");
        double fps = this.getNumber(tokenizer);
        float totalTime = (float)(finalFrame - firstFrame) / (float)fps;
        boolean done = false;
        block6: while (!done) {
            int token;
            try {
                token = tokenizer.nextToken();
            }
            catch (IOException e) {
                throw new ParsingErrorException(e.getMessage());
            }
            switch (tokenizer.ttype) {
                case -1: {
                    done = true;
                    break;
                }
                case -3: {
                    this.debugOutputLn(2, "  String = " + tokenizer.sval);
                    if (tokenizer.sval.equals("AddNullObject")) {
                        LwsObject obj = new LwsObject(tokenizer, false, firstFrame, finalFrame, totalTime, this, this.debugPrinter.getValidOutput());
                        obj.createJava3dObject(null, this.loadBehaviors);
                        this.objectList.addElement(obj);
                        break;
                    }
                    if (tokenizer.sval.equals("LoadObject")) {
                        String filename = this.getString(tokenizer);
                        tokenizer.pushBack();
                        this.debugOutputLn(32, "loading " + filename + " at " + System.currentTimeMillis());
                        LwsObject obj = new LwsObject(tokenizer, true, firstFrame, finalFrame, totalTime, this, this.debugPrinter.getValidOutput());
                        this.debugOutputLn(32, "done loading at " + System.currentTimeMillis());
                        LwsObject cloneObject = null;
                        Enumeration e = this.objectList.elements();
                        while (e.hasMoreElements()) {
                            LwsObject tmpObj = (LwsObject)e.nextElement();
                            if (tmpObj.fileName == null || !tmpObj.fileName.equals(filename)) continue;
                            cloneObject = tmpObj;
                            break;
                        }
                        obj.createJava3dObject(cloneObject, this.loadBehaviors);
                        this.objectList.addElement(obj);
                        break;
                    }
                    if (tokenizer.sval.equals("AmbientColor")) {
                        this.ambientColor.x = (float)this.getNumber(tokenizer) / 255.0f;
                        this.ambientColor.y = (float)this.getNumber(tokenizer) / 255.0f;
                        this.ambientColor.z = (float)this.getNumber(tokenizer) / 255.0f;
                        break;
                    }
                    if (tokenizer.sval.equals("AmbIntensity")) {
                        float intensity = (float)this.getNumber(tokenizer);
                        this.ambientColor.x *= intensity;
                        this.ambientColor.y *= intensity;
                        this.ambientColor.z *= intensity;
                        break;
                    }
                    if (tokenizer.sval.equals("AddLight")) {
                        LwsLight light = new LwsLight(tokenizer, finalFrame, totalTime, this.debugPrinter.getValidOutput());
                        light.createJava3dObject(this.loadBehaviors);
                        this.lightList.addElement(light);
                        break;
                    }
                    if (tokenizer.sval.equals("ShowCamera")) {
                        this.camera = new LwsCamera(tokenizer, firstFrame, finalFrame, totalTime, this.debugPrinter.getValidOutput());
                        this.camera.createJava3dObject(this.loadBehaviors);
                        break;
                    }
                    if (tokenizer.sval.equals("FogType")) {
                        int fogType = (int)this.getNumber(tokenizer);
                        if (fogType == 0) continue block6;
                        this.fog = new LwsFog(tokenizer, this.debugPrinter.getValidOutput());
                        this.fog.createJava3dObject();
                        break;
                    }
                    if (!tokenizer.sval.equals("SolidBackdrop")) continue block6;
                    this.background = new LwsBackground(tokenizer, this.debugPrinter.getValidOutput());
                    this.background.createJava3dObject();
                    break;
                }
                default: {
                    this.debugOutputLn(2, "  Unknown ttype, token = " + tokenizer.ttype + ", " + token);
                }
            }
        }
        this.sceneGroupNode = new BranchGroup();
        this.sceneBehaviors = new Vector();
        this.parentObjects();
        this.constructScene();
        return this.scene;
    }

    void constructScene() {
        this.scene = new SceneBase();
        if ((this.loadFlags & 1) != 0) {
            this.addLights();
            this.addAmbient();
        }
        if ((this.loadFlags & 2) != 0) {
            this.addFog();
        }
        if ((this.loadFlags & 4) != 0) {
            this.addBackground();
        }
        if ((this.loadFlags & 0x10) != 0) {
            this.addCamera();
        }
        if (this.loadBehaviors != 0) {
            this.addBehaviors();
        }
        this.scene.setSceneGroup(this.sceneGroupNode);
        Enumeration e = this.objectList.elements();
        while (e.hasMoreElements()) {
            LwsObject obj = (LwsObject)e.nextElement();
            if (obj.fileName != null) {
                this.scene.addNamedObject(obj.fileName, obj.getObjectNode());
                continue;
            }
            if (obj.objName == null) continue;
            this.scene.addNamedObject(obj.objName, obj.getObjectNode());
        }
    }

    void setInternalBaseUrl(URL url) {
        StringTokenizer stok = new StringTokenizer(url.toString(), "\\/");
        int tocount = stok.countTokens() - 1;
        StringBuffer sb = new StringBuffer(80);
        for (int ji = 0; ji < tocount; ++ji) {
            String a = stok.nextToken();
            if (ji == 0 && !a.regionMatches(true, 0, "file:", 0, 5)) {
                sb.append(a);
                sb.append('/');
                sb.append('/');
                continue;
            }
            sb.append(a);
            sb.append('/');
        }
        this.internalBaseUrl = sb.toString();
    }

    void setInternalBasePath(String fileName) {
        StringTokenizer stok = new StringTokenizer(fileName, File.separator);
        int tocount = stok.countTokens() - 1;
        StringBuffer sb = new StringBuffer(80);
        if (fileName != null && fileName.startsWith(File.separator)) {
            sb.append(File.separator);
        }
        for (int ji = 0; ji < tocount; ++ji) {
            String a = stok.nextToken();
            sb.append(a);
            sb.append(File.separator);
        }
        this.internalBasePath = sb.toString();
    }

    String getInternalBasePath() {
        return this.internalBasePath;
    }

    String getInternalBaseUrl() {
        return this.internalBaseUrl;
    }

    int getFileType() {
        return this.fileType;
    }

    void parentObjects() {
        this.debugOutputLn(1, "parentObjects()");
        Enumeration e = this.objectList.elements();
        while (e.hasMoreElements()) {
            LwsObject obj = (LwsObject)e.nextElement();
            if (obj.getParent() != -1) {
                LwsObject parent = (LwsObject)this.objectList.elementAt(obj.getParent() - 1);
                parent.addChild(obj);
                this.debugOutputLn(2, "added child successfully");
            } else if (obj.getObjectNode() != null) {
                this.sceneGroupNode.addChild((Node)obj.getObjectNode());
            }
            if (this.loadBehaviors == 0 || obj.getObjectBehaviors().isEmpty()) continue;
            this.sceneBehaviors.addAll(obj.getObjectBehaviors());
        }
        this.debugOutputLn(8, "Done with parentObjects()");
    }

    @Override
    public void setBaseUrl(URL url) {
        this.baseUrl = url;
    }

    @Override
    public void setBasePath(String pathName) {
        this.basePath = pathName;
        if (this.basePath == null || this.basePath == "") {
            this.basePath = "." + File.separator;
        }
        this.basePath = this.basePath.replace('/', File.separatorChar);
        this.basePath = this.basePath.replace('\\', File.separatorChar);
        if (!this.basePath.endsWith(File.separator)) {
            this.basePath = this.basePath + File.separator;
        }
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setFlags(int flags) {
        this.loadFlags = flags;
    }

    @Override
    public int getFlags() {
        return this.loadFlags;
    }

    public TransformGroup getObject(String name) {
        this.debugOutputLn(1, "getObject()");
        int indexNumber = -1;
        int currentObjectCount = 0;
        String subobjectName = name;
        if (name.indexOf("[") != -1) {
            int bracketsIndex = name.indexOf("[");
            subobjectName = name.substring(0, bracketsIndex);
            String bracketsString = name.substring(bracketsIndex);
            int bracketEndIndex = bracketsString.indexOf("]");
            String indexString = bracketsString.substring(1, bracketEndIndex);
            indexNumber = new Integer(indexString);
        }
        Enumeration e = this.objectList.elements();
        while (e.hasMoreElements()) {
            LwsObject tempObj = (LwsObject)e.nextElement();
            this.debugOutputLn(2, "tempObj, file, objname = " + tempObj + tempObj.fileName + tempObj.objName);
            if ((tempObj.fileName == null || tempObj.fileName.indexOf(subobjectName) == -1) && (tempObj.objName == null || tempObj.objName.indexOf(subobjectName) == -1)) continue;
            if (indexNumber < 0 || indexNumber == currentObjectCount) {
                return tempObj.getObjectNode();
            }
            ++currentObjectCount;
        }
        this.debugOutputLn(2, " no luck - wanted " + name + " returning null");
        return null;
    }

    void setupTokenizer(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(160, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.commentChar(47);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(47, 47);
        tokenizer.wordChars(92, 92);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(38, 38);
        tokenizer.ordinaryChar(40);
        tokenizer.ordinaryChar(41);
        tokenizer.whitespaceChars(13, 13);
        tokenizer.wordChars(58, 58);
        tokenizer.wordChars(126, 126);
    }

    void addAmbient() {
        AmbientLight aLgt = new AmbientLight(this.ambientColor);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
        aLgt.setInfluencingBounds((Bounds)bounds);
        this.sceneGroupNode.addChild((Node)aLgt);
        aLgt.addScope((Group)this.sceneGroupNode);
        this.scene.addLightNode((Light)aLgt);
    }

    void addLights() {
        Enumeration e1 = this.lightList.elements();
        while (e1.hasMoreElements()) {
            this.debugOutputLn(8, "adding light to scene group");
            LwsLight light = (LwsLight)e1.nextElement();
            if (light.getObjectNode() != null) {
                light.getLight().addScope((Group)this.sceneGroupNode);
                if (light.getParent() != -1) {
                    LwsObject parent = (LwsObject)this.objectList.elementAt(light.getParent() - 1);
                    parent.addChild(light);
                } else {
                    this.sceneGroupNode.addChild((Node)light.getObjectNode());
                }
                if (this.loadBehaviors != 0 && !light.getObjectBehaviors().isEmpty()) {
                    this.sceneBehaviors.addAll(light.getObjectBehaviors());
                }
                this.scene.addLightNode(light.getLight());
                continue;
            }
            this.debugOutputLn(8, "light object null?");
        }
    }

    void addCamera() {
        if (this.camera != null) {
            if (this.camera.getParent() != -1) {
                this.debugOutputLn(2, "camera parent = " + this.camera.getParent());
                LwsObject parent = (LwsObject)this.objectList.elementAt(this.camera.getParent() - 1);
                parent.addChild(this.camera);
                this.debugOutputLn(2, "added child successfully");
            } else {
                this.sceneGroupNode.addChild((Node)this.camera.getObjectNode());
            }
            if (this.loadBehaviors != 0 && !this.camera.getObjectBehaviors().isEmpty()) {
                this.sceneBehaviors.addAll(this.camera.getObjectBehaviors());
            }
            this.scene.addViewGroup(this.camera.getObjectNode());
        }
    }

    void addFog() {
        Fog fogNode;
        if (this.fog != null && (fogNode = this.fog.getObjectNode()) != null) {
            this.sceneGroupNode.addChild((Node)fogNode);
            this.scene.addFogNode(fogNode);
        }
    }

    void addBehaviors() {
        if (!this.sceneBehaviors.isEmpty()) {
            Enumeration e = this.sceneBehaviors.elements();
            while (e.hasMoreElements()) {
                this.scene.addBehaviorNode((Behavior)e.nextElement());
            }
        }
    }

    void addBackground() {
        Background bgNode;
        if (this.background != null && (bgNode = this.background.getObjectNode()) != null) {
            this.sceneGroupNode.addChild((Node)bgNode);
            this.scene.addBackgroundNode(bgNode);
        }
    }
}

