/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import com.sun.j3d.utils.behaviors.sensor.SensorButtonListener;
import com.sun.j3d.utils.behaviors.sensor.SensorEvent;
import com.sun.j3d.utils.behaviors.sensor.SensorReadListener;
import com.sun.j3d.utils.timer.J3DTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;

public class SensorEventAgent {
    private long t0 = 0L;
    private Object source = null;
    private SensorEvent e = new SensorEvent();
    private List bindingsList = new ArrayList();
    private SensorBinding[] bindings = new SensorBinding[0];
    private boolean listsDirty = false;

    public SensorEventAgent(Object source) {
        this.source = source;
    }

    private SensorBinding getSensorBinding(Sensor sensor) {
        for (int i = 0; i < this.bindingsList.size(); ++i) {
            SensorBinding sb = (SensorBinding)this.bindingsList.get(i);
            if (sb.sensor != sensor) continue;
            return sb;
        }
        return null;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, int button, SensorButtonListener buttonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (button >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + button + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        SensorButtonListener[] listeners = new SensorButtonListener[sb.buttons.length];
        listeners[button] = buttonListener;
        SensorButtonBinding sbb = new SensorButtonBinding(listeners, true);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, SensorButtonListener buttonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        SensorButtonListener[] listeners = new SensorButtonListener[sb.buttons.length];
        for (int i = 0; i < sb.buttons.length; ++i) {
            listeners[i] = buttonListener;
        }
        SensorButtonBinding sbb = new SensorButtonBinding(listeners, true);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListeners(Sensor sensor, SensorButtonListener[] buttonListeners) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        if (sb.buttons.length != buttonListeners.length) {
            throw new IllegalArgumentException("\nbuttonListeners length " + buttonListeners.length + " must equal sensor button count " + sb.buttons.length);
        }
        SensorButtonBinding sbb = new SensorButtonBinding(buttonListeners, false);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public SensorButtonListener[] getSensorButtonListeners(Sensor sensor, int button) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (button >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + button + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return null;
        }
        ArrayList<SensorButtonListener> listeners = new ArrayList<SensorButtonListener>();
        for (int i = 0; i < sb.buttonBindingsList.size(); ++i) {
            SensorButtonBinding sbb = (SensorButtonBinding)sb.buttonBindingsList.get(i);
            if (sbb.listeners[button] == null) continue;
            listeners.add(sbb.listeners[button]);
        }
        if (listeners.size() == 0) {
            return null;
        }
        return listeners.toArray(new SensorButtonListener[listeners.size()]);
    }

    private void removeSensorButtonListener(SensorBinding sb, SensorButtonListener listener) {
        Iterator i = sb.buttonBindingsList.iterator();
        while (i.hasNext()) {
            int instanceCount = 0;
            SensorButtonBinding sbb = (SensorButtonBinding)i.next();
            for (int j = 0; j < sbb.listeners.length; ++j) {
                if (sbb.listeners[j] == listener) {
                    sbb.listeners[j] = null;
                    continue;
                }
                if (sbb.listeners[j] == null) continue;
                ++instanceCount;
            }
            if (instanceCount != 0) continue;
            i.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(Sensor sensor, SensorButtonListener listener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return;
        }
        this.removeSensorButtonListener(sb, listener);
        if (sb.buttonBindingsList.size() == 0 && sb.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(SensorButtonListener listener) {
        Iterator i = this.bindingsList.iterator();
        while (i.hasNext()) {
            SensorBinding sb = (SensorBinding)i.next();
            this.removeSensorButtonListener(sb, listener);
            if (sb.buttonBindingsList.size() != 0 || sb.readBindingsList.size() != 0) continue;
            i.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void addSensorReadListener(Sensor sensor, SensorReadListener readListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        sb.readBindingsList.add(readListener);
        this.listsDirty = true;
    }

    public SensorReadListener[] getSensorReadListeners(Sensor sensor) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return null;
        }
        if (sb.readBindingsList.size() == 0) {
            return null;
        }
        return sb.readBindingsList.toArray(new SensorReadListener[sb.readBindingsList.size()]);
    }

    private void removeSensorReadListener(SensorBinding sb, SensorReadListener listener) {
        Iterator i = sb.readBindingsList.iterator();
        while (i.hasNext()) {
            if ((SensorReadListener)i.next() != listener) continue;
            i.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(Sensor sensor, SensorReadListener listener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return;
        }
        this.removeSensorReadListener(sb, listener);
        if (sb.buttonBindingsList.size() == 0 && sb.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(SensorReadListener listener) {
        Iterator i = this.bindingsList.iterator();
        while (i.hasNext()) {
            SensorBinding sb = (SensorBinding)i.next();
            this.removeSensorReadListener(sb, listener);
            if (sb.buttonBindingsList.size() != 0 || sb.readBindingsList.size() != 0) continue;
            i.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorBinding(Sensor sensor) {
        Iterator i = this.bindingsList.iterator();
        while (i.hasNext()) {
            SensorBinding sb = (SensorBinding)i.next();
            if (sb.sensor != sensor) continue;
            i.remove();
            break;
        }
        this.listsDirty = true;
    }

    public Sensor[] getSensors() {
        if (this.bindingsList.size() == 0) {
            return null;
        }
        Sensor[] s = new Sensor[this.bindingsList.size()];
        for (int i = 0; i < this.bindingsList.size(); ++i) {
            s[i] = ((SensorBinding)this.bindingsList.get((int)i)).sensor;
        }
        return s;
    }

    private synchronized void updateArrays() {
        this.bindings = this.bindingsList.toArray(new SensorBinding[this.bindingsList.size()]);
        for (int i = 0; i < this.bindings.length; ++i) {
            this.bindings[i].updateArrays();
        }
    }

    public void dispatchEvents() {
        long t1 = this.t0;
        this.t0 = J3DTimer.getValue();
        if (this.listsDirty) {
            this.updateArrays();
            this.listsDirty = false;
        }
        for (int k = 0; k < this.bindings.length; ++k) {
            SensorBinding sb = this.bindings[k];
            Sensor s = sb.sensor;
            Transform3D read = sb.read;
            int[] buttons = sb.buttons;
            int dragButton = 0;
            boolean callReadListeners = true;
            boolean callDraggedListener = false;
            s.getRead(read);
            s.lastButtons(buttons);
            for (int j = 0; j < sb.buttonBindings.length; ++j) {
                SensorButtonBinding sbb = sb.buttonBindings[j];
                for (int i = 0; i < buttons.length; ++i) {
                    if (sbb.listeners[i] == null) continue;
                    if (sbb.prevButtons[i]) {
                        if (buttons[i] == 0) {
                            this.e.set(this.source, 2, s, read, buttons, i, this.t0, t1);
                            sbb.listeners[i].released(this.e);
                            sbb.prevButtons[i] = false;
                            --sbb.buttonsHandled;
                        } else {
                            callDraggedListener = true;
                            dragButton = i;
                        }
                        callReadListeners = false;
                        continue;
                    }
                    if (buttons[i] != 1 || sbb.buttonsHandled != 0 && !sbb.multiButton) continue;
                    this.e.set(this.source, 1, s, read, buttons, i, this.t0, t1);
                    sbb.listeners[i].pressed(this.e);
                    sbb.prevButtons[i] = true;
                    ++sbb.buttonsHandled;
                    callReadListeners = false;
                }
                if (!callDraggedListener) continue;
                this.e.set(this.source, 3, s, read, buttons, -1, this.t0, t1);
                sbb.listeners[dragButton].dragged(this.e);
            }
            if (!callReadListeners) continue;
            this.e.set(this.source, 4, s, read, buttons, -1, this.t0, t1);
            for (int r = 0; r < sb.readBindings.length; ++r) {
                sb.readBindings[r].read(this.e);
            }
        }
    }

    public String toString() {
        String s = "SensorEventAgent@" + Integer.toHexString(this.hashCode());
        s = s + "\nsensor bindings:\n\n";
        for (int i = 0; i < this.bindingsList.size(); ++i) {
            s = s + ((SensorBinding)this.bindingsList.get(i)).toString() + "\n";
        }
        return s;
    }

    private static class SensorButtonBinding {
        int buttonsHandled = 0;
        boolean[] prevButtons = null;
        boolean multiButton = false;
        SensorButtonListener[] listeners = null;

        SensorButtonBinding(SensorButtonListener[] listeners, boolean multiButtonEnable) {
            this.prevButtons = new boolean[listeners.length];
            this.listeners = new SensorButtonListener[listeners.length];
            for (int i = 0; i < listeners.length; ++i) {
                this.prevButtons[i] = false;
                this.listeners[i] = listeners[i];
            }
            this.multiButton = multiButtonEnable;
        }

        public String toString() {
            String s = new String();
            s = "  length " + this.listeners.length + ", mutual exclusion " + !this.multiButton + "\n";
            for (int i = 0; i < this.listeners.length; ++i) {
                s = s + "    " + (this.listeners[i] == null ? "null" : this.listeners[i].toString()) + "\n";
            }
            return s;
        }
    }

    private static class SensorBinding {
        Sensor sensor = null;
        int[] buttons = null;
        Transform3D read = null;
        List buttonBindingsList = new ArrayList();
        SensorButtonBinding[] buttonBindings = new SensorButtonBinding[0];
        List readBindingsList = new ArrayList();
        SensorReadListener[] readBindings = new SensorReadListener[0];

        SensorBinding(Sensor sensor) {
            this.sensor = sensor;
            this.buttons = new int[sensor.getSensorButtonCount()];
            this.read = new Transform3D();
        }

        void updateArrays() {
            this.buttonBindings = this.buttonBindingsList.toArray(new SensorButtonBinding[this.buttonBindingsList.size()]);
            this.readBindings = this.readBindingsList.toArray(new SensorReadListener[this.readBindingsList.size()]);
        }

        public String toString() {
            int i;
            String s = new String();
            s = "sensor " + this.sensor + "\nbutton listener arrays:\n";
            for (i = 0; i < this.buttonBindingsList.size(); ++i) {
                s = s + (SensorButtonBinding)this.buttonBindingsList.get(i);
            }
            s = s + "read listeners:\n";
            for (i = 0; i < this.readBindingsList.size(); ++i) {
                s = s + "  " + (SensorReadListener)this.readBindingsList.get(i) + "\n";
            }
            return s;
        }
    }
}

