/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.Bridge;
import com.sun.j3d.utils.geometry.Clean;
import com.sun.j3d.utils.geometry.Desperate;
import com.sun.j3d.utils.geometry.Distance;
import com.sun.j3d.utils.geometry.EarClip;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.HeapNode;
import com.sun.j3d.utils.geometry.Left;
import com.sun.j3d.utils.geometry.ListNode;
import com.sun.j3d.utils.geometry.NoHash;
import com.sun.j3d.utils.geometry.Orientation;
import com.sun.j3d.utils.geometry.PntNode;
import com.sun.j3d.utils.geometry.Project;
import com.sun.j3d.utils.geometry.Simple;
import com.sun.j3d.utils.geometry.Triangle;
import java.util.Random;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Triangulator {
    GeometryInfo gInfo = null;
    int[] faces = null;
    int[] loops = null;
    int[] chains = null;
    Point2f[] points = null;
    Triangle[] triangles = null;
    ListNode[] list = null;
    Random randomGen = null;
    int numPoints = 0;
    int maxNumPoints = 0;
    int numList = 0;
    int maxNumList = 0;
    int numLoops = 0;
    int maxNumLoops = 0;
    int numTriangles = 0;
    int maxNumTriangles = 0;
    int numFaces = 0;
    int numTexSets = 0;
    int firstNode = 0;
    int numChains = 0;
    int maxNumChains = 0;
    Point2f[] pUnsorted = null;
    int maxNumPUnsorted = 0;
    boolean noHashingEdges = false;
    boolean noHashingPnts = false;
    int loopMin;
    int loopMax;
    PntNode[] vtxList = null;
    int numVtxList = 0;
    int numReflex = 0;
    int reflexVertices;
    Distance[] distances = null;
    int maxNumDist = 0;
    Left[] leftMost = null;
    int maxNumLeftMost = 0;
    HeapNode[] heap = null;
    int numHeap = 0;
    int maxNumHeap = 0;
    int numZero = 0;
    int maxNumPolyArea = 0;
    double[] polyArea = null;
    int[] stripCounts = null;
    int[] vertexIndices = null;
    Point3f[] vertices = null;
    Object[] colors = null;
    Vector3f[] normals = null;
    boolean ccwLoop = true;
    boolean earsRandom = true;
    boolean earsSorted = true;
    int identCntr;
    double epsilon = 1.0E-12;
    static final double ZERO = 1.0E-8;
    static final int EARS_SEQUENCE = 0;
    static final int EARS_RANDOM = 1;
    static final int EARS_SORTED = 2;
    static final int INC_LIST_BK = 100;
    static final int INC_LOOP_BK = 20;
    static final int INC_TRI_BK = 50;
    static final int INC_POINT_BK = 100;
    static final int INC_DIST_BK = 50;
    private static final int DEBUG = 0;

    public Triangulator() {
        this.earsRandom = false;
        this.earsSorted = false;
    }

    public Triangulator(int earOrder) {
        switch (earOrder) {
            case 0: {
                this.earsRandom = false;
                this.earsSorted = false;
                break;
            }
            case 1: {
                this.randomGen = new Random();
                this.earsRandom = true;
                this.earsSorted = false;
                break;
            }
            case 2: {
                this.earsRandom = false;
                this.earsSorted = true;
                break;
            }
            default: {
                this.earsRandom = false;
                this.earsSorted = false;
            }
        }
    }

    public void triangulate(GeometryInfo gi) {
        int ind;
        int j;
        int i;
        int sIndex = 0;
        boolean reset = false;
        boolean troubles = false;
        boolean[] done = new boolean[1];
        boolean[] gotIt = new boolean[1];
        if (gi.getPrimitive() != 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("Triangulator0"));
        }
        gi.indexify();
        this.vertices = gi.getCoordinates();
        this.vertexIndices = (int[])(this.vertices != null ? gi.getCoordinateIndices() : null);
        this.colors = gi.getColors();
        this.normals = gi.getNormals();
        this.gInfo = gi;
        this.stripCounts = gi.getStripCounts();
        this.faces = gi.getContourCounts();
        if (this.faces == null) {
            if (this.stripCounts == null) {
                System.out.println("StripCounts is null! Don't know what to do.");
            }
            this.faces = new int[this.stripCounts.length];
            for (i = 0; i < this.stripCounts.length; ++i) {
                this.faces[i] = 1;
            }
        }
        this.numFaces = this.faces.length;
        this.numTexSets = this.gInfo.getTexCoordSetCount();
        this.maxNumLoops = 0;
        this.maxNumList = 0;
        this.maxNumPoints = 0;
        this.maxNumDist = 0;
        this.maxNumLeftMost = 0;
        this.maxNumPUnsorted = 0;
        for (i = 0; i < this.faces.length; ++i) {
            this.maxNumLoops += this.faces[i];
            j = 0;
            while (j < this.faces[i]) {
                this.maxNumList += this.stripCounts[sIndex] + 1;
                ++j;
                ++sIndex;
            }
        }
        this.maxNumList += 20;
        this.loops = new int[this.maxNumLoops];
        this.list = new ListNode[this.maxNumList];
        this.numVtxList = 0;
        this.numReflex = 0;
        this.numTriangles = 0;
        this.numChains = 0;
        this.numPoints = 0;
        this.numLoops = 0;
        this.numList = 0;
        sIndex = 0;
        int index = 0;
        for (i = 0; i < this.faces.length; ++i) {
            j = 0;
            while (j < this.faces[i]) {
                int currLoop = this.makeLoopHeader();
                int lastInd = this.loops[currLoop];
                for (int k = 0; k < this.stripCounts[sIndex]; ++k) {
                    this.list[this.numList] = new ListNode(this.vertexIndices[index]);
                    ++this.numList;
                    this.insertAfter(lastInd, ind);
                    this.list[ind].setCommonIndex(index);
                    lastInd = ind;
                    ++index;
                }
                this.deleteHook(currLoop);
                ++j;
                ++sIndex;
            }
        }
        this.maxNumTriangles = this.maxNumList / 2;
        this.triangles = new Triangle[this.maxNumTriangles];
        this.setEpsilon(1.0E-8);
        int i1 = 0;
        int i2 = 0;
        for (j = 0; j < this.numFaces; ++j) {
            this.ccwLoop = true;
            done[0] = false;
            i2 = i1 + this.faces[j];
            boolean proceed = this.faces[j] > 1 ? true : !Simple.simpleFace(this, this.loops[i1]);
            if (proceed) {
                for (int lpIndex = 0; lpIndex < this.faces[j]; ++lpIndex) {
                    this.preProcessList(i1 + lpIndex);
                }
                Project.projectFace(this, i1, i2);
                int removed = Clean.cleanPolyhedralFace(this, i1, i2);
                if (this.faces[j] == 1) {
                    Orientation.determineOrientation(this, this.loops[i1]);
                } else {
                    Orientation.adjustOrientation(this, i1, i2);
                }
                if (this.faces[j] > 1) {
                    NoHash.prepareNoHashEdges(this, i1, i2);
                } else {
                    this.noHashingEdges = false;
                    this.noHashingPnts = false;
                }
                for (i = i1; i < i2; ++i) {
                    EarClip.classifyAngles(this, this.loops[i]);
                }
                if (this.faces[j] > 1) {
                    Bridge.constructBridges(this, i1, i2);
                }
                this.resetPolyList(this.loops[i1]);
                NoHash.prepareNoHashPnts(this, i1);
                EarClip.classifyEars(this, this.loops[i1]);
                done[0] = false;
                while (!done[0]) {
                    if (!EarClip.clipEar(this, done)) {
                        if (reset) {
                            ind = this.getNode();
                            this.resetPolyList(ind);
                            this.loops[i1] = ind;
                            if (Desperate.desperate(this, ind, i1, done)) {
                                if (!Desperate.letsHope(this, ind)) {
                                    return;
                                }
                            } else {
                                reset = false;
                            }
                        } else {
                            troubles = true;
                            ind = this.getNode();
                            this.resetPolyList(ind);
                            EarClip.classifyEars(this, ind);
                            reset = true;
                        }
                    } else {
                        reset = false;
                    }
                    if (!done[0]) continue;
                    ind = this.getNextChain(gotIt);
                    if (!gotIt[0]) continue;
                    this.resetPolyList(ind);
                    this.loops[i1] = ind;
                    this.noHashingPnts = false;
                    NoHash.prepareNoHashPnts(this, i1);
                    EarClip.classifyEars(this, ind);
                    reset = false;
                    done[0] = false;
                }
            }
            i1 = i2;
        }
        this.writeTriangleToGeomInfo();
    }

    void printVtxList() {
        System.out.println("numReflex " + this.numReflex + " reflexVertices " + this.reflexVertices);
        for (int i = 0; i < this.numVtxList; ++i) {
            System.out.println(i + " pnt " + this.vtxList[i].pnt + ", next " + this.vtxList[i].next);
        }
    }

    void printListData() {
        for (int i = 0; i < this.numList; ++i) {
            System.out.println("list[" + i + "].index " + this.list[i].index + ", prev " + this.list[i].prev + ", next " + this.list[i].next + ", convex " + this.list[i].convex + ", vertexIndex " + this.list[i].vcntIndex);
        }
    }

    void preProcessList(int i1) {
        int tInd;
        this.resetPolyList(this.loops[i1]);
        int tInd1 = tInd = this.loops[i1];
        int tInd2 = this.list[tInd1].next;
        while (tInd2 != tInd) {
            if (this.list[tInd1].index == this.list[tInd2].index) {
                if (tInd2 == this.loops[i1]) {
                    this.loops[i1] = this.list[tInd2].next;
                }
                this.deleteLinks(tInd2);
            }
            tInd1 = this.list[tInd1].next;
            tInd2 = this.list[tInd1].next;
        }
    }

    void writeTriangleToGeomInfo() {
        int index;
        int i;
        this.gInfo.setPrimitive(1);
        this.gInfo.setContourCounts(null);
        this.gInfo.forgetOldPrim();
        this.gInfo.setStripCounts(null);
        int currIndex = 0;
        int[] newVertexIndices = new int[this.numTriangles * 3];
        for (i = 0; i < this.numTriangles; ++i) {
            index = this.list[this.triangles[i].v1].getCommonIndex();
            newVertexIndices[currIndex++] = this.vertexIndices[index];
            index = this.list[this.triangles[i].v2].getCommonIndex();
            newVertexIndices[currIndex++] = this.vertexIndices[index];
            index = this.list[this.triangles[i].v3].getCommonIndex();
            newVertexIndices[currIndex++] = this.vertexIndices[index];
        }
        this.gInfo.setCoordinateIndices(newVertexIndices);
        if (this.normals != null) {
            int[] oldNormalIndices = this.gInfo.getNormalIndices();
            int[] newNormalIndices = new int[this.numTriangles * 3];
            currIndex = 0;
            for (i = 0; i < this.numTriangles; ++i) {
                index = this.list[this.triangles[i].v1].getCommonIndex();
                newNormalIndices[currIndex++] = oldNormalIndices[index];
                index = this.list[this.triangles[i].v2].getCommonIndex();
                newNormalIndices[currIndex++] = oldNormalIndices[index];
                index = this.list[this.triangles[i].v3].getCommonIndex();
                newNormalIndices[currIndex++] = oldNormalIndices[index];
            }
            this.gInfo.setNormalIndices(newNormalIndices);
        }
        if (this.colors != null) {
            currIndex = 0;
            int[] oldColorIndices = this.gInfo.getColorIndices();
            int[] newColorIndices = new int[this.numTriangles * 3];
            for (i = 0; i < this.numTriangles; ++i) {
                index = this.list[this.triangles[i].v1].getCommonIndex();
                newColorIndices[currIndex++] = oldColorIndices[index];
                index = this.list[this.triangles[i].v2].getCommonIndex();
                newColorIndices[currIndex++] = oldColorIndices[index];
                index = this.list[this.triangles[i].v3].getCommonIndex();
                newColorIndices[currIndex++] = oldColorIndices[index];
            }
            this.gInfo.setColorIndices(newColorIndices);
        }
        for (int j = 0; j < this.numTexSets; ++j) {
            int[] newTextureIndices = new int[this.numTriangles * 3];
            int[] oldTextureIndices = this.gInfo.getTextureCoordinateIndices(j);
            currIndex = 0;
            for (i = 0; i < this.numTriangles; ++i) {
                index = this.list[this.triangles[i].v1].getCommonIndex();
                newTextureIndices[currIndex++] = oldTextureIndices[index];
                index = this.list[this.triangles[i].v2].getCommonIndex();
                newTextureIndices[currIndex++] = oldTextureIndices[index];
                index = this.list[this.triangles[i].v3].getCommonIndex();
                newTextureIndices[currIndex++] = oldTextureIndices[index];
            }
            this.gInfo.setTextureCoordinateIndices(j, newTextureIndices);
        }
    }

    void setEpsilon(double eps) {
        this.epsilon = eps;
    }

    boolean inPolyList(int ind) {
        return ind >= 0 && ind < this.numList && this.numList <= this.maxNumList;
    }

    void updateIndex(int ind, int index) {
        this.list[ind].index = index;
    }

    int getAngle(int ind) {
        return this.list[ind].convex;
    }

    void setAngle(int ind, int convex) {
        this.list[ind].convex = convex;
    }

    void resetPolyList(int ind) {
        this.firstNode = ind;
    }

    int getNode() {
        return this.firstNode;
    }

    boolean inLoopList(int loop) {
        return loop >= 0 && loop < this.numLoops && this.numLoops <= this.maxNumLoops;
    }

    void deleteHook(int currLoop) {
        if (!this.inLoopList(currLoop)) {
            System.out.println("Triangulator:deleteHook : Loop access out of range.");
        }
        int ind1 = this.loops[currLoop];
        int ind2 = this.list[ind1].next;
        if (this.inPolyList(ind1) && this.inPolyList(ind2)) {
            this.deleteLinks(ind1);
            this.loops[currLoop] = ind2;
        } else {
            System.out.println("Triangulator:deleteHook : List access out of range.");
        }
    }

    void deleteLinks(int ind) {
        if (this.inPolyList(ind) && this.inPolyList(this.list[ind].prev) && this.inPolyList(this.list[ind].next)) {
            if (this.firstNode == ind) {
                this.firstNode = this.list[ind].next;
            }
            this.list[this.list[ind].next].prev = this.list[ind].prev;
            this.list[this.list[ind].prev].next = this.list[ind].next;
            this.list[ind].prev = this.list[ind].next = ind;
        } else {
            System.out.println("Triangulator:deleteLinks : Access out of range.");
        }
    }

    void rotateLinks(int ind1, int ind2) {
        int ind0 = this.list[ind1].next;
        int ind3 = this.list[ind2].next;
        int ind = this.list[ind1].next;
        this.list[ind1].next = this.list[ind2].next;
        this.list[ind2].next = ind;
        this.list[ind0].prev = ind2;
        this.list[ind3].prev = ind1;
    }

    void storeChain(int ind) {
        if (this.numChains >= this.maxNumChains) {
            this.maxNumChains += 20;
            int[] old = this.chains;
            this.chains = new int[this.maxNumChains];
            if (old != null) {
                System.arraycopy(old, 0, this.chains, 0, old.length);
            }
        }
        this.chains[this.numChains] = ind;
        ++this.numChains;
    }

    int getNextChain(boolean[] done) {
        if (this.numChains > 0) {
            done[0] = true;
            --this.numChains;
            return this.chains[this.numChains];
        }
        done[0] = false;
        this.numChains = 0;
        return 0;
    }

    void splitSplice(int ind1, int ind2, int ind3, int ind4) {
        this.list[ind1].next = ind4;
        this.list[ind4].prev = ind1;
        this.list[ind2].prev = ind3;
        this.list[ind3].next = ind2;
    }

    int makeHook() {
        int ind = this.numList;
        if (this.numList >= this.maxNumList) {
            this.maxNumList += 100;
            ListNode[] old = this.list;
            this.list = new ListNode[this.maxNumList];
            System.arraycopy(old, 0, this.list, 0, old.length);
        }
        this.list[this.numList] = new ListNode(-1);
        this.list[this.numList].prev = ind;
        this.list[this.numList].next = ind;
        this.list[this.numList].index = -1;
        ++this.numList;
        return ind;
    }

    int makeLoopHeader() {
        int ind = this.makeHook();
        if (this.numLoops >= this.maxNumLoops) {
            this.maxNumLoops += 20;
            int[] old = this.loops;
            this.loops = new int[this.maxNumLoops];
            System.arraycopy(old, 0, this.loops, 0, old.length);
        }
        this.loops[this.numLoops] = ind;
        int i = this.numLoops++;
        return i;
    }

    int makeNode(int index) {
        if (this.numList >= this.maxNumList) {
            this.maxNumList += 100;
            ListNode[] old = this.list;
            this.list = new ListNode[this.maxNumList];
            System.arraycopy(old, 0, this.list, 0, old.length);
        }
        this.list[this.numList] = new ListNode(index);
        int ind = this.numList;
        this.list[this.numList].index = index;
        this.list[this.numList].prev = -1;
        this.list[this.numList].next = -1;
        ++this.numList;
        return ind;
    }

    void insertAfter(int ind1, int ind2) {
        if (this.inPolyList(ind1) && this.inPolyList(ind2)) {
            this.list[ind2].next = this.list[ind1].next;
            this.list[ind2].prev = ind1;
            this.list[ind1].next = ind2;
            int ind3 = this.list[ind2].next;
            if (this.inPolyList(ind3)) {
                this.list[ind3].prev = ind2;
            } else {
                System.out.println("Triangulator:deleteHook : List access out of range.");
            }
            return;
        }
        System.out.println("Triangulator:deleteHook : List access out of range.");
    }

    int fetchNextData(int ind1) {
        return this.list[ind1].next;
    }

    int fetchData(int ind1) {
        return this.list[ind1].index;
    }

    int fetchPrevData(int ind1) {
        return this.list[ind1].prev;
    }

    void swapLinks(int ind1) {
        int ind2 = this.list[ind1].next;
        this.list[ind1].next = this.list[ind1].prev;
        this.list[ind1].prev = ind2;
        int ind3 = ind2;
        while (ind2 != ind1) {
            ind3 = this.list[ind2].next;
            this.list[ind2].next = this.list[ind2].prev;
            this.list[ind2].prev = ind3;
            ind2 = ind3;
        }
    }

    void storeTriangle(int i, int j, int k) {
        if (this.numTriangles >= this.maxNumTriangles) {
            this.maxNumTriangles += 50;
            Triangle[] old = this.triangles;
            this.triangles = new Triangle[this.maxNumTriangles];
            if (old != null) {
                System.arraycopy(old, 0, this.triangles, 0, old.length);
            }
        }
        this.triangles[this.numTriangles] = this.ccwLoop ? new Triangle(i, j, k) : new Triangle(j, i, k);
        ++this.numTriangles;
    }

    void initPnts(int number) {
        if (this.maxNumPoints < number) {
            this.maxNumPoints = number;
            this.points = new Point2f[this.maxNumPoints];
        }
        for (int i = 0; i < number; ++i) {
            this.points[i] = new Point2f(0.0f, 0.0f);
        }
        this.numPoints = 0;
    }

    boolean inPointsList(int index) {
        return index >= 0 && index < this.numPoints && this.numPoints <= this.maxNumPoints;
    }

    int storePoint(double x, double y) {
        if (this.numPoints >= this.maxNumPoints) {
            this.maxNumPoints += 100;
            Point2f[] old = this.points;
            this.points = new Point2f[this.maxNumPoints];
            if (old != null) {
                System.arraycopy(old, 0, this.points, 0, old.length);
            }
        }
        this.points[this.numPoints] = new Point2f((float)x, (float)y);
        int i = this.numPoints++;
        return i;
    }
}

