/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.DepthComponentInt;
import javax.media.j3d.SceneGraphObject;

public class DepthComponentIntState
extends NodeComponentState {
    private int height;
    private int width;

    public DepthComponentIntState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        int[] buf = new int[this.width * this.height];
        ((DepthComponentInt)this.node).getDepthData(buf);
        for (int i = 0; i < buf.length; ++i) {
            out.writeInt(buf[i]);
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        int[] buf = new int[this.width * this.height];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = in.readInt();
        }
        ((DepthComponentInt)this.node).setDepthData(buf);
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeInt(this.width);
        out.writeInt(this.height);
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.width = in.readInt();
        this.height = in.readInt();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(this.width), new Integer(this.height)});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new DepthComponentInt(this.width, this.height);
    }
}

