/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LODState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.DistanceLOD;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Point3f;

public class DistanceLODState
extends LODState {
    private int numDistances;

    public DistanceLODState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        for (int i = 0; i < this.numDistances; ++i) {
            out.writeDouble(((DistanceLOD)this.node).getDistance(i));
        }
        Point3f pos = new Point3f();
        ((DistanceLOD)this.node).getPosition(pos);
        this.control.writePoint3f(out, pos);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        for (int i = 0; i < this.numDistances; ++i) {
            ((DistanceLOD)this.node).setDistance(i, in.readDouble());
        }
        ((DistanceLOD)this.node).setPosition(this.control.readPoint3f(in));
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        this.numDistances = ((DistanceLOD)this.node).numDistances();
        out.writeInt(this.numDistances);
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.numDistances = in.readInt();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        float[] distances = new float[this.numDistances];
        return this.createNode(j3dClass, new Class[]{distances.getClass()}, new Object[]{distances});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new DistanceLOD(new float[this.numDistances]);
    }
}

