/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SharedGroupState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Link;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SharedGroup;

public class LinkState
extends LeafState {
    private int sharedGroup;
    private SymbolTableData sharedGroupSymbol;

    public LinkState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            SharedGroup sg = ((Link)this.node).getSharedGroup();
            this.sharedGroup = control.getSymbolTable().addReference((SceneGraphObject)sg);
            this.sharedGroupSymbol = control.getSymbolTable().getSymbol(this.sharedGroup);
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        if (this.sharedGroupSymbol.nodeState == null) {
            out.writeInt(-1);
            SharedGroup sg = ((Link)this.node).getSharedGroup();
            this.control.writeSharedGroup(out, sg, this.sharedGroupSymbol);
        } else {
            out.writeInt(this.sharedGroupSymbol.nodeID);
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.sharedGroup = in.readInt();
        if (this.sharedGroup == -1) {
            this.sharedGroup = this.control.readSharedGroup(in);
        }
    }

    @Override
    public void buildGraph() {
        this.sharedGroupSymbol = this.control.getSymbolTable().getSymbol(this.sharedGroup);
        ((SharedGroupState)this.sharedGroupSymbol.nodeState).buildGraph();
        ((Link)this.node).setSharedGroup((SharedGroup)this.sharedGroupSymbol.j3dNode);
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Link();
    }
}

