/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.SceneGraphObject;

public class MediaContainerState
extends NodeComponentState {
    private static final int URL_STRING = 0;
    private static final int URL_OBJECT = 1;
    private static final int INPUT_STREAM = 2;

    public MediaContainerState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        MediaContainer mediaContainer = (MediaContainer)this.node;
        out.writeBoolean(mediaContainer.getCacheEnable());
        if (mediaContainer.getURLString() != null) {
            out.writeInt(0);
            out.writeUTF(mediaContainer.getURLString());
            return;
        }
        if (mediaContainer.getURLObject() != null) {
            out.writeInt(1);
            out.writeUTF(mediaContainer.getURLObject().toString());
            return;
        }
        out.writeInt(2);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((MediaContainer)this.node).setCacheEnable(in.readBoolean());
        int type = in.readInt();
        switch (type) {
            case 0: {
                ((MediaContainer)this.node).setURLString(in.readUTF());
                return;
            }
            case 1: {
                try {
                    ((MediaContainer)this.node).setURLObject(new URI(in.readUTF()).toURL());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
    }

    @Override
    protected SceneGraphObject createNode() {
        return new MediaContainer();
    }
}

