/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewerAvatar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Vector3d;

public class ViewingPlatform
extends BranchGroup {
    protected ViewPlatform viewPlatform;
    protected MultiTransformGroup mtg;
    protected BranchGroup platformGeometryRoot;
    protected BranchGroup avatarRoot;
    protected PlatformGeometry platformGeometry = null;
    protected Hashtable viewerList = new Hashtable();
    protected BranchGroup behaviors;
    protected SimpleUniverse universe;

    public ViewingPlatform() {
        this(1);
    }

    public ViewingPlatform(int numTransforms) {
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
        if (numTransforms < 1) {
            numTransforms = 1;
        }
        this.mtg = new MultiTransformGroup(numTransforms);
        TransformGroup tg = this.mtg.getTransformGroup(0);
        this.addChild((Node)tg);
        tg = this.mtg.getTransformGroup(numTransforms - 1);
        this.viewPlatform = new ViewPlatform();
        this.viewPlatform.setCapability(12);
        this.viewPlatform.setCapability(13);
        tg.addChild((Node)this.viewPlatform);
        tg.setCapability(17);
        tg.setCapability(18);
        this.avatarRoot = new BranchGroup();
        this.avatarRoot.setCapability(12);
        this.avatarRoot.setCapability(13);
        this.avatarRoot.setCapability(14);
        tg.addChild((Node)this.avatarRoot);
        this.platformGeometryRoot = new BranchGroup();
        this.platformGeometryRoot.setCapability(12);
        this.platformGeometryRoot.setCapability(13);
        this.platformGeometryRoot.setCapability(14);
        tg.addChild((Node)this.platformGeometryRoot);
    }

    public void setViewPlatform(ViewPlatform vp) {
        TransformGroup tg = this.getViewPlatformTransform();
        tg.removeChild((Node)this.viewPlatform);
        tg.addChild((Node)vp);
        this.viewPlatform = vp;
        Enumeration e = this.viewerList.keys();
        while (e.hasMoreElements()) {
            ((Viewer)e.nextElement()).setViewingPlatform(this);
        }
    }

    public ViewPlatform getViewPlatform() {
        return this.viewPlatform;
    }

    public void setPlatformGeometry(PlatformGeometry pg) {
        if (this.platformGeometry == pg) {
            return;
        }
        if (pg == null) {
            if (this.platformGeometryRoot.numChildren() != 0) {
                this.platformGeometryRoot.removeChild(0);
            }
        } else if (this.platformGeometryRoot.numChildren() != 0) {
            this.platformGeometryRoot.setChild((Node)pg, 0);
        } else {
            this.platformGeometryRoot.addChild((Node)pg);
        }
        this.platformGeometry = pg;
    }

    public PlatformGeometry getPlatformGeometry() {
        return this.platformGeometry;
    }

    public MultiTransformGroup getMultiTransformGroup() {
        return this.mtg;
    }

    public TransformGroup getViewPlatformTransform() {
        return this.mtg.getTransformGroup(this.mtg.getNumTransforms() - 1);
    }

    public void setNominalViewingTransform() {
        if (this.viewPlatform.getViewAttachPolicy() == 0) {
            double fieldOfView;
            if (this.viewerList.size() == 0) {
                fieldOfView = 0.7853981633974483;
            } else {
                if (this.viewerList.size() > 1) {
                    throw new RuntimeException(J3dUtilsI18N.getString("ViewingPlatform0"));
                }
                Viewer viewer = (Viewer)this.viewerList.keys().nextElement();
                View view = viewer.getView();
                fieldOfView = view.getFieldOfView();
            }
            Transform3D t3d = new Transform3D();
            double viewDistance = 1.0 / Math.tan(fieldOfView / 2.0);
            t3d.set(new Vector3d(0.0, 0.0, viewDistance));
            this.getViewPlatformTransform().setTransform(t3d);
        }
    }

    private int findAvatarChild(ViewerAvatar avatar) {
        for (int i = 0; i < this.avatarRoot.numChildren(); ++i) {
            if ((ViewerAvatar)this.avatarRoot.getChild(i) != avatar) continue;
            return i;
        }
        System.err.println("ViewingPlatform.findAvatarChild:Child not found.");
        return -1;
    }

    void setAvatar(Viewer viewer, ViewerAvatar avatar) {
        Object oldAvatar = this.viewerList.get(viewer);
        int avatarPosition = -1;
        if (oldAvatar != this.avatarRoot) {
            avatarPosition = this.findAvatarChild((ViewerAvatar)((Object)oldAvatar));
        }
        if (avatar == null) {
            if (avatarPosition != -1) {
                this.avatarRoot.removeChild(avatarPosition);
                this.viewerList.put(viewer, this.avatarRoot);
            }
        } else {
            if (avatarPosition != -1) {
                this.avatarRoot.setChild((Node)avatar, avatarPosition);
            } else {
                this.avatarRoot.addChild((Node)avatar);
            }
            this.viewerList.put(viewer, avatar);
        }
    }

    void addViewer(Viewer viewer) {
        this.viewerList.put(viewer, this.avatarRoot);
    }

    void removeViewer(Viewer viewer) {
        this.viewerList.remove(viewer);
    }

    void addViewPlatformBehavior(ViewPlatformBehavior behavior) {
        behavior.setViewingPlatform(this);
        if (this.behaviors == null) {
            this.behaviors = new BranchGroup();
            this.behaviors.setCapability(17);
            this.behaviors.setCapability(12);
        } else {
            this.behaviors.detach();
        }
        this.behaviors.addChild((Node)behavior);
        this.addChild((Node)this.behaviors);
    }

    public void setViewPlatformBehavior(ViewPlatformBehavior behavior) {
        if (this.behaviors != null) {
            this.removeViewPlatformBehavior((ViewPlatformBehavior)this.behaviors.getChild(0));
        }
        if (behavior != null) {
            this.addViewPlatformBehavior(behavior);
        }
    }

    void removeViewPlatformBehavior(ViewPlatformBehavior behavior) {
        if (this.behaviors != null) {
            this.behaviors.detach();
            for (int i = 0; i < this.behaviors.numChildren(); ++i) {
                if (this.behaviors.getChild(i) != behavior) continue;
                behavior.setViewingPlatform(null);
                this.behaviors.removeChild(i);
                break;
            }
            if (this.behaviors.numChildren() == 0) {
                this.behaviors = null;
            } else {
                this.addChild((Node)this.behaviors);
            }
        }
    }

    int getViewPlatformBehaviorCount() {
        return this.behaviors.numChildren();
    }

    ViewPlatformBehavior getViewPlatformBehavior(int index) {
        return (ViewPlatformBehavior)this.behaviors.getChild(index);
    }

    public ViewPlatformBehavior getViewPlatformBehavior() {
        if (this.behaviors == null) {
            return null;
        }
        return this.getViewPlatformBehavior(0);
    }

    public Viewer[] getViewers() {
        if (this.viewerList.size() == 0) {
            return null;
        }
        return this.viewerList.keySet().toArray(new Viewer[0]);
    }

    public SimpleUniverse getUniverse() {
        return this.universe;
    }

    public void setUniverse(SimpleUniverse universe) {
        this.universe = universe;
    }
}

