/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.Behavior;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.Group;
import org.scijava.java3d.Link;
import org.scijava.java3d.Node;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.SharedGroup;
import org.scijava.java3d.Switch;
import org.scijava.java3d.SwitchValueInterpolator;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.loaders.IncorrectFormatException;
import org.scijava.java3d.loaders.ParsingErrorException;
import org.scijava.java3d.loaders.lw3d.J3dLwoParser;
import org.scijava.vecmath.Point3d;

class SequenceLine {
    int startFrame;
    int endFrame;
    String fileName;
    Group geometryGroup = null;
    Behavior behaviors;
    int numFrames;
    float totalTime;
    int totalFrames;
    static Hashtable storedRefList = new Hashtable();

    SequenceLine(StreamTokenizer st, float time, int frames) throws ParsingErrorException {
        try {
            this.totalTime = time;
            this.totalFrames = frames;
            this.startFrame = (int)st.nval;
            st.nextToken();
            this.endFrame = (int)st.nval;
            st.nextToken();
            this.fileName = st.sval;
            this.numFrames = this.endFrame - this.startFrame + 1;
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
    }

    private void createSwitchBehavior(Switch target) {
        int loopCount = -1;
        float animTime = 1000.0f * this.totalTime * (float)target.numChildren() / (float)this.totalFrames;
        float startTime = 1000.0f * this.totalTime * (float)this.startFrame / (float)this.totalFrames;
        Alpha theAlpha = new Alpha(-1, (long)startTime, 0L, (long)animTime, 0L, 0L);
        SwitchValueInterpolator b = new SwitchValueInterpolator(theAlpha, target);
        this.behaviors = b;
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
        b.setSchedulingBounds((Bounds)bounds);
        target.setCapability(18);
        target.addChild((Node)this.behaviors);
    }

    void createJava3dObjects(int debugVals, int loadBehaviors) throws IncorrectFormatException, FileNotFoundException {
        if (this.fileName.indexOf("000") != -1) {
            int index = this.fileName.indexOf("000");
            String fileNameBase = this.fileName.substring(0, index);
            Switch s = new Switch();
            s.setCapability(17);
            s.setCapability(18);
            String tempFileName = this.fileName;
            int fileNum = 0;
            while (new File(tempFileName).exists()) {
                if (storedRefList.get(tempFileName) != null) {
                    SharedGroup storedGroup = (SharedGroup)storedRefList.get(tempFileName);
                    Link newLink = new Link(storedGroup);
                    s.addChild((Node)newLink);
                } else {
                    J3dLwoParser objParser = new J3dLwoParser(tempFileName, debugVals);
                    objParser.createJava3dGeometry();
                    TransformGroup t = new TransformGroup();
                    SharedGroup newSharedGroup = new SharedGroup();
                    storedRefList.put(tempFileName, newSharedGroup);
                    newSharedGroup.addChild((Node)t);
                    Link newLink = new Link(newSharedGroup);
                    s.addChild((Node)newLink);
                    if (objParser.getJava3dShapeList() != null) {
                        Enumeration e = objParser.getJava3dShapeList().elements();
                        while (e.hasMoreElements()) {
                            t.addChild((Node)((Shape3D)e.nextElement()));
                        }
                    }
                }
                String fileNumString = String.valueOf(++fileNum);
                if (fileNum < 10) {
                    fileNumString = "00" + fileNumString;
                } else if (fileNum < 100) {
                    fileNumString = "0" + fileNumString;
                }
                tempFileName = fileNameBase + fileNumString + ".lwo";
            }
            this.behaviors = null;
            if (loadBehaviors != 0) {
                this.createSwitchBehavior(s);
            }
            this.geometryGroup = s;
        } else {
            this.geometryGroup = new Group();
            if (storedRefList.get(this.fileName) != null) {
                SharedGroup storedGroup = (SharedGroup)storedRefList.get(this.fileName);
                Link newLink = new Link(storedGroup);
                this.geometryGroup.addChild((Node)newLink);
            } else {
                J3dLwoParser objParser = new J3dLwoParser(this.fileName, debugVals);
                objParser.createJava3dGeometry();
                TransformGroup t = new TransformGroup();
                if (objParser.getJava3dShapeList() != null) {
                    Enumeration e = objParser.getJava3dShapeList().elements();
                    while (e.hasMoreElements()) {
                        t.addChild((Node)((Shape3D)e.nextElement()));
                    }
                }
                SharedGroup newSharedGroup = new SharedGroup();
                newSharedGroup.addChild((Node)t);
                Link newLink = new Link(newSharedGroup);
                this.geometryGroup.addChild((Node)newLink);
                storedRefList.put(this.fileName, newSharedGroup);
            }
        }
    }

    Group getGeometry() {
        return this.geometryGroup;
    }

    Behavior getBehavior() {
        return this.behaviors;
    }
}

