/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.Cancelable;
import org.scijava.Context;
import org.scijava.Identifiable;
import org.scijava.InstantiableException;
import org.scijava.ItemVisibility;
import org.scijava.ValidityProblem;
import org.scijava.command.Command;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandModuleItem;
import org.scijava.command.Interactive;
import org.scijava.command.Previewable;
import org.scijava.event.EventService;
import org.scijava.module.Module;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.module.event.ModulesUpdatedEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.service.Service;
import org.scijava.util.ClassUtils;
import org.scijava.util.StringMaker;

public class CommandInfo
extends PluginInfo<Command>
implements ModuleInfo,
Identifiable {
    private final PluginInfo<Command> info;
    private Map<String, Object> presets;
    private boolean paramsParsed;
    private final List<ValidityProblem> problems = new ArrayList<ValidityProblem>();
    private final Map<String, ModuleItem<?>> inputMap = new HashMap();
    private final Map<String, ModuleItem<?>> outputMap = new HashMap();
    private final List<ModuleItem<?>> inputList = new ArrayList();
    private final List<ModuleItem<?>> outputList = new ArrayList();

    public CommandInfo(String className) {
        this(null, className, null, null);
    }

    public CommandInfo(String className, Plugin annotation) {
        this(null, className, null, annotation);
    }

    public CommandInfo(Class<? extends Command> commandClass) {
        this(null, null, commandClass, null);
    }

    public CommandInfo(Class<? extends Command> commandClass, Plugin annotation) {
        this(null, null, commandClass, annotation);
    }

    public CommandInfo(PluginInfo<Command> info) {
        this(info, null, null, info.getAnnotation());
    }

    protected CommandInfo(PluginInfo<Command> info, String className, Class<? extends Command> commandClass, Plugin annotation) {
        super(className, commandClass, Command.class, annotation, null);
        this.info = info;
        this.setPresets(null);
    }

    public void setPresets(Map<String, Object> presets) {
        this.presets = presets == null ? new HashMap<String, Object>() : presets;
    }

    public Map<String, Object> getPresets() {
        return this.presets;
    }

    public Module createModule(Command commandInstance) {
        if (commandInstance instanceof Module) {
            return (Module)((Object)commandInstance);
        }
        return new CommandModule(this, commandInstance);
    }

    @Override
    public void setPluginClass(Class<? extends Command> pluginClass) {
        if (this.info == null) {
            super.setPluginClass(pluginClass);
        } else {
            this.info.setPluginClass(pluginClass);
        }
    }

    @Override
    public Class<? extends Command> getPluginClass() {
        return this.info == null ? super.getPluginClass() : this.info.getPluginClass();
    }

    @Override
    public URL getIconURL() throws InstantiableException {
        return this.info == null ? super.getIconURL() : this.info.getIconURL();
    }

    @Override
    public String toString() {
        StringMaker sm = new StringMaker(super.toString());
        for (String key : this.presets.keySet()) {
            Object value = this.presets.get(key);
            sm.append(key, value);
        }
        return sm.toString();
    }

    @Override
    public String getClassName() {
        return this.info == null ? super.getClassName() : this.info.getClassName();
    }

    @Override
    public Class<? extends Command> loadClass() throws InstantiableException {
        return this.info == null ? super.loadClass() : this.info.loadClass();
    }

    @Override
    public Command createInstance() throws InstantiableException {
        return this.info == null ? (Command)super.createInstance() : (Command)this.info.createInstance();
    }

    public CommandModuleItem<?> getInput(String name) {
        this.parseParams();
        return (CommandModuleItem)this.inputMap.get(name);
    }

    public <T> CommandModuleItem<T> getInput(String name, Class<T> type) {
        return this.castItem((CommandModuleItem<?>)this.getInput(name), type);
    }

    public CommandModuleItem<?> getOutput(String name) {
        this.parseParams();
        return (CommandModuleItem)this.outputMap.get(name);
    }

    public <T> CommandModuleItem<T> getOutput(String name, Class<T> type) {
        return this.castItem((CommandModuleItem<?>)this.getOutput(name), type);
    }

    @Override
    public Iterable<ModuleItem<?>> inputs() {
        this.parseParams();
        return Collections.unmodifiableList(this.inputList);
    }

    @Override
    public Iterable<ModuleItem<?>> outputs() {
        this.parseParams();
        return Collections.unmodifiableList(this.outputList);
    }

    @Override
    public String getDelegateClassName() {
        return this.getClassName();
    }

    @Override
    public Module createModule() throws ModuleException {
        try {
            Class<? extends Command> commandClass = this.loadClass();
            if (Module.class.isAssignableFrom(commandClass)) {
                return (Module)((Object)commandClass.newInstance());
            }
        }
        catch (InstantiableException e) {
            throw new ModuleException(e);
        }
        catch (InstantiationException e) {
            throw new ModuleException(e);
        }
        catch (IllegalAccessException e) {
            throw new ModuleException(e);
        }
        return new CommandModule(this);
    }

    @Override
    public boolean isInteractive() {
        Class<?> commandClass = this.loadCommandClass();
        if (commandClass == null) {
            return false;
        }
        return Interactive.class.isAssignableFrom(commandClass);
    }

    @Override
    public boolean canPreview() {
        Class<?> commandClass = this.loadCommandClass();
        if (commandClass == null) {
            return false;
        }
        return Previewable.class.isAssignableFrom(commandClass);
    }

    @Override
    public boolean canCancel() {
        Class<?> commandClass = this.loadCommandClass();
        if (commandClass == null) {
            return false;
        }
        return Cancelable.class.isAssignableFrom(commandClass);
    }

    @Override
    public boolean canRunHeadless() {
        return this.getAnnotation() == null ? false : this.getAnnotation().headless();
    }

    @Override
    public String getInitializer() {
        return this.getAnnotation() == null ? null : this.getAnnotation().initializer();
    }

    @Override
    public void update(EventService eventService) {
        eventService.publish(new ModulesUpdatedEvent(this));
    }

    @Override
    public String getTitle() {
        String title = super.getTitle();
        if (!title.equals(this.getClass().getSimpleName())) {
            return title;
        }
        String className = this.getDelegateClassName();
        int dot = className.lastIndexOf(".");
        return dot < 0 ? className : className.substring(dot + 1);
    }

    @Override
    public boolean isValid() {
        this.parseParams();
        return this.problems.isEmpty();
    }

    @Override
    public List<ValidityProblem> getProblems() {
        this.parseParams();
        return Collections.unmodifiableList(this.problems);
    }

    @Override
    public String getIdentifier() {
        StringBuilder sb = new StringBuilder();
        sb.append("command:" + this.getDelegateClassName());
        Map<String, Object> pre = this.getPresets();
        if (!pre.isEmpty()) {
            sb.append("(");
            boolean first = true;
            for (String name : pre.keySet()) {
                String sValue;
                Object value = pre.get(name);
                String string = sValue = value == null ? "" : value.toString().replaceAll("[^\\w]", "_");
                if (first) {
                    sb.append(", ");
                    first = false;
                }
                sb.append(name + " = " + sValue);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private void parseParams() {
        if (!this.paramsParsed) {
            this.initParams();
        }
    }

    private synchronized void initParams() {
        if (this.paramsParsed) {
            return;
        }
        this.checkFields(this.loadCommandClass());
        this.paramsParsed = true;
    }

    private void checkFields(Class<?> type) {
        if (type == null) {
            return;
        }
        List<Field> fields = ClassUtils.getAnnotatedFields(type, Parameter.class);
        for (Field f : fields) {
            String name;
            boolean isMessage;
            f.setAccessible(true);
            if (Service.class.isAssignableFrom(f.getType()) || Context.class.isAssignableFrom(f.getType())) continue;
            Parameter param = f.getAnnotation(Parameter.class);
            boolean valid = true;
            boolean isFinal = Modifier.isFinal(f.getModifiers());
            boolean bl = isMessage = param.visibility() == ItemVisibility.MESSAGE;
            if (isFinal && !isMessage) {
                String error = "Invalid final parameter: " + f;
                this.problems.add(new ValidityProblem(error));
                valid = false;
            }
            if (this.inputMap.containsKey(name = f.getName()) || this.outputMap.containsKey(name)) {
                String error = "Invalid duplicate parameter: " + f;
                this.problems.add(new ValidityProblem(error));
                valid = false;
            }
            if (!valid) continue;
            boolean isPreset = this.presets.containsKey(name);
            CommandModuleItem item = new CommandModuleItem(this, f);
            if (item.isInput()) {
                this.inputMap.put(name, item);
                if (!isPreset) {
                    this.inputList.add(item);
                }
            }
            if (!item.isOutput()) continue;
            this.outputMap.put(name, item);
            if (isPreset) continue;
            this.outputList.add(item);
        }
    }

    private Class<?> loadCommandClass() {
        try {
            return this.loadClass();
        }
        catch (InstantiableException e) {
            String error = "Could not initialize command class: " + this.getClassName();
            this.problems.add(new ValidityProblem(error, e));
            return null;
        }
    }

    private <T> CommandModuleItem<T> castItem(CommandModuleItem<?> item, Class<T> type) {
        Class<?> itemType = item.getType();
        if (!type.isAssignableFrom(itemType)) {
            throw new IllegalArgumentException("Type " + type.getName() + " is incompatible with item of type " + itemType.getName());
        }
        CommandModuleItem<?> typedItem = item;
        return typedItem;
    }
}

