/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event;

import java.lang.ref.WeakReference;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;

public class EventServiceTest {
    private int counter = 0;

    @Test
    public void testWeakEventHandlers() {
        WeakReference<MyEventHandler> reference = new WeakReference<MyEventHandler>(new MyEventHandler());
        EventServiceTest.gc();
        Assert.assertNull(reference.get());
        Context context = new Context(new Class[]{EventService.class});
        EventService eventService = (EventService)context.getService(EventService.class);
        MyEventHandler handler = new MyEventHandler();
        eventService.subscribe((Object)handler);
        EventServiceTest.gc();
        Assert.assertEquals((long)0L, (long)this.counter);
        eventService.publish((SciJavaEvent)new MyEvent());
        Assert.assertEquals((long)1L, (long)this.counter);
        handler = null;
        EventServiceTest.gc();
        eventService.publish((SciJavaEvent)new MyEvent());
        Assert.assertEquals((long)1L, (long)this.counter);
    }

    private static void gc() {
        System.gc();
        System.gc();
    }

    public static class MyEventHandler {
        @EventHandler
        public void onEvent(MyEvent e) {
            e.inc();
        }
    }

    private class MyEvent
    extends SciJavaEvent {
        private MyEvent() {
        }

        public void inc() {
            EventServiceTest.this.counter++;
        }
    }
}

