/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Map;
import org.scijava.util.ClassUtils;
import org.scijava.util.FileUtils;

public class TestUtils {
    private static int temporaryDirectoryCounter = 1;

    public static File createTemporaryDirectory(String prefix) throws IOException {
        Map.Entry<Class<?>, String> calling = TestUtils.getCallingCodeLocation(null);
        return TestUtils.createTemporaryDirectory(prefix, calling.getKey(), calling.getValue());
    }

    public static File createTemporaryDirectory(String prefix, Class<?> forClass) throws IOException {
        return TestUtils.createTemporaryDirectory(prefix, forClass, "" + temporaryDirectoryCounter++);
    }

    public static File createTemporaryDirectory(String prefix, Class<?> forClass, String suffix) throws IOException {
        URL directory = ClassUtils.getLocation(forClass);
        if (directory == null) {
            throw new IllegalArgumentException("No location for class " + forClass);
        }
        if (!"file".equals(directory.getProtocol())) {
            throw new IllegalArgumentException("Invalid directory: " + directory);
        }
        String path = directory.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Directory has null path");
        }
        File baseDirectory = path.endsWith("/target/test-classes/") ? new File(path).getParentFile() : new File(path);
        File file = new File(baseDirectory, prefix + suffix);
        if (file.isDirectory()) {
            if (!FileUtils.deleteRecursively(file)) {
                int i = -1;
                while (file.isDirectory()) {
                    file = new File(baseDirectory, prefix + i + suffix);
                    --i;
                }
            }
        } else if (file.exists() && !file.delete()) {
            throw new IOException("Could not remove " + file);
        }
        if (!file.mkdir()) {
            throw new IOException("Could not make directory " + file);
        }
        return file;
    }

    public static Class<?> getCallingClass(Class<?> excluding) {
        return TestUtils.getCallingCodeLocation(excluding).getKey();
    }

    public static Map.Entry<Class<?>, String> getCallingCodeLocation(Class<?> excluding) {
        String thisClassName = TestUtils.class.getName();
        String thisClassName2 = excluding == null ? null : excluding.getName();
        Thread currentThread = Thread.currentThread();
        for (StackTraceElement element : currentThread.getStackTrace()) {
            Class<?> clazz;
            String thatClassName = element.getClassName();
            if (thatClassName == null || thatClassName.equals(thisClassName) || thatClassName.equals(thisClassName2) || thatClassName.endsWith("TestUtils") || thatClassName.startsWith("java.lang.")) continue;
            ClassLoader loader = currentThread.getContextClassLoader();
            try {
                clazz = loader.loadClass(element.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Could not load " + element.getClassName() + " with the current context class loader (" + loader + ")!");
            }
            String suffix = element.getMethodName() + "-L" + element.getLineNumber();
            return new AbstractMap.SimpleEntry(clazz, suffix);
        }
        throw new UnsupportedOperationException("No calling class outside " + thisClassName + " found!");
    }
}

