/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.object;

import java.util.List;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.object.ObjectIndex;
import org.scijava.object.ObjectService;
import org.scijava.object.event.ObjectCreatedEvent;
import org.scijava.object.event.ObjectDeletedEvent;
import org.scijava.object.event.ObjectsAddedEvent;
import org.scijava.object.event.ObjectsRemovedEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultObjectService
extends AbstractService
implements ObjectService {
    @Parameter
    private EventService eventService;
    private ObjectIndex<Object> objectIndex;

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public ObjectIndex<Object> getIndex() {
        return this.objectIndex;
    }

    @Override
    public <T> List<T> getObjects(Class<T> type) {
        List<Object> list;
        List<Object> result = list = this.objectIndex.get(type);
        return result;
    }

    @Override
    public void addObject(Object obj) {
        this.objectIndex.add(obj);
        this.eventService.publish(new ObjectsAddedEvent(obj));
    }

    @Override
    public void removeObject(Object obj) {
        this.objectIndex.remove(obj);
        this.eventService.publish(new ObjectsRemovedEvent(obj));
    }

    @Override
    public void initialize() {
        this.objectIndex = new ObjectIndex<Object>(Object.class);
    }

    @EventHandler
    protected void onEvent(ObjectCreatedEvent event) {
        this.addObject(event.getObject());
    }

    @EventHandler
    protected void onEvent(ObjectDeletedEvent event) {
        this.removeObject(event.getObject());
    }
}

