/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.usage;

import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.Identifiable;
import org.scijava.Locatable;
import org.scijava.usage.UsageService;
import org.scijava.usage.UsageStats;

public class UsageServiceTest {
    private UsageService usageService;

    @Before
    public void setUp() {
        Context context = new Context(new Class[]{UsageService.class});
        this.usageService = (UsageService)context.getService(UsageService.class);
    }

    @After
    public void tearDown() {
        this.usageService.getContext().dispose();
    }

    @Test
    public void testUsage() {
        Thing foo = new Thing("foo", "file:/foo");
        Thing bar = new Thing("bar", "file:/bar");
        Map stats = this.usageService.getStats();
        Assert.assertTrue((boolean)stats.isEmpty());
        Assert.assertNull(stats.get(foo));
        this.usageService.increment((Object)foo);
        Assert.assertEquals((long)1L, (long)stats.size());
        UsageStats fooStats = (UsageStats)stats.get(foo.getIdentifier());
        Assert.assertNotNull((Object)fooStats);
        Assert.assertSame((Object)fooStats, (Object)this.usageService.getUsage((Object)foo));
        Assert.assertEquals((Object)foo.getIdentifier(), (Object)fooStats.getIdentifier());
        Assert.assertEquals((Object)"file:/foo", (Object)fooStats.getLocation());
        Assert.assertEquals((long)1L, (long)fooStats.getCount());
        Assert.assertFalse((boolean)stats.containsKey(bar));
        this.usageService.increment((Object)bar);
        Assert.assertEquals((long)2L, (long)stats.size());
        UsageStats barStats = (UsageStats)stats.get(bar.getIdentifier());
        Assert.assertNotNull((Object)barStats);
        Assert.assertSame((Object)barStats, (Object)this.usageService.getUsage((Object)bar));
        Assert.assertEquals((Object)bar.getIdentifier(), (Object)barStats.getIdentifier());
        Assert.assertEquals((Object)"file:/bar", (Object)barStats.getLocation());
        Assert.assertEquals((long)1L, (long)barStats.getCount());
        this.usageService.increment((Object)foo);
        Assert.assertEquals((long)2L, (long)stats.size());
        Assert.assertEquals((long)2L, (long)fooStats.getCount());
        Assert.assertEquals((long)1L, (long)barStats.getCount());
        this.usageService.clearStats();
        Assert.assertEquals((long)2L, (long)stats.size());
        Assert.assertEquals((long)2L, (long)fooStats.getCount());
        Assert.assertEquals((long)1L, (long)barStats.getCount());
        Map newStats = this.usageService.getStats();
        Assert.assertNotSame((Object)stats, (Object)newStats);
        Assert.assertTrue((boolean)newStats.isEmpty());
        Assert.assertNotSame((Object)fooStats, (Object)this.usageService.getUsage((Object)foo));
        Assert.assertNotSame((Object)barStats, (Object)this.usageService.getUsage((Object)bar));
        this.usageService.increment((Object)foo);
        Assert.assertEquals((long)2L, (long)fooStats.getCount());
        Assert.assertEquals((long)1L, (long)barStats.getCount());
        Assert.assertEquals((long)1L, (long)((UsageStats)newStats.get(foo.getIdentifier())).getCount());
    }

    private static class Thing
    implements Identifiable,
    Locatable {
        private String id;
        private String location;

        private Thing(String id, String location) {
            this.id = id;
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        public String getIdentifier() {
            return this.id;
        }
    }
}

