/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.thread;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.thread.ThreadService;

public class ThreadServiceTest {
    private Context context;
    private ThreadService threadService;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{ThreadService.class});
        this.threadService = (ThreadService)this.context.getService(ThreadService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testRunCallable() throws InterruptedException, ExecutionException {
        Thread result = (Thread)this.threadService.run((Callable)new Callable<Thread>(){

            @Override
            public Thread call() {
                return Thread.currentThread();
            }
        }).get();
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)result);
    }

    @Test
    public void testRunRunnable() throws InterruptedException, ExecutionException {
        final Thread[] results = new Thread[1];
        this.threadService.run(new Runnable(){

            @Override
            public void run() {
                results[0] = Thread.currentThread();
            }
        }).get();
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)results[0]);
    }

    @Test
    public void testInvoke() throws InterruptedException, InvocationTargetException {
        final boolean[] results = new boolean[1];
        this.threadService.invoke(new Runnable(){

            @Override
            public void run() {
                results[0] = ThreadServiceTest.this.threadService.isDispatchThread();
            }
        });
        Assert.assertTrue((boolean)results[0]);
        Assert.assertFalse((boolean)this.threadService.isDispatchThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueue() throws InterruptedException {
        final Object sync = new Object();
        final boolean[] results = new boolean[1];
        Object object = sync;
        synchronized (object) {
            this.threadService.queue(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    results[0] = ThreadServiceTest.this.threadService.isDispatchThread();
                    Object object = sync;
                    synchronized (object) {
                        sync.notifyAll();
                    }
                }
            });
            sync.wait();
        }
        Assert.assertTrue((boolean)results[0]);
        Assert.assertFalse((boolean)this.threadService.isDispatchThread());
    }

    @Test
    public void testGetParentInvoke() throws Exception {
        AskForParentR ask = new AskForParentR(this.threadService);
        this.threadService.invoke((Runnable)ask);
        Assert.assertSame((Object)Thread.currentThread(), (Object)ask.parent);
    }

    @Test
    public void testGetParentRunCallable() throws Exception {
        AskForParentC ask = new AskForParentC(this.threadService);
        Thread parent = (Thread)this.threadService.run((Callable)ask).get();
        Assert.assertSame((Object)Thread.currentThread(), (Object)parent);
    }

    @Test
    public void testGetParentRunRunnable() throws Exception {
        AskForParentR ask = new AskForParentR(this.threadService);
        this.threadService.run((Runnable)ask).get();
        Assert.assertSame((Object)Thread.currentThread(), (Object)ask.parent);
    }

    private static class AskForParentC
    implements Callable<Thread> {
        private final ThreadService threadService;

        public AskForParentC(ThreadService threadService) {
            this.threadService = threadService;
        }

        @Override
        public Thread call() {
            return this.threadService.getParent(null);
        }
    }

    private static class AskForParentR
    implements Runnable {
        private final ThreadService threadService;
        private Thread parent;

        public AskForParentR(ThreadService threadService) {
            this.threadService = threadService;
        }

        @Override
        public void run() {
            this.parent = this.threadService.getParent(null);
        }
    }
}

