/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.ByteArray;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;

public class ByteArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        ByteArray array = new ByteArray();
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((byte[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        ByteArray array = new ByteArray(24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((byte[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertArrayEquals((byte[])raw, (byte[])((byte[])array.copyArray()));
    }

    @Test
    public void testAddValue() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        boolean e6 = true;
        int e7 = 2;
        array.addValue((byte)1);
        array.addValue((byte)2);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((long)1L, (long)array.getValue(5));
        Assert.assertEquals((long)2L, (long)array.getValue(6));
    }

    public void testRemoveValue() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue(raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue(raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue(raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    public void testGetValue() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
    }

    @Test
    public void testSetValue() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        int e0 = 7;
        boolean e2 = true;
        int e4 = 2;
        array.setValue(0, (byte)7);
        array.setValue(2, (byte)1);
        array.setValue(4, (byte)2);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((long)1L, (long)array.getValue(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((long)2L, (long)array.getValue(4));
    }

    @Test
    public void testAddValueIndex() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        int e0 = 7;
        boolean e4 = true;
        int e7 = 2;
        array.addValue(0, (byte)7);
        array.addValue(4, (byte)1);
        array.addValue(7, (byte)2);
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[0], (long)array.getValue(1));
        Assert.assertEquals((long)raw[1], (long)array.getValue(2));
        Assert.assertEquals((long)raw[2], (long)array.getValue(3));
        Assert.assertEquals((long)1L, (long)array.getValue(4));
        Assert.assertEquals((long)raw[3], (long)array.getValue(5));
        Assert.assertEquals((long)raw[4], (long)array.getValue(6));
        Assert.assertEquals((long)2L, (long)array.getValue(7));
    }

    public void testRemoveIndex() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testIndexOf() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)-1));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)0));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)1));
        Assert.assertEquals((long)-1L, (long)array.indexOf((byte)127));
        Assert.assertEquals((long)-1L, (long)array.indexOf((byte)-128));
    }

    @Test
    public void testLastIndexOf() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)-1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)0));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((byte)127));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((byte)-128));
    }

    @Test
    public void testContains() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains(raw[i]));
        }
        Assert.assertFalse((boolean)array.contains((Object)-1));
        Assert.assertFalse((boolean)array.contains((Object)0));
        Assert.assertFalse((boolean)array.contains((Object)1));
        Assert.assertFalse((boolean)array.contains((byte)127));
        Assert.assertFalse((boolean)array.contains((byte)-128));
    }

    @Test
    public void testSetArray() {
        ByteArray array = new ByteArray();
        byte[] raw = new byte[]{1, 2, 3, 5, 8, 13, 21};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        this.testInsert((PrimitiveArray<?, ?>)new ByteArray(raw));
    }

    @Test
    public void testDelete() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        this.testDelete((PrimitiveArray<?, ?>)new ByteArray(raw));
    }

    @Test
    public void testGet() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.get(i).byteValue());
        }
    }

    @Test
    public void testSet() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        Byte e0 = 7;
        Byte e2 = 1;
        Byte e4 = 2;
        array.set(0, e0);
        array.set(2, e2);
        array.set(4, e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.get(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((Object)e2, (Object)array.get(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.get(4));
    }

    @Test
    public void testAdd() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        Byte e6 = 1;
        Byte e7 = 2;
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((Object)e6, (Object)array.get(5));
        Assert.assertEquals((Object)e7, (Object)array.get(6));
    }

    @Test
    public void testIndexOfBoxed() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Byte(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Byte(-1)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Byte(0)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Byte(1)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Byte(127)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Byte(-128)));
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not a byte"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Byte(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Byte(-1)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Byte(0)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Byte(1)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Byte(127)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Byte(-128)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not a byte"));
    }

    @Test
    public void testContainsBoxed() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Byte(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains((Object)new Byte(-1)));
        Assert.assertFalse((boolean)array.contains((Object)new Byte(0)));
        Assert.assertFalse((boolean)array.contains((Object)new Byte(1)));
        Assert.assertFalse((boolean)array.contains((Object)new Byte(127)));
        Assert.assertFalse((boolean)array.contains((Object)new Byte(-128)));
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not a byte"));
    }

    @Test
    public void testRemove() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Byte(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Byte(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove((Object)new Byte(raw[4]));
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testContainsAll() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        ArrayList<Byte> list = new ArrayList<Byte>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add((byte)13);
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add((byte)1);
        Assert.assertFalse((boolean)array.containsAll(list));
        ByteArray yes = new ByteArray(new byte[]{3, 8, 21});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        ByteArray no = new ByteArray(new byte[]{5, 13, 1});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        byte[] add = new byte[]{1, 7};
        ByteArray toAdd = new ByteArray((byte[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)raw[i], (long)array.getValue(i));
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((long)add[i - 3], (long)array.getValue(i));
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((long)raw[i - add.length], (long)array.getValue(i));
        }
    }

    @Test
    public void testRemoveAll() {
        byte[] raw = new byte[]{3, 5, 8, 13, 21};
        ByteArray array = new ByteArray((byte[])raw.clone());
        ByteArray toRemove = new ByteArray(new byte[]{3, 8, 21});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }
}

