/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.util.List;
import javax.script.ScriptException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.script.ScriptService;
import org.scijava.util.AppUtils;

public class ScriptServiceTest {
    @Test
    public void testSystemProperty() {
        String slash = File.separator;
        String sep = File.pathSeparator;
        String root = new File(slash).getAbsolutePath();
        String dir1 = root + "foo" + slash + "bar";
        String dir2 = root + "to" + slash + "the" + slash + "moon";
        System.setProperty("scijava.scripts.path", dir1 + sep + dir2);
        Context context = new Context(new Class[]{ScriptService.class});
        ScriptService scriptService = (ScriptService)context.service(ScriptService.class);
        List scriptDirs = scriptService.getScriptDirectories();
        Assert.assertEquals((long)3L, (long)scriptDirs.size());
        File baseDir = AppUtils.getBaseDirectory(ScriptService.class);
        String dir0 = baseDir.getPath() + slash + "scripts";
        Assert.assertEquals((Object)dir0, (Object)((File)scriptDirs.get(0)).getAbsolutePath());
        Assert.assertEquals((Object)dir1, (Object)((File)scriptDirs.get(1)).getAbsolutePath());
        Assert.assertEquals((Object)dir2, (Object)((File)scriptDirs.get(2)).getAbsolutePath());
    }

    @Test
    public void testArrayAliases() throws ScriptException {
        Context ctx = new Context(new Class[]{ScriptService.class});
        ScriptService ss = (ScriptService)ctx.service(ScriptService.class);
        Class pInt2D = ss.lookupClass("int[][]");
        Assert.assertSame(int[][].class, (Object)pInt2D);
        Class pInt1D = ss.lookupClass("int[]");
        Assert.assertSame(int[].class, (Object)pInt1D);
        Class pInt = ss.lookupClass("int");
        Assert.assertSame(Integer.TYPE, (Object)pInt);
        Class oInt2D = ss.lookupClass("Integer[][]");
        Assert.assertSame(Integer[][].class, (Object)oInt2D);
        Class oInt1D = ss.lookupClass("Integer[]");
        Assert.assertSame(Integer[].class, (Object)oInt1D);
        Class oInt = ss.lookupClass("Integer");
        Assert.assertSame(Integer.class, (Object)oInt);
        Class str2D = ss.lookupClass("String[][]");
        Assert.assertSame(String[][].class, (Object)str2D);
        Class str1D = ss.lookupClass("String[]");
        Assert.assertSame(String[].class, (Object)str1D);
        Class str = ss.lookupClass("String");
        Assert.assertSame(String.class, (Object)str);
        ctx.dispose();
    }
}

