/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.platform;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.scijava.command.CommandService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.platform.AppEventService;
import org.scijava.platform.Platform;
import org.scijava.platform.PlatformService;
import org.scijava.platform.event.AppMenusCreatedEvent;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultPlatformService
extends AbstractSingletonService<Platform>
implements PlatformService {
    @Parameter
    private LogService log;
    @Parameter
    private EventService eventService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private AppEventService appEventService;
    private List<Platform> targetPlatforms;

    @Override
    public EventService eventService() {
        return this.eventService;
    }

    @Override
    public CommandService commandService() {
        return this.commandService;
    }

    @Override
    public AppEventService getAppEventService() {
        return this.appEventService;
    }

    @Override
    public List<Platform> getTargetPlatforms() {
        return this.targetPlatforms;
    }

    @Override
    public void open(URL url) throws IOException {
        IOException exception = null;
        for (Platform platform : this.getTargetPlatforms()) {
            try {
                platform.open(url);
                return;
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.log.error("Could not find a browser; URL=" + url);
        throw new IOException("No browser found");
    }

    @Override
    public int exec(String ... args) throws IOException {
        Process process = Runtime.getRuntime().exec(args);
        try {
            process.waitFor();
            return process.exitValue();
        }
        catch (InterruptedException ie) {
            throw new IOException("InterruptedException during execution: " + ie.getMessage());
        }
    }

    @Override
    public boolean registerAppMenus(Object menus) {
        for (Platform platform : this.getTargetPlatforms()) {
            if (!platform.registerAppMenus(menus)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<? extends Platform> filterInstances(List<Platform> list) {
        Iterator<Platform> iter = list.iterator();
        while (iter.hasNext()) {
            if (iter.next().isTarget()) continue;
            iter.remove();
        }
        return list;
    }

    @Override
    public Class<Platform> getPluginType() {
        return Platform.class;
    }

    @Override
    public void initialize() {
        super.initialize();
        List platforms = this.getInstances();
        this.targetPlatforms = Collections.unmodifiableList(platforms);
        for (Platform platform : platforms) {
            this.log.debug("Configuring platform: " + platform.getClass().getName());
            platform.configure(this);
        }
        if (platforms.size() == 0) {
            this.log.debug("No platforms to configure.");
        }
    }

    @Override
    public void dispose() {
        for (Platform p : this.targetPlatforms) {
            p.dispose();
        }
    }

    @EventHandler
    protected void onEvent(AppMenusCreatedEvent event) {
        if (this.registerAppMenus(event.getMenus())) {
            event.consume();
        }
    }
}

