/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.service;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.event.DefaultEventService;
import org.scijava.log.StderrLogService;
import org.scijava.options.DefaultOptionsService;
import org.scijava.options.OptionsService;
import org.scijava.plugin.DefaultPluginService;
import org.scijava.plugin.PluginService;
import org.scijava.service.SciJavaService;
import org.scijava.service.Service;
import org.scijava.service.ServiceIndex;
import org.scijava.thread.DefaultThreadService;

public class ServiceIndexTest {
    @Test
    public void testGetAll() {
        Context context = new Context(new Class[]{PluginService.class});
        ServiceIndex serviceIndex = context.getServiceIndex();
        List all = serviceIndex.getAll();
        Assert.assertEquals((long)4L, (long)all.size());
        Assert.assertSame(DefaultEventService.class, ((Service)all.get(0)).getClass());
        Assert.assertSame(DefaultPluginService.class, ((Service)all.get(1)).getClass());
        Assert.assertSame(DefaultThreadService.class, ((Service)all.get(2)).getClass());
        Assert.assertSame(StderrLogService.class, ((Service)all.get(3)).getClass());
        context.dispose();
    }

    @Test
    public void testMarkerInterfaces() {
        Context context = new Context();
        for (Service s : context.getServiceIndex().getAll()) {
            Assert.assertTrue((String)s.getClass().getName(), (boolean)(s instanceof SciJavaService));
        }
        context.dispose();
    }

    @Test
    public void testGetPrevService() {
        Context context = new Context(new Class[]{SciJavaService.class});
        ServiceIndex serviceIndex = this.setUpPrivateServices(context);
        Assert.assertEquals(DefaultOptionsService.class, ((OptionsService)serviceIndex.getPrevService(OptionsService.class, LowerOptionsService.class)).getClass());
        Assert.assertEquals(HigherOptionsService.class, ((OptionsService)serviceIndex.getPrevService(OptionsService.class, DefaultOptionsService.class)).getClass());
        Assert.assertNull((Object)serviceIndex.getPrevService(OptionsService.class, HigherOptionsService.class));
        context.dispose();
    }

    @Test
    public void testGetNextService() {
        Context context = new Context(new Class[]{SciJavaService.class});
        ServiceIndex serviceIndex = this.setUpPrivateServices(context);
        Assert.assertEquals(DefaultOptionsService.class, ((OptionsService)serviceIndex.getNextService(OptionsService.class, HigherOptionsService.class)).getClass());
        Assert.assertEquals(LowerOptionsService.class, ((OptionsService)serviceIndex.getNextService(OptionsService.class, DefaultOptionsService.class)).getClass());
        Assert.assertNull((Object)serviceIndex.getNextService(OptionsService.class, LowerOptionsService.class));
        context.dispose();
    }

    private ServiceIndex setUpPrivateServices(Context context) {
        ServiceIndex serviceIndex = context.getServiceIndex();
        serviceIndex.add((Object)new HigherOptionsService());
        serviceIndex.add((Object)new LowerOptionsService());
        return serviceIndex;
    }

    private static class LowerOptionsService
    extends DefaultOptionsService {
        private LowerOptionsService() {
        }

        public double getPriority() {
            return super.getPriority() - 30.0;
        }
    }

    private static class HigherOptionsService
    extends DefaultOptionsService {
        private HigherOptionsService() {
        }

        public double getPriority() {
            return super.getPriority() + 25.0;
        }
    }
}

