/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class CommandArrayConverterTest {
    @Test
    public void testArrayCommandRaw() throws InterruptedException, ExecutionException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        UserClass[] userObjects = new UserClass[]{new UserClass<Object>("User Object 0", new Object()), new UserClass<Object>("User Object 1", new Object())};
        CommandModule module = (CommandModule)commandService.run(CommandRawArrayInput.class, true, new Object[]{"userObjects", userObjects}).get();
        Assert.assertEquals((Object)"User Object 0;User Object 1;", (Object)module.getOutput("result"));
    }

    @Test
    public void testArrayConvertFromStringCommandRaw() throws InterruptedException, ExecutionException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        CommandModule module = (CommandModule)commandService.run(CommandRawArrayInput.class, true, new Object[]{"userObjects", "User Object 0,User Object 1"}).get();
        Assert.assertEquals((Object)"User Object 0;User Object 1;", (Object)module.getOutput("result"));
    }

    @Test
    public void testArrayCommandWildcardGenerics() throws InterruptedException, ExecutionException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        UserClass[] userObjects = new UserClass[]{new UserClass<Object>("User Object 0", new Object()), new UserClass<Object>("User Object 1", new Object())};
        CommandModule module = (CommandModule)commandService.run(CommandGenericsWildcardArrayInput.class, true, new Object[]{"userObjects", userObjects}).get();
        Assert.assertEquals((Object)"User Object 0;User Object 1;", (Object)module.getOutput("result"));
    }

    @Test
    public void testArrayConvertFromStringCommandWildcardGenerics() throws InterruptedException, ExecutionException {
        Context context = new Context(new Class[]{CommandService.class});
        CommandService commandService = (CommandService)context.service(CommandService.class);
        CommandModule module = (CommandModule)commandService.run(CommandGenericsWildcardArrayInput.class, true, new Object[]{"userObjects", "User Object 0,User Object 1"}).get();
        Assert.assertEquals((Object)"User Object 0;User Object 1;", (Object)module.getOutput("result"));
    }

    public static class UserClass<T> {
        String name;

        public UserClass(String objectName, T generic_object) {
            this.name = objectName;
        }

        public String toString() {
            return this.name;
        }
    }

    @Plugin(type=Converter.class, priority=-100.0)
    public static class StringToUserClassConverterNoGenerics
    extends AbstractConverter<String, UserClass[]> {
        public <T> T convert(Object src, Class<T> dest) {
            String str = (String)src;
            String[] names = str.split(",");
            UserClass[] userObjects = new UserClass[names.length];
            for (int index = 0; index < names.length; ++index) {
                userObjects[index] = new UserClass<Object>(names[index], new Object());
            }
            return (T)userObjects;
        }

        public Class<UserClass[]> getOutputType() {
            return UserClass[].class;
        }

        public Class<String> getInputType() {
            return String.class;
        }
    }

    @Plugin(type=Command.class)
    public static class CommandGenericsWildcardArrayInput
    implements Command {
        @Parameter
        private UserClass<?>[] userObjects;
        @Parameter(type=ItemIO.OUTPUT)
        private String result = "default";

        public void run() {
            StringBuilder sb = new StringBuilder();
            for (UserClass<?> obj : this.userObjects) {
                sb.append(obj.toString() + ";");
            }
            this.result = sb.toString();
        }
    }

    @Plugin(type=Command.class)
    public static class CommandRawArrayInput
    implements Command {
        @Parameter
        private UserClass[] userObjects;
        @Parameter(type=ItemIO.OUTPUT)
        private String result = "default";

        public void run() {
            StringBuilder sb = new StringBuilder();
            for (UserClass obj : this.userObjects) {
                sb.append(obj.toString() + ";");
            }
            this.result = sb.toString();
        }
    }
}

