/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.util.Bytes;

public abstract class DataHandleTest {
    protected static final byte[] BYTES = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, -128, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 125, 127, -127, -125, -3, -2, -1};
    protected DataHandleService dataHandleService;

    @Before
    public void init() {
        Context context = new Context(new Class[]{DataHandleService.class});
        this.dataHandleService = (DataHandleService)context.service(DataHandleService.class);
    }

    @Test
    public void checkSkip() throws IOException {
        try (DataHandle<? extends Location> handle = this.createHandle();){
            handle.seek(0L);
            handle.skip(10L);
            Assert.assertEquals((long)10L, (long)handle.offset());
            handle.skipBytes(11);
            Assert.assertEquals((long)21L, (long)handle.offset());
        }
    }

    @Test
    public void testEndianesSettings() throws IOException {
        try (DataHandle<? extends Location> handle = this.createHandle();){
            DataHandle.ByteOrder original = handle.getOrder();
            handle.setOrder(DataHandle.ByteOrder.BIG_ENDIAN);
            Assert.assertEquals((Object)DataHandle.ByteOrder.BIG_ENDIAN, (Object)handle.getOrder());
            Assert.assertTrue((boolean)handle.isBigEndian());
            Assert.assertFalse((boolean)handle.isLittleEndian());
            handle.setOrder(DataHandle.ByteOrder.LITTLE_ENDIAN);
            Assert.assertEquals((Object)DataHandle.ByteOrder.LITTLE_ENDIAN, (Object)handle.getOrder());
            Assert.assertFalse((boolean)handle.isBigEndian());
            Assert.assertTrue((boolean)handle.isLittleEndian());
            handle.setLittleEndian(false);
            Assert.assertEquals((Object)DataHandle.ByteOrder.BIG_ENDIAN, (Object)handle.getOrder());
            Assert.assertTrue((boolean)handle.isBigEndian());
            Assert.assertFalse((boolean)handle.isLittleEndian());
            handle.setLittleEndian(true);
            Assert.assertEquals((Object)DataHandle.ByteOrder.LITTLE_ENDIAN, (Object)handle.getOrder());
            Assert.assertFalse((boolean)handle.isBigEndian());
            Assert.assertTrue((boolean)handle.isLittleEndian());
            handle.setOrder(original);
        }
    }

    @Test
    public void testReading() throws IOException {
        try (DataHandle<? extends Location> handle = this.createHandle();){
            this.checkBasicReadMethods(handle, true);
            this.checkEndiannessReading(handle);
        }
    }

    @Test
    public void testWriting() throws IOException {
        try (DataHandle<? extends Location> handle = this.createHandle();){
            this.checkBasicWriteMethods(handle);
            Location loc = this.createLocation();
            this.checkWriteEndianes(() -> (DataHandle)this.dataHandleService.create((Object)loc), DataHandle.ByteOrder.LITTLE_ENDIAN);
            this.checkWriteEndianes(() -> (DataHandle)this.dataHandleService.create((Object)loc), DataHandle.ByteOrder.BIG_ENDIAN);
            this.checkAdvancedStringWriting(() -> (DataHandle)this.dataHandleService.create((Object)loc));
        }
    }

    public abstract Class<? extends DataHandle<?>> getExpectedHandleType();

    public abstract Location createLocation() throws IOException;

    public DataHandle<? extends Location> createHandle() {
        Location loc;
        try {
            loc = this.createLocation();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
        DataHandle handle = (DataHandle)this.dataHandleService.create((Object)loc);
        Assert.assertEquals(this.getExpectedHandleType(), handle.getClass());
        return handle;
    }

    public void populateData(OutputStream out) throws IOException {
        out.write(BYTES);
        out.close();
    }

    public <L extends Location> void checkBasicReadMethods(DataHandle<L> handle, boolean lengthKnown) throws IOException {
        int i;
        Assert.assertEquals((long)0L, (long)handle.offset());
        Assert.assertEquals((long)(lengthKnown ? (long)BYTES.length : -1L), (long)handle.length());
        Assert.assertEquals((Object)"UTF-8", (Object)handle.getEncoding());
        for (int i2 = 0; i2 < BYTES.length; ++i2) {
            Assert.assertEquals((String)this.msg(i2), (long)(0xFF & BYTES[i2]), (long)handle.read());
        }
        Assert.assertEquals((long)-1L, (long)handle.read());
        handle.seek(10L);
        Assert.assertEquals((long)10L, (long)handle.offset());
        Assert.assertEquals((long)BYTES[10], (long)handle.read());
        byte[] buf = new byte[10];
        handle.seek(1L);
        this.assertBytesMatch(1, handle.read(buf), buf);
        handle.seek(0L);
        for (i = 0; i < BYTES.length; ++i) {
            Assert.assertEquals((String)this.msg(i), (long)BYTES[i], (long)handle.readByte());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length; ++i) {
            Assert.assertEquals((String)this.msg(i), (long)(BYTES[i] & 0xFF), (long)handle.readUnsignedByte());
        }
        Arrays.fill(buf, (byte)0);
        handle.seek(3L);
        handle.readFully(buf);
        this.assertBytesMatch(3, buf.length, buf);
        handle.seek(16L);
        this.assertBytesMatch(16, 7, handle.readCString().getBytes());
        handle.seek(42L);
        Assert.assertNull((Object)handle.readCString());
        handle.seek(21L);
        Assert.assertTrue((boolean)handle.readBoolean());
        Assert.assertFalse((boolean)handle.readBoolean());
        handle.seek(7L);
        this.assertBytesMatch(7, 5, handle.readLine().getBytes());
        handle.seek(7L);
        this.assertBytesMatch(7, 5, handle.readString("abcdefg").getBytes());
        handle.seek(7L);
        this.assertBytesMatch(7, 5, handle.readString("d").getBytes());
        handle.seek(7L);
        this.assertBytesMatch(7, 5, handle.readString(5).getBytes());
        handle.seek(1L);
        this.assertBytesMatch(1, 11, handle.findString(new String[]{"world"}).getBytes());
        handle.seek(0L);
        handle.findString(false, new String[]{"world"});
        Assert.assertEquals((long)12L, (long)handle.offset());
        handle.seek(0L);
        handle.findString(false, new String[]{"w"});
        Assert.assertEquals((long)8L, (long)handle.offset());
    }

    public void checkEndiannessReading(DataHandle<? extends Location> handle) throws IOException {
        this.checkEndiannessReading(handle, DataHandle.ByteOrder.LITTLE_ENDIAN);
        this.checkEndiannessReading(handle, DataHandle.ByteOrder.BIG_ENDIAN);
    }

    public void checkEndiannessReading(DataHandle<? extends Location> handle, DataHandle.ByteOrder order) throws IOException {
        int i;
        handle.setOrder(order);
        handle.seek(0L);
        boolean little = order == DataHandle.ByteOrder.LITTLE_ENDIAN;
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 2; i += 2) {
            Assert.assertEquals((String)this.msg(i), (long)((char)Bytes.toShort((byte[])BYTES, (int)i, (boolean)little)), (long)handle.readChar());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 2; i += 2) {
            Assert.assertEquals((String)this.msg(i), (long)Bytes.toShort((byte[])BYTES, (int)i, (boolean)little), (long)handle.readShort());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 4; i += 4) {
            Assert.assertEquals((String)this.msg(i), (long)Bytes.toInt((byte[])BYTES, (int)i, (boolean)little), (long)handle.readInt());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 8; i += 8) {
            Assert.assertEquals((String)this.msg(i), (long)Bytes.toLong((byte[])BYTES, (int)i, (boolean)little), (long)handle.readLong());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 4; i += 4) {
            Assert.assertEquals((String)this.msg(i), (float)Bytes.toFloat((byte[])BYTES, (int)i, (boolean)little), (float)handle.readFloat(), (float)0.0f);
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 8; i += 8) {
            Assert.assertEquals((String)this.msg(i), (double)Bytes.toDouble((byte[])BYTES, (int)i, (boolean)little), (double)handle.readDouble(), (double)0.0);
        }
    }

    public <L extends Location> void checkBasicWriteMethods(DataHandle<L> handle) throws IOException {
        this.checkBasicWrites(handle, handle);
    }

    public <L extends Location> void checkBasicWrites(DataHandle<L> readHandle, DataHandle<L> writeHandle) throws IOException {
        int i;
        byte[] copy = (byte[])BYTES.clone();
        writeHandle.seek(7L);
        String splice = "there";
        for (i = 0; i < "there".length(); ++i) {
            char c = "there".charAt(i);
            writeHandle.write((int)c);
            copy[7 + i] = (byte)c;
        }
        writeHandle.writeBoolean(true);
        copy[12] = 1;
        writeHandle.writeBoolean(false);
        copy[13] = 0;
        writeHandle.writeByte(42);
        copy[14] = 42;
        if (writeHandle != readHandle) {
            writeHandle.close();
        }
        readHandle.seek(0L);
        for (i = 0; i < copy.length; ++i) {
            Assert.assertEquals((String)this.msg(i), (long)(0xFF & copy[i]), (long)readHandle.read());
        }
    }

    public <L extends Location> void checkAdvancedStringWriting(Supplier<DataHandle<L>> handleCreator) throws IOException {
        this.checkAdvancedStringWriting(handleCreator, handleCreator);
    }

    public <L extends Location> void checkAdvancedStringWriting(Supplier<DataHandle<L>> readHandleCreator, Supplier<DataHandle<L>> writeHandleCreator) throws IOException {
        String utfTestString = "abc\u00e4\u00fa\u00f6\u00e4\u00e9\u00eb\u00e5\u00e1\u00f0\u00df\u00ef\u0153\u0153\u00f8\u00b6\ud83e\udd13\ud83c\udf55\ud83d\ude0b";
        try (DataHandle<L> writeHandle = writeHandleCreator.get();){
            writeHandle.writeUTF("abc\u00e4\u00fa\u00f6\u00e4\u00e9\u00eb\u00e5\u00e1\u00f0\u00df\u00ef\u0153\u0153\u00f8\u00b6\ud83e\udd13\ud83c\udf55\ud83d\ude0b");
        }
        var5_5 = null;
        try (DataHandle<L> readHandle = readHandleCreator.get();){
            Assert.assertEquals((Object)"abc\u00e4\u00fa\u00f6\u00e4\u00e9\u00eb\u00e5\u00e1\u00f0\u00df\u00ef\u0153\u0153\u00f8\u00b6\ud83e\udd13\ud83c\udf55\ud83d\ude0b", (Object)readHandle.readUTF());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        String testString = "The quick brown fox jumps over the lazy dog.";
        try (DataHandle<L> writeHandle = writeHandleCreator.get();){
            writeHandle.writeLine("The quick brown fox jumps over the lazy dog.");
        }
        var6_10 = null;
        try (DataHandle<L> readHandle = readHandleCreator.get();){
            Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)readHandle.readLine());
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        String testString2 = "The five boxing wizards jump quickly.";
        try (DataHandle<L> writeHandle = writeHandleCreator.get();){
            writeHandle.writeChars("The five boxing wizards jump quickly.");
        }
        var7_16 = null;
        try (DataHandle<L> readHandle = readHandleCreator.get();){
            for (int i = 0; i < "The five boxing wizards jump quickly.".length(); ++i) {
                Assert.assertEquals((long)"The five boxing wizards jump quickly.".charAt(i), (long)readHandle.readChar());
            }
        }
        catch (Throwable throwable) {
            var7_16 = throwable;
            throw throwable;
        }
    }

    public <L extends Location> void checkWriteEndianes(Supplier<DataHandle<L>> handleCreator, DataHandle.ByteOrder order) throws IOException {
        this.checkWriteEndianes(handleCreator, handleCreator, order);
    }

    public <L extends Location> void checkWriteEndianes(Supplier<DataHandle<L>> readHandleCreator, Supplier<DataHandle<L>> writeHandleCreator, DataHandle.ByteOrder order) throws IOException {
        int i;
        boolean little = order == DataHandle.ByteOrder.LITTLE_ENDIAN;
        try (DataHandle<L> writeHandle = writeHandleCreator.get();){
            writeHandle.setOrder(order);
            for (i = 0; i < BYTES.length / 2; i += 2) {
                writeHandle.writeChar(Bytes.toInt((byte[])BYTES, (int)i, (int)2, (boolean)little));
            }
        }
        var6_6 = null;
        try (DataHandle<L> readHandle = readHandleCreator.get();){
            readHandle.setOrder(order);
            for (i = 0; i < BYTES.length / 2; i += 2) {
                Assert.assertEquals((String)this.msg(i), (long)Bytes.toShort((byte[])BYTES, (int)i, (boolean)little), (long)readHandle.readChar());
            }
        }
        catch (Throwable i2) {
            var6_6 = i2;
            throw i2;
        }
        writeHandle = writeHandleCreator.get();
        var6_6 = null;
        try {
            writeHandle.setOrder(order);
            for (int i3 = 0; i3 < BYTES.length / 2; i3 += 2) {
                writeHandle.writeShort((int)Bytes.toShort((byte[])BYTES, (int)i3, (boolean)little));
            }
        }
        catch (Throwable i3) {
            var6_6 = i3;
            throw i3;
        }
        finally {
            if (writeHandle != null) {
                if (var6_6 != null) {
                    try {
                        writeHandle.close();
                    }
                    catch (Throwable i3) {
                        var6_6.addSuppressed(i3);
                    }
                } else {
                    writeHandle.close();
                }
            }
        }
        readHandle = readHandleCreator.get();
        var6_6 = null;
        try {
            readHandle.setOrder(order);
            for (int i4 = 0; i4 < BYTES.length / 2; i4 += 2) {
                Assert.assertEquals((String)this.msg(i4), (long)Bytes.toShort((byte[])BYTES, (int)i4, (boolean)little), (long)readHandle.readShort());
            }
        }
        catch (Throwable i4) {
            var6_6 = i4;
            throw i4;
        }
        finally {
            if (readHandle != null) {
                if (var6_6 != null) {
                    try {
                        readHandle.close();
                    }
                    catch (Throwable i4) {
                        var6_6.addSuppressed(i4);
                    }
                } else {
                    readHandle.close();
                }
            }
        }
        writeHandle = writeHandleCreator.get();
        var6_6 = null;
        try {
            writeHandle.setOrder(order);
            for (int i5 = 0; i5 < BYTES.length / 4; i5 += 4) {
                writeHandle.writeInt(Bytes.toInt((byte[])BYTES, (int)i5, (boolean)little));
            }
        }
        catch (Throwable i5) {
            var6_6 = i5;
            throw i5;
        }
        finally {
            if (writeHandle != null) {
                if (var6_6 != null) {
                    try {
                        writeHandle.close();
                    }
                    catch (Throwable i5) {
                        var6_6.addSuppressed(i5);
                    }
                } else {
                    writeHandle.close();
                }
            }
        }
        readHandle = readHandleCreator.get();
        var6_6 = null;
        try {
            readHandle.setOrder(order);
            for (int i6 = 0; i6 < BYTES.length / 4; i6 += 4) {
                Assert.assertEquals((String)this.msg(i6), (long)Bytes.toInt((byte[])BYTES, (int)i6, (boolean)little), (long)readHandle.readInt());
            }
        }
        catch (Throwable i6) {
            var6_6 = i6;
            throw i6;
        }
        finally {
            if (readHandle != null) {
                if (var6_6 != null) {
                    try {
                        readHandle.close();
                    }
                    catch (Throwable i6) {
                        var6_6.addSuppressed(i6);
                    }
                } else {
                    readHandle.close();
                }
            }
        }
        writeHandle = writeHandleCreator.get();
        var6_6 = null;
        try {
            writeHandle.setOrder(order);
            for (int i7 = 0; i7 < BYTES.length / 8; i7 += 8) {
                writeHandle.writeLong(Bytes.toLong((byte[])BYTES, (int)i7, (boolean)little));
            }
        }
        catch (Throwable i7) {
            var6_6 = i7;
            throw i7;
        }
        finally {
            if (writeHandle != null) {
                if (var6_6 != null) {
                    try {
                        writeHandle.close();
                    }
                    catch (Throwable i7) {
                        var6_6.addSuppressed(i7);
                    }
                } else {
                    writeHandle.close();
                }
            }
        }
        readHandle = readHandleCreator.get();
        var6_6 = null;
        try {
            readHandle.setOrder(order);
            for (int i8 = 0; i8 < BYTES.length / 8; i8 += 8) {
                Assert.assertEquals((String)this.msg(i8), (long)Bytes.toLong((byte[])BYTES, (int)i8, (boolean)little), (long)readHandle.readLong());
            }
        }
        catch (Throwable i8) {
            var6_6 = i8;
            throw i8;
        }
        finally {
            if (readHandle != null) {
                if (var6_6 != null) {
                    try {
                        readHandle.close();
                    }
                    catch (Throwable i8) {
                        var6_6.addSuppressed(i8);
                    }
                } else {
                    readHandle.close();
                }
            }
        }
        writeHandle = writeHandleCreator.get();
        var6_6 = null;
        try {
            writeHandle.setOrder(order);
            for (int i9 = 0; i9 < BYTES.length / 4; i9 += 4) {
                writeHandle.writeFloat(Bytes.toFloat((byte[])BYTES, (int)i9, (boolean)little));
            }
        }
        catch (Throwable i9) {
            var6_6 = i9;
            throw i9;
        }
        finally {
            if (writeHandle != null) {
                if (var6_6 != null) {
                    try {
                        writeHandle.close();
                    }
                    catch (Throwable i9) {
                        var6_6.addSuppressed(i9);
                    }
                } else {
                    writeHandle.close();
                }
            }
        }
        readHandle = readHandleCreator.get();
        var6_6 = null;
        try {
            readHandle.setOrder(order);
            for (int i10 = 0; i10 < BYTES.length / 4; i10 += 4) {
                Assert.assertEquals((String)this.msg(i10), (float)Bytes.toFloat((byte[])BYTES, (int)i10, (boolean)little), (float)readHandle.readFloat(), (float)0.0f);
            }
        }
        catch (Throwable i10) {
            var6_6 = i10;
            throw i10;
        }
        finally {
            if (readHandle != null) {
                if (var6_6 != null) {
                    try {
                        readHandle.close();
                    }
                    catch (Throwable i10) {
                        var6_6.addSuppressed(i10);
                    }
                } else {
                    readHandle.close();
                }
            }
        }
        writeHandle = writeHandleCreator.get();
        var6_6 = null;
        try {
            writeHandle.setOrder(order);
            for (int i11 = 0; i11 < BYTES.length / 8; i11 += 8) {
                writeHandle.writeDouble(Bytes.toDouble((byte[])BYTES, (int)i11, (boolean)little));
            }
        }
        catch (Throwable i11) {
            var6_6 = i11;
            throw i11;
        }
        finally {
            if (writeHandle != null) {
                if (var6_6 != null) {
                    try {
                        writeHandle.close();
                    }
                    catch (Throwable i11) {
                        var6_6.addSuppressed(i11);
                    }
                } else {
                    writeHandle.close();
                }
            }
        }
        readHandle = readHandleCreator.get();
        var6_6 = null;
        try {
            readHandle.setOrder(order);
            for (int i12 = 0; i12 < BYTES.length / 8; i12 += 8) {
                Assert.assertEquals((String)this.msg(i12), (double)Bytes.toDouble((byte[])BYTES, (int)i12, (boolean)little), (double)readHandle.readDouble(), (double)0.0);
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (readHandle != null) {
                if (var6_6 != null) {
                    try {
                        readHandle.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    readHandle.close();
                }
            }
        }
    }

    public void assertBytesMatch(int offset, int length, byte[] b) {
        Assert.assertEquals((long)length, (long)b.length);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((String)this.msg(i), (long)BYTES[i + offset], (long)b[i]);
        }
    }

    public String msg(int i) {
        return "[" + i + "]:";
    }
}

