/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.convert.StringToArrayConverter;
import org.scijava.parse.ParseService;

public class StringToArrayConverterTest {
    private final StringToArrayConverter converter = new StringToArrayConverter();
    private ConvertService convertService;
    private Context context;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{ParseService.class, ConvertService.class});
        this.context.inject((Object)this.converter);
        this.convertService = (ConvertService)this.context.getService(ConvertService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testArrayConversion() {
        List<Class> classes = Arrays.asList(byte[].class, Byte[].class, short[].class, Short[].class, int[].class, Integer[].class, long[].class, Long[].class, float[].class, Float[].class, double[].class, Double[].class);
        String s = "{0, 1, 2}";
        for (Class arrayClass : classes) {
            Assert.assertTrue((boolean)this.converter.canConvert((Object)s, arrayClass));
            Object converted = this.converter.convert((Object)s, arrayClass);
            Assert.assertEquals((Object)arrayClass, converted.getClass());
            Class<?> c = arrayClass.getComponentType();
            for (int i = 0; i < 3; ++i) {
                Object expected = this.convertService.convert((Object)i, c);
                Assert.assertEquals((Object)expected, (Object)Array.get(converted, i));
            }
        }
    }

    @Test
    public void test2DArrayConversion() {
        String s = "{{0, 1}, {2, 3}}";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, byte[][].class));
        byte[][] actual = (byte[][])this.converter.convert((Object)s, byte[][].class);
        Assert.assertEquals((long)0L, (long)actual[0][0]);
        Assert.assertEquals((long)1L, (long)actual[0][1]);
        Assert.assertEquals((long)2L, (long)actual[1][0]);
        Assert.assertEquals((long)3L, (long)actual[1][1]);
    }

    @Test
    public void test3DArrayConversion() {
        String s = "{{{0, 1}, {1, 2}},{{1, 2}, {2, 3}}}";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, byte[][][].class));
        byte[][][] actual = (byte[][][])this.converter.convert((Object)s, byte[][][].class);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    Assert.assertEquals((long)(i + j + k), (long)actual[i][j][k]);
                }
            }
        }
    }

    @Test
    public void testEmptyArrayConversion() {
        String s = "{}";
        Assert.assertTrue((boolean)this.converter.canConvert((Object)s, byte[].class));
        byte[] actual = (byte[])this.converter.convert((Object)s, byte[].class);
        Assert.assertEquals((long)0L, (long)actual.length);
    }

    @Test
    public void testStringArrayConversion() {
        Object[] expected = new String[]{"{foo", "bar}", "ha\nha", "foo,bar", "lol\"lol", "foo\\\"bar"};
        String converted = (String)this.convertService.convert((Object)expected, String.class);
        Assert.assertEquals((Object)"{\"{foo\", \"bar}\", \"ha\nha\", \"foo,bar\", \"lol\\\"lol\", \"foo\\\\\\\"bar\"}", (Object)converted);
        Object[] actual = (String[])this.convertService.convert((Object)converted, String[].class);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testCharacterArrayConversion() {
        Object[] expected = new Character[]{Character.valueOf('s'), Character.valueOf('\n'), Character.valueOf(','), Character.valueOf('{'), Character.valueOf('}')};
        String converted = (String)this.convertService.convert((Object)expected, String.class);
        Assert.assertEquals((Object)"{\"s\", \"\n\", \",\", \"{\", \"}\"}", (Object)converted);
        Object[] actual = (Character[])this.convertService.convert((Object)converted, Character[].class);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testStringToDoubleArraySingleValue() {
        Assert.assertArrayEquals((double[])new double[]{5.0}, (double[])((double[])this.converter.convert((Object)"5", double[].class)), (double)0.0);
        Assert.assertArrayEquals((Object[])new Double[]{6.0}, (Object[])((Object[])this.converter.convert((Object)"6", Double[].class)));
        Assert.assertArrayEquals((Object[])new double[][]{{7.0}}, (Object[])((Object[])this.converter.convert((Object)"7", double[][].class)));
        Assert.assertArrayEquals((Object[])new Double[][]{{8.0}}, (Object[])((Object[])this.converter.convert((Object)"8", Double[][].class)));
        Assert.assertArrayEquals((double[])new double[]{0.0}, (double[])((double[])this.converter.convert((Object)"spinach", double[].class)), (double)0.0);
        Assert.assertArrayEquals((Object[])new Double[]{null}, (Object[])((Object[])this.converter.convert((Object)"kale", Double[].class)));
        Assert.assertArrayEquals((Object[])new double[][]{{0.0}}, (Object[])((Object[])this.converter.convert((Object)"broccoli", double[][].class)));
        Assert.assertArrayEquals((Object[])new Double[][]{{null}}, (Object[])((Object[])this.converter.convert((Object)"lettuce", Double[][].class)));
    }

    @Test
    public void testStringToDoubleArray1D() {
        Assert.assertArrayEquals((double[])new double[]{0.0, 1.0, 2.0, 3.0}, (double[])((double[])this.converter.convert((Object)"{0, 1, 2, 3}", double[].class)), (double)0.0);
        Assert.assertArrayEquals((Object[])new Double[]{7.0, 11.0}, (Object[])((Object[])this.converter.convert((Object)"{7, 11}", Double[].class)));
        Assert.assertArrayEquals((Object[])new Double[]{0.0, 1.0, 2.0, 3.0}, (Object[])((Object[])this.converter.convert((Object)"{0, 1, 2, 3}", Double[].class)));
        Assert.assertArrayEquals((double[])new double[]{0.0, 1.0, 0.0, 3.0}, (double[])((double[])this.converter.convert((Object)"{0, 1, kumquat, 3}", double[].class)), (double)0.0);
        Assert.assertArrayEquals((Object[])new Double[]{4.0, null, 5.0}, (Object[])((Object[])this.converter.convert((Object)"{4, eggplant, 5}", Double[].class)));
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.0, 0.0}, (double[])((double[])this.converter.convert((Object)"{uno, dos, tres}", double[].class)), (double)0.0);
        Assert.assertArrayEquals((Object[])new Double[]{null, null, null, null}, (Object[])((Object[])this.converter.convert((Object)"{cuatro, cinco, seis, siete}", Double[].class)));
    }

    @Test
    public void testStringToDoubleArray2D() {
        Assert.assertArrayEquals((Object[])new double[][]{{0.0, 1.0}, {2.0, 3.0, 4.0}}, (Object[])((Object[])this.converter.convert((Object)"{{0, 1}, {2, 3, 4}}", double[][].class)));
        Assert.assertArrayEquals((Object[])new Double[][]{{7.0, 11.0}, {13.0, 17.0, 19.0}}, (Object[])((Object[])this.converter.convert((Object)"{{7, 11}, {13, 17, 19}}", Double[][].class)));
        Assert.assertArrayEquals((Object[])new Double[][]{{0.0, 1.0}, {2.0, 3.0}}, (Object[])((Object[])this.converter.convert((Object)"{{0, 1}, {2, 3}}", Double[][].class)));
        Assert.assertArrayEquals((Object[])new double[][]{{0.0, 1.0}, {0.0, 3.0}}, (Object[])((Object[])this.converter.convert((Object)"{{0, 1}, {kumquat, 3}}", double[][].class)));
        Assert.assertArrayEquals((Object[])new Double[][]{{4.0}, {null, 5.0}, {null}}, (Object[])((Object[])this.converter.convert((Object)"{{4}, {eggplant, 5}, {squash}}", Double[][].class)));
        Assert.assertArrayEquals((Object[])new double[][]{{0.0}, {0.0, 0.0}}, (Object[])((Object[])this.converter.convert((Object)"{{uno}, {dos, tres}}", double[][].class)));
        Assert.assertArrayEquals((Object[])new Double[][]{{null, null}, {null, null}}, (Object[])((Object[])this.converter.convert((Object)"{{cuatro, cinco}, {seis, siete}}", Double[][].class)));
    }

    @Test
    public void testStringToDoubleArray3D() {
        Random r = new Random(-629491106L);
        double[][][] ds = new double[r.nextInt(10)][][];
        for (int i = 0; i < ds.length; ++i) {
            ds[i] = new double[r.nextInt(10)][];
            for (int j = 0; j < ds[i].length; ++j) {
                ds[i][j] = new double[r.nextInt(10)];
                for (int k = 0; k < ds[i][j].length; ++k) {
                    ds[i][j][k] = 10000.0 * r.nextDouble();
                }
            }
        }
        String ss = Arrays.deepToString((Object[])ds).replace('[', '{').replace(']', '}');
        Assert.assertArrayEquals((Object[])ds, (Object[])((Object[])this.converter.convert((Object)ss, double[][][].class)));
    }
}

