/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import org.scijava.common3.Comparisons;

public final class Classes {
    private Classes() {
    }

    public static ClassLoader classLoader() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        return contextCL != null ? contextCL : ClassLoader.getSystemClassLoader();
    }

    public static Class<?> load(String name) {
        return Classes.load(name, null, true);
    }

    public static Class<?> load(String name, ClassLoader classLoader) {
        return Classes.load(name, classLoader, true);
    }

    public static Class<?> load(String className, boolean quietly) {
        return Classes.load(className, null, quietly);
    }

    public static Class<?> load(String name, ClassLoader classLoader, boolean quietly) {
        if (name.equals("Z") || name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("B") || name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("C") || name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("D") || name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("F") || name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("I") || name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("J") || name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("S") || name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("V") || name.equals("void")) {
            return Void.TYPE;
        }
        String className = name.equals("string") ? "java.lang.String" : name;
        if (name.endsWith("[]")) {
            String elementClassName = name.substring(0, name.length() - 2);
            return Classes.arrayOrNull(Classes.load(elementClassName, classLoader));
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            String elementClassName = name.substring(2, name.length() - 1);
            return Classes.arrayOrNull(Classes.load(elementClassName, classLoader));
        }
        if (name.startsWith("[")) {
            String elementClassName = name.substring(1);
            return Classes.arrayOrNull(Classes.load(elementClassName, classLoader));
        }
        try {
            ClassLoader cl = classLoader == null ? Classes.classLoader() : classLoader;
            return cl.loadClass(className);
        }
        catch (Throwable t) {
            if (quietly) {
                return null;
            }
            throw Classes.iae(t, "Cannot load class: %s", className);
        }
    }

    public static URL location(Class<?> c) {
        return Classes.location(c, true);
    }

    public static URL location(Class<?> c, boolean quietly) {
        String suffix;
        SecurityException cause = null;
        String why = null;
        try {
            CodeSource codeSource = c.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL location = codeSource.getLocation();
                if (location != null) {
                    return location;
                }
                why = "null code source location";
            } else {
                why = "null code source";
            }
        }
        catch (SecurityException exc) {
            cause = exc;
            why = "cannot access protection domain";
        }
        URL classResource = c.getResource(c.getSimpleName() + ".class");
        if (classResource == null) {
            if (quietly) {
                return null;
            }
            throw Classes.iae(cause, "No class resource for class: %s (%s)", c.getName(), why);
        }
        String url = classResource.toString();
        if (!url.endsWith(suffix = c.getCanonicalName().replace('.', '/') + ".class")) {
            if (quietly) {
                return null;
            }
            throw Classes.iae(cause, "Unsupported URL format: %s (%s)", url, why);
        }
        String base = url.substring(0, url.length() - suffix.length());
        String path = base;
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.length() - 2);
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            if (quietly) {
                return null;
            }
            throw Classes.iae(e, "Malformed URL: %s (%s)", path, why);
        }
    }

    public static boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || Boolean.class.isAssignableFrom(type);
    }

    public static boolean isByte(Class<?> type) {
        return type == Byte.TYPE || Byte.class.isAssignableFrom(type);
    }

    public static boolean isCharacter(Class<?> type) {
        return type == Character.TYPE || Character.class.isAssignableFrom(type);
    }

    public static boolean isDouble(Class<?> type) {
        return type == Double.TYPE || Double.class.isAssignableFrom(type);
    }

    public static boolean isFloat(Class<?> type) {
        return type == Float.TYPE || Float.class.isAssignableFrom(type);
    }

    public static boolean isInteger(Class<?> type) {
        return type == Integer.TYPE || Integer.class.isAssignableFrom(type);
    }

    public static boolean isLong(Class<?> type) {
        return type == Long.TYPE || Long.class.isAssignableFrom(type);
    }

    public static boolean isShort(Class<?> type) {
        return type == Short.TYPE || Short.class.isAssignableFrom(type);
    }

    public static boolean isNumber(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Byte.TYPE || type == Double.TYPE || type == Float.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE;
    }

    public static boolean isText(Class<?> type) {
        return String.class.isAssignableFrom(type) || Classes.isCharacter(type);
    }

    public static <T> Class<T> box(Class<T> type) {
        Class destType = type == Boolean.TYPE ? Boolean.class : (type == Byte.TYPE ? Byte.class : (type == Character.TYPE ? Character.class : (type == Double.TYPE ? Double.class : (type == Float.TYPE ? Float.class : (type == Integer.TYPE ? Integer.class : (type == Long.TYPE ? Long.class : (type == Short.TYPE ? Short.class : (type == Void.TYPE ? Void.class : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> Class<T> unbox(Class<T> type) {
        Class<Object> destType = type == Boolean.class ? Boolean.TYPE : (type == Byte.class ? Byte.TYPE : (type == Character.class ? Character.TYPE : (type == Double.class ? Double.TYPE : (type == Float.class ? Float.TYPE : (type == Integer.class ? Integer.TYPE : (type == Long.class ? Long.TYPE : (type == Short.class ? Short.TYPE : (type == Void.class ? Void.TYPE : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> T nullValue(Class<T> type) {
        Serializable defaultValue = type == Boolean.TYPE ? Boolean.valueOf(false) : (type == Byte.TYPE ? Byte.valueOf((byte)0) : (type == Character.TYPE ? (Serializable)Character.valueOf('\u0000') : (Serializable)(type == Double.TYPE ? (Number)0.0 : (Number)(type == Float.TYPE ? (Number)Float.valueOf(0.0f) : (Number)(type == Integer.TYPE ? (Number)0 : (Number)(type == Long.TYPE ? (Number)0L : (Number)(type == Short.TYPE ? Short.valueOf((short)0) : null)))))));
        Boolean result = defaultValue;
        return (T)result;
    }

    public static Field field(Class<?> c, String name) {
        if (c == null) {
            throw Classes.iae(null, "No such field: %s", name);
        }
        try {
            return c.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            return Classes.field(c.getSuperclass(), name);
        }
    }

    public static Method method(Class<?> c, String name, Class<?> ... parameterTypes) {
        if (c == null) {
            throw Classes.iae(null, "No such field: %s", name);
        }
        try {
            return c.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Classes.method(c.getSuperclass(), name, parameterTypes);
        }
    }

    public static Class<?> array(Class<?> componentType) {
        if (componentType == null) {
            return null;
        }
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Class<?> array(Class<?> componentType, int dim) {
        if (dim < 0) {
            throw Classes.iae(null, "Negative dimension", new String[0]);
        }
        if (dim == 0) {
            return componentType;
        }
        return Classes.array(Classes.array(componentType), dim - 1);
    }

    public static int compare(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return 0;
        }
        String name1 = c1 == null ? null : c1.getName();
        String name2 = c2 == null ? null : c2.getName();
        return Comparisons.compare(name1, name2);
    }

    private static Class<?> arrayOrNull(Class<?> componentType) {
        try {
            return Classes.array(componentType);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    private static IllegalArgumentException iae(Throwable cause, String formattedMessage, String ... values) {
        String s = String.format(formattedMessage, values);
        IllegalArgumentException exc = new IllegalArgumentException(s);
        if (cause != null) {
            exc.initCause(cause);
        }
        return exc;
    }
}

