/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.http.RequestBuilder;
import fitnesse.http.Response;
import fitnesse.http.ResponseParser;
import java.io.IOException;
import util.CommandLine;

public class Shutdown {
    public String hostname = "localhost";
    public int port = 80;
    public String username;
    public String password;
    private CommandLine commandLine = new CommandLine("[-h hostname] [-p port] [-c username password]");

    public static void main(String[] args) throws Exception {
        Shutdown shutdown = new Shutdown();
        shutdown.run(args);
    }

    private void run(String[] args) throws Exception {
        ResponseParser response;
        String status;
        if (!this.parseArgs(args)) {
            this.usage();
        }
        if (!"OK".equals(status = this.checkResponse(response = this.buildAndSendRequest()))) {
            System.err.println("Failed to shutdown.");
            System.err.println(status);
            System.exit(response.getStatus());
        }
    }

    public ResponseParser buildAndSendRequest() throws IOException {
        RequestBuilder request = this.buildRequest();
        ResponseParser response = ResponseParser.performHttpRequest((String)this.hostname, (int)this.port, (RequestBuilder)request);
        return response;
    }

    public RequestBuilder buildRequest() {
        RequestBuilder request = new RequestBuilder("/?responder=shutdown");
        if (this.username != null) {
            request.addCredentials(this.username, this.password);
        }
        return request;
    }

    public String checkResponse(ResponseParser response) {
        int status = response.getStatus();
        String serverHeader = response.getHeader("Server");
        if (serverHeader == null || !serverHeader.contains("FitNesse")) {
            return "Not a FitNesse server";
        }
        if (status != 200) {
            return status + " " + Response.getReasonPhrase((int)status);
        }
        return "OK";
    }

    public boolean parseArgs(String[] args) {
        if (!this.commandLine.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption("h")) {
            this.hostname = this.commandLine.getOptionArgument("h", "hostname");
        }
        if (this.commandLine.hasOption("p")) {
            this.port = Integer.parseInt(this.commandLine.getOptionArgument("p", "port"));
        }
        if (this.commandLine.hasOption("c")) {
            this.username = this.commandLine.getOptionArgument("c", "username");
            this.password = this.commandLine.getOptionArgument("c", "password");
        }
        return true;
    }

    public void usage() {
        System.err.println("Usage: java fitnesse.Shutdown [-hpc]");
        System.err.println("\t-h <hostname> {localhost}");
        System.err.println("\t-p <port number> {80}");
        System.err.println("\t-c <username> <password> Supply user credentials.  Use when FitNesse has authentication activated.");
        System.exit(-1);
    }
}

